/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.trigger;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.global.Principle;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TrgTypeText;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.TriggerUIInfo;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.GroupPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.ItemPane;
import com.owon.uppersoft.dso.view.trigger.ChannelSelectItemListner;
import com.owon.uppersoft.dso.view.trigger.ChannelSelectionPane;
import com.owon.uppersoft.dso.view.trigger.EdgePane;
import com.owon.uppersoft.dso.view.trigger.PulsePane;
import com.owon.uppersoft.dso.view.trigger.SlopePane;
import com.owon.uppersoft.dso.view.trigger.TriggerLoaderPane;
import com.owon.uppersoft.dso.view.trigger.VideoPane;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.ExcludeButtons;
import com.owon.uppersoft.vds.ui.widget.custom.HCLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class TriggerPane
extends FunctionPanel {
    private boolean listening = false;
    private PropertyChangeListener single_alt_PCL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!TriggerPane.this.isListening()) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("exclude")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                TriggerPane.this.tc.c_setChannelMode(n);
                TriggerPane.this.updateChl_loadTrgCtrl();
                TriggerPane.this.updateTrgVoltPane();
                TriggerPane.this.mw.getTitlePane().updateBtnSingle();
            }
        }
    };
    private GroupPane snaPart;
    private GroupPane channelPart;
    private GroupPane modePart;
    private ExcludeButtons single_alt_btns;
    private CComboBox cbbmode;
    private ChannelSelectionPane chlp;
    private JPanel promptPart;
    private MainWindow mw = Platform.getMainWindow();
    private TriggerControl tc;
    private TriggerLoaderPane[] tlps;
    private TriggerLoaderPane selectPane;
    private JCheckBox cbtn;
    private DefaultComboBoxModel trgTypeModel;

    public void simpleSelectCBBMode(TrgTypeDefine trgTypeDefine) {
        this.setListening(false);
        this.selectTrgTypeComboBox(trgTypeDefine);
        this.setListening(true);
    }

    private void selectTrgTypeComboBox(TrgTypeDefine trgTypeDefine) {
        int n = this.trgTypeModel.getIndexOf(new TrgTypeText(trgTypeDefine));
        if (n < 0) {
            return;
        }
        this.cbbmode.setSelectedIndex(n);
    }

    private void updateChl_loadTrgCtrl() {
        this.updateChlPane();
        this.loadTriggerControl();
        this.chlp.onSingleTrgForEdgeChannelSelectJudge();
    }

    public final void updateTrgVoltPane() {
        this.mw.re_paint();
        this.mw.getToolPane().getTrgInfoPane().updateInfos(this.tc);
    }

    public MainWindow getMainWindow() {
        return this.mw;
    }

    public TriggerControl getTriggerControl() {
        return this.tc;
    }

    public TriggerPane(ControlManager controlManager) {
        super(controlManager);
        this.tc = controlManager.getTriggerControl();
        Principle principle = controlManager.getPrinciple();
        this.tlps = new TriggerLoaderPane[TrgTypeDefine.VALUES.length];
        this.setListening(false);
        this.snaPart = this.ncgp();
        String[] stringArray = TriggerDefine.SINGLE_ALT;
        int n = this.tc.getChannelMode();
        if (!this.tc.isAlternativeSupport()) {
            stringArray = new String[]{stringArray[0]};
        }
        this.single_alt_btns = new ExcludeButtons(LObject.getLObjects(stringArray), this.single_alt_PCL, n, 130, 60, FontCenter.getLabelFont());
        this.nrip().add(this.single_alt_btns);
        this.channelPart = this.ncgp();
        ItemPane itemPane = this.nrip();
        this.nlbl("M.Trg.Source");
        this.chlp = new ChannelSelectionPane(controlManager.getMachine().isExtTrgSupport(), this.tc, this, controlManager.getCoreControl().getWaveFormInfoControl(), this.createChannelSelectItemListner(this, this.tc));
        itemPane.add(this.chlp);
        int n2 = controlManager.getSupportChannelsNumber();
        if (n2 == 1) {
            this.chlp.getChannelsComboBox().setEnabled(false);
        }
        this.modePart = this.ncgp();
        this.nrip();
        this.nlbl("M.Trg.Mode");
        Vector<TrgTypeText> vector = new Vector<TrgTypeText>();
        for (TrgTypeDefine trgTypeDefine : TrgTypeDefine.VALUES) {
            if (trgTypeDefine == TrgTypeDefine.Video && !controlManager.getMachine().isVideoTrgSupport()) continue;
            vector.add(new TrgTypeText(trgTypeDefine));
        }
        this.trgTypeModel = new DefaultComboBoxModel(vector);
        this.cbbmode = this.nccb(this.trgTypeModel);
        this.promptPart = this.ncgp();
        this.nrip();
        this.nlbl("M.Utility.MachineNet.TipsTitle");
        this.nrip().setPreferredSize(new Dimension(250, 70));
        HCLabel hCLabel = this.nlbld("M.Trg.Hide");
        hCLabel.setEditable(false);
        if (controlManager.getMachine().isTrgEdgeMiddleSupport()) {
            this.cbtn = new CCheckBox();
            final TriggerUIInfo triggerUIInfo = this.tc.getTriggerUIInfo();
            this.cbtn.setSelected(triggerUIInfo.isAuto_trglevel_middle());
            this.cbtn.setFont(FontCenter.getLabelFont());
            this.cbtn.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    triggerUIInfo.setAuto_trglevel_middle(TriggerPane.this.cbtn.isSelected());
                }
            });
            this.add(this.cbtn);
        }
        this.loadTriggerControl();
        this.localizeSelf();
        this.cbbmode.addItemListener(this.createTrgModeItemLisnter(this, this.tc, this.chlp));
        this.setListening(true);
        this.updateChlPane();
        this.setTrgPaneVisible(this.tc.isTrgEnable());
    }

    protected abstract ItemListener createTrgModeItemLisnter(TriggerPane var1, TriggerControl var2, ChannelSelectionPane var3);

    protected abstract ChannelSelectItemListner createChannelSelectItemListner(TriggerPane var1, TriggerControl var2);

    private void updateChlPane() {
        this.chlp.updateChlPane();
    }

    private void loadTriggerControl() {
        this.setListening(false);
        TriggerUIInfo triggerUIInfo = this.tc.getTriggerUIInfo();
        int n = triggerUIInfo.getCurrentChannel();
        this.chlp.setChannel(n);
        AbsTrigger absTrigger = triggerUIInfo.getCurrentTriggerSet().getTrigger();
        TrgTypeDefine trgTypeDefine = absTrigger.type;
        this.selectTrgTypeComboBox(trgTypeDefine);
        this.switch2Pane(trgTypeDefine);
        this.setListening(true);
    }

    private TriggerLoaderPane getTriggerLoaderPane(TrgTypeDefine trgTypeDefine) {
        int n = trgTypeDefine.ordinal();
        TriggerLoaderPane triggerLoaderPane = this.tlps[n];
        if (triggerLoaderPane == null) {
            switch (trgTypeDefine) {
                case Slope: {
                    triggerLoaderPane = new SlopePane(this);
                    break;
                }
                case Edge: {
                    triggerLoaderPane = new EdgePane(this);
                    break;
                }
                case Video: {
                    triggerLoaderPane = new VideoPane(this);
                    break;
                }
                case Pulse: {
                    triggerLoaderPane = new PulsePane(this);
                }
            }
            this.tlps[n] = triggerLoaderPane;
        }
        return triggerLoaderPane;
    }

    public TriggerLoaderPane switch2Pane(TrgTypeDefine trgTypeDefine) {
        if (this.selectPane != null) {
            this.modePart.remove(this.selectPane);
        }
        this.selectPane = this.getTriggerLoaderPane(trgTypeDefine);
        this.selectPane.loadTrigger(this.getTriggerUIInfo().getCurrentChannel());
        this.selectPane.localizeSelf();
        this.modePart.add((Component)this.selectPane, "Center");
        this.modePart.revalidate();
        this.modePart.repaint();
        return this.selectPane;
    }

    public TriggerUIInfo getTriggerUIInfo() {
        return this.tc.getTriggerUIInfo();
    }

    public TriggerLoaderPane getSelectPane() {
        return this.selectPane;
    }

    protected TriggerSet curTrgSet() {
        return this.getTriggerUIInfo().getCurrentTriggerSet();
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        super.localize(resourceBundle);
        this.selectPane.localize(resourceBundle);
        if (this.cbtn != null) {
            this.cbtn.setText(resourceBundle.getString("M.Trg.auto_trglevel_middle"));
        }
    }

    public void bodySend() {
        this.tc.doSubmit();
    }

    public void submitHoldOff(int n, TriggerLoaderPane triggerLoaderPane) {
        this.tc.getVTPatchable().submitHoldOff(n, triggerLoaderPane.getTrigger());
    }

    private void setTrgPaneVisible(boolean bl) {
        this.snaPart.setVisible(bl);
        this.channelPart.setVisible(bl);
        this.modePart.setVisible(bl);
        this.promptPart.setVisible(!bl);
        if (this.cbtn != null) {
            this.cbtn.setVisible(bl);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TriggerLoaderPane triggerLoaderPane = this.getSelectPane();
        if (triggerLoaderPane == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("APPLY_TRIGGER")) {
            this.setListening(false);
            this.single_alt_btns.setSelected(this.tc.getChannelMode());
            this.updateChl_loadTrgCtrl();
            return;
        }
        if (string.equals("NextSingleChannel")) {
            this.chlp.updateSingleChannel();
        } else if (string.equals("SwitchSlowMove")) {
            this.setTrgPaneVisible(true);
        } else if (string.equals("SwitchNormalMove")) {
            this.setTrgPaneVisible(true);
        } else if (string.equals("CHOOSE_TRGMODECB")) {
            TrgTypeDefine trgTypeDefine = (TrgTypeDefine)((Object)propertyChangeEvent.getNewValue());
            this.simpleSelectCBBMode(trgTypeDefine);
        }
        triggerLoaderPane.fireProperty(propertyChangeEvent);
    }

    public void setListening(boolean bl) {
        this.listening = bl;
    }

    public boolean isListening() {
        return this.listening;
    }
}

