/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.trigger;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.SlopeTrigger;
import com.owon.uppersoft.dso.model.trigger.TrgCheckType;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerDefine;
import com.owon.uppersoft.dso.model.trigger.common.Thredshold;
import com.owon.uppersoft.dso.model.trigger.condition.TrgConditionSpinnerModel;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_Holdoff;
import com.owon.uppersoft.dso.model.trigger.helper.LabelValueUnitContactor;
import com.owon.uppersoft.dso.model.trigger.holdoff.HoldoffSpinnerModel;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.source.pack.VTPatchable;
import com.owon.uppersoft.dso.view.trigger.TriggerLoaderPane;
import com.owon.uppersoft.dso.view.trigger.TriggerPane;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.dso.widget.custom.effect.LabelValueUnitPane;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.trigger.help.EnumNValue;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.ui.layout.OneRowLayout;
import com.owon.uppersoft.vds.ui.slider.SliderAdapter;
import com.owon.uppersoft.vds.ui.slider.SliderBarLocation;
import com.owon.uppersoft.vds.ui.slider.SymmetrySliderBar;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import com.owon.uppersoft.vds.util.format.UnitConversionUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlopePane
extends TriggerLoaderPane
implements ItemListener,
ChangeListener,
SliderBarLocation {
    private CComboBox cbbsweep;
    private CComboBox cbbscondition;
    private TrgConditionSpinnerModel conspin;
    private HoldoffSpinnerModel hospin;
    private LabelValueUnitPane hovup;
    private boolean listening = false;
    private CLabel sweeplbl;
    private CLabel uptxt;
    private CLabel lowtxt;
    private CLabel lowlbl;
    private CLabel uplbl;
    private CLabel slratelbl;
    private CLabel slratetxt;
    private LabelValueUnitContactor holvuc;
    private LabelValueUnitContactor conlvuc;
    private CLabel lblcdt;
    private LabelValueUnitPane convup;

    @Override
    public void loadTrigger(int n) {
        this.setChannel(n);
        this.listening = false;
        SlopeTrigger slopeTrigger = this.getTrigger();
        this.cbbsweep.setSelectedIndex(slopeTrigger.getSweep());
        this.cbbscondition.setSelectedIndex(slopeTrigger.condition);
        this.conspin.setValue(slopeTrigger.trgcondition);
        this.conlvuc.updateStepIndex(slopeTrigger.trgcondition.getStepIndex());
        this.hospin.setValue(slopeTrigger.etvho);
        this.holvuc.updateStepIndex(slopeTrigger.etvho.getStepIndex());
        this.uptxt.setText(this.getUppestLabel(slopeTrigger));
        this.lowtxt.setText(this.getLowestLabel(slopeTrigger));
        if (this.getTriggerPane().getTriggerControl().isSweepEnable()) {
            this.cbbsweep.setSelectedIndex(slopeTrigger.getSweep());
            this.cbbsweep.setEnabled(true);
        } else {
            this.cbbsweep.setSelectedIndex(slopeTrigger.setSweep(0));
            this.cbbsweep.setEnabled(false);
        }
        this.listening = true;
        this.updateShakeRate();
    }

    @Override
    public AbsTrigger submitTrigger() {
        SlopeTrigger slopeTrigger = this.getTrigger();
        slopeTrigger.condition = this.cbbscondition.getSelectedIndex();
        slopeTrigger.trgcondition.set((EnumNValue)this.conspin.getValue());
        slopeTrigger.setSweep(this.cbbsweep.getSelectedIndex());
        slopeTrigger.etvho.set((EnumNValue)this.hospin.getValue());
        return slopeTrigger;
    }

    @Override
    public SlopeTrigger getTrigger() {
        return this.getTriggerPane().curTrgSet().slope;
    }

    private String getUppestLabel(SlopeTrigger slopeTrigger) {
        ChannelInfo channelInfo = Platform.getDataHouse().getWaveFormManager().getWaveForm((int)this.getChannel()).wfi.ci;
        String string = slopeTrigger.getUppestLabel(channelInfo);
        return "<html><font><u>" + string + "<u></font></html>";
    }

    private String getLowestLabel(SlopeTrigger slopeTrigger) {
        ChannelInfo channelInfo = Platform.getDataHouse().getWaveFormManager().getWaveForm((int)this.getChannel()).wfi.ci;
        String string = slopeTrigger.getLowestLabel(channelInfo);
        return "<html><font><u>" + string + "<u></font></html>";
    }

    private void updateUpLowOnReverse() {
        SlopeTrigger slopeTrigger = this.getTrigger();
        this.uptxt.setText(this.getUppestLabel(slopeTrigger));
        this.lowtxt.setText(this.getLowestLabel(slopeTrigger));
        ChannelInfo channelInfo = Platform.getDataHouse().getWaveFormManager().getWaveForm((int)this.getChannel()).wfi.ci;
        ResourceBundle resourceBundle = I18nProvider.bundle();
        if (channelInfo.isInverse()) {
            this.lowlbl.setText(resourceBundle.getString("M.Trg.ThredsholdUp") + ": ");
            this.uplbl.setText(resourceBundle.getString("M.Trg.ThredsholdLow") + ": ");
        } else {
            this.uplbl.setText(resourceBundle.getString("M.Trg.ThredsholdUp") + ": ");
            this.lowlbl.setText(resourceBundle.getString("M.Trg.ThredsholdLow") + ": ");
        }
        this.updateShakeRate();
    }

    public void updateShakeRate() {
        ChannelInfo channelInfo = Platform.getDataHouse().getWaveFormManager().getWaveForm((int)this.getChannel()).wfi.ci;
        int n = channelInfo.getVoltageLabel().getValue();
        SlopeTrigger slopeTrigger = this.getTrigger();
        Thredshold thredshold = slopeTrigger.getThredshold();
        double d = (double)(thredshold.c_getUppest() - thredshold.c_getLowest()) * (double)n / 25.0;
        String string = "ns";
        double d2 = slopeTrigger.trgcondition.toInt() * 10;
        double d3 = d / d2;
        String string2 = UnitConversionUtil.getSimplifiedVoltLabel_mV(d3) + "/" + string;
        this.slratetxt.setText(string2);
    }

    @Override
    public Point getSliderBarLocation(int n, int n2, int n3, int n4, Component component) {
        int n5 = component.getWidth();
        n = n5 + n3 - n - 20;
        n2 = n4 - n2 - 178 + 20;
        return new Point(n, n2);
    }

    private void operationThredshold(MouseEvent mouseEvent, int n, final TrgCheckType trgCheckType) {
        final int n2 = this.getChannel();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        Point point = this.getSliderBarLocation(n3, n4, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getComponent());
        int n5 = 125;
        WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
        final TriggerControl triggerControl = this.getTriggerPane().getTriggerControl();
        final WaveForm waveForm = waveFormManager.getWaveForm(n2);
        final ChannelInfo channelInfo = waveForm.wfi.ci;
        int n6 = channelInfo.getPos0byRange(n5);
        n = channelInfo.getInverseValue(n);
        SymmetrySliderBar.createSymmetrySliderFrame(WindowUtil.getWindow(mouseEvent), point.x, point.y, n5, n6, n5 - n, true, channelInfo.getColor(), 3, new SliderAdapter(){

            @Override
            public void valueChanged(int n, int n22) {
                int n3 = 125;
                int n4 = n22;
                n4 = n3 - n4;
                SlopeTrigger slopeTrigger = SlopePane.this.getTrigger();
                n4 = channelInfo.getInverseValue(n4);
                VTPatchable vTPatchable = triggerControl.getVTPatchable();
                boolean bl = slopeTrigger.c_setUppestOrLowest(trgCheckType, n4);
                if (bl) {
                    vTPatchable.submiteUpper_Lower(n2, slopeTrigger, trgCheckType);
                }
                SlopePane.this.updateLowUpOnChange(slopeTrigger);
            }

            @Override
            public void on50percent() {
                int n = waveForm.getTrg50Percent();
                if (n != Integer.MAX_VALUE) {
                    SlopeTrigger slopeTrigger = SlopePane.this.getTrigger();
                    VTPatchable vTPatchable = triggerControl.getVTPatchable();
                    boolean bl = slopeTrigger.c_setUppestOrLowest(trgCheckType, n);
                    if (bl) {
                        vTPatchable.submiteUpper_Lower(n2, slopeTrigger, trgCheckType);
                    }
                    SlopePane.this.updateLowUpOnChange(slopeTrigger);
                }
            }

            @Override
            public void onDispose() {
                Platform.getMainWindow().update_DoneUppLow();
            }

            @Override
            public void actionOff() {
            }
        }, I18nProvider.bundle());
        Platform.getMainWindow().update_ChangeUppLow(n2, trgCheckType);
    }

    private void updateLowUpOnChange(SlopeTrigger slopeTrigger) {
        this.uptxt.setText(this.getUppestLabel(slopeTrigger));
        this.lowtxt.setText(this.getLowestLabel(slopeTrigger));
        this.updateShakeRate();
        Platform.getMainWindow().getChartScreen().re_paint();
    }

    public SlopePane(TriggerPane triggerPane) {
        super(triggerPane);
        SlopeTrigger slopeTrigger = this.getTrigger();
        this.nrip(new OneRowLayout(new Insets(3, 3, 3, 3), 1));
        this.cbbscondition = new CComboBox(LObject.getLObjects(TriggerDefine.CONDITIONS_SLOPE));
        this.lblcdt = new CLabel();
        this.ip.add(this.lblcdt);
        this.ip.add(this.cbbscondition);
        this.nrip();
        this.conspin = new TrgConditionSpinnerModel(slopeTrigger.trgcondition);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(TriggerDefine.CONDITION_STEP_TIME_UNIT);
        this.convup = new LabelValueUnitPane("", this.conspin, defaultComboBoxModel);
        this.conlvuc = new LabelValueUnitContactor(new TriggerLoaderPane.DefaultValueChange(){

            @Override
            protected void submitChange() {
                Submitable submitable = SubmitorFactory.reInit();
                byte by = SlopePane.this.getTriggerPane().getTriggerControl().getChannelModeAlpha();
                SlopePane.this.getTrigger().submitCondition(by, SlopePane.this.getChannel(), submitable);
                submitable.apply_trg();
                SlopePane.this.getTriggerPane().updateTrgVoltPane();
            }
        }, this.convup.comboBox, this.convup.spinner);
        this.convup.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SlopePane.this.updateShakeRate();
            }
        });
        this.ip.add(this.convup);
        this.nrip();
        this.uplbl = new CLabel();
        this.uptxt = new CLabel();
        this.uptxt.setPreferredSize(new Dimension(100, 25));
        this.uptxt.setText(this.getUppestLabel(slopeTrigger));
        this.ip.add(this.uplbl);
        this.ip.add(this.uptxt);
        this.uptxt.setCursor(Cursor.getPredefinedCursor(12));
        this.uptxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = SlopePane.this.getTrigger().c_getUppest();
                SlopePane.this.operationThredshold(mouseEvent, n, TrgCheckType.UppOver);
            }
        });
        this.nrip();
        this.lowlbl = new CLabel();
        this.lowtxt = new CLabel();
        this.lowtxt.setText(this.getLowestLabel(slopeTrigger));
        this.lowtxt.setPreferredSize(new Dimension(100, 25));
        this.ip.add(this.lowlbl);
        this.ip.add(this.lowtxt);
        this.lowtxt.setCursor(Cursor.getPredefinedCursor(12));
        this.lowtxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = SlopePane.this.getTrigger().c_getLowest();
                SlopePane.this.operationThredshold(mouseEvent, n, TrgCheckType.LowOver);
            }
        });
        this.nrip();
        this.slratelbl = new CLabel();
        this.ip.add(this.slratelbl);
        this.slratetxt = new CLabel();
        this.ip.add(this.slratetxt);
        this.nrip();
        this.sweeplbl = new CLabel();
        this.ip.add(this.sweeplbl);
        this.cbbsweep = new CComboBox(LObject.getLObjects(TriggerDefine.SWEEP));
        this.ip.add(this.cbbsweep);
        ETV_Holdoff eTV_Holdoff = slopeTrigger.etvho;
        this.hospin = new HoldoffSpinnerModel(eTV_Holdoff);
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(TriggerDefine.HOLDOFF_STEP_TIME_UNIT);
        this.hovup = new LabelValueUnitPane("", this.hospin, defaultComboBoxModel2);
        this.holvuc = new LabelValueUnitContactor(new TriggerLoaderPane.HoldoffValueChange(this), this.hovup.comboBox, this.hovup.spinner);
        this.nrip().add(this.hovup);
        this.addListeners();
    }

    @Override
    protected void addListeners() {
        this.cbbsweep.addItemListener(this);
        this.cbbscondition.addItemListener(this);
        this.listening = true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.listening) {
            return;
        }
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (itemEvent.getSource() == this.cbbsweep) {
            int n = this.cbbsweep.getSelectedIndex();
            this.getTrigger().c_setSweep(n, this.getTriggerPane().getTriggerControl());
            this.bodySend();
            return;
        }
        if (itemEvent.getSource() == this.cbbscondition) {
            int n;
            this.getTrigger().condition = n = this.cbbscondition.getSelectedIndex();
            this.bodySend();
            this.getTriggerPane().updateTrgVoltPane();
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.listening) {
            return;
        }
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.lblcdt.setText(resourceBundle.getString("M.Trg.S.Condition") + ": ");
        this.slratelbl.setText(resourceBundle.getString("M.Trg.SlewRate") + ": ");
        this.sweeplbl.setText(resourceBundle.getString("M.Trg.TrigMode") + ": ");
        this.hovup.setLabel(resourceBundle.getString("M.Trg.Holdoff") + ": ");
        this.uplbl.setText(resourceBundle.getString("M.Trg.ThredsholdUp") + ": ");
        this.lowlbl.setText(resourceBundle.getString("M.Trg.ThredsholdLow") + ": ");
        boolean bl = this.listening;
        this.listening = false;
        this.cbbscondition.setSelectedItem(this.cbbscondition.getSelectedItem());
        this.cbbscondition.repaint();
        this.cbbsweep.setSelectedItem(this.cbbsweep.getSelectedItem());
        this.listening = bl;
    }

    @Override
    public void bodySend() {
        this.getTriggerPane().bodySend();
    }

    @Override
    public void fireProperty(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("UpdateUppLow")) {
            int n;
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            if (n2 == (n = this.getChannel())) {
                this.updateUpLowOnReverse();
            }
        } else if (string.equals("NextStatus")) {
            this.listening = false;
            this.cbbscondition.setSelectedIndex(this.getTrigger().condition);
            this.listening = true;
        } else if (string.equals("T_SweepOnce2Auto")) {
            this.listening = false;
            this.cbbsweep.setSelectedIndex(this.getTrigger().getSweep());
            this.listening = true;
        } else if (string.equals("NextSingleChannel")) {
            this.setChannel((Integer)propertyChangeEvent.getNewValue());
            this.updateUpLowOnReverse();
        } else if (string.equals("T_2SweepOnce")) {
            this.cbbsweep.setSelectedIndex(this.getTrigger().getSweep());
        } else if (string.equals("UpdateCondition")) {
            int n;
            int n3 = (Integer)propertyChangeEvent.getNewValue();
            if (n3 == (n = this.getChannel())) {
                this.conspin.setValue(this.getTrigger().trgcondition);
            }
            this.getTriggerPane().updateTrgVoltPane();
        }
    }
}

