/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.trigger;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.PulseTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerDefine;
import com.owon.uppersoft.dso.model.trigger.condition.TrgConditionSpinnerModel;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_Holdoff;
import com.owon.uppersoft.dso.model.trigger.helper.LabelValueUnitContactor;
import com.owon.uppersoft.dso.model.trigger.holdoff.HoldoffSpinnerModel;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.view.trigger.TriggerLoaderPane;
import com.owon.uppersoft.dso.view.trigger.TriggerPane;
import com.owon.uppersoft.dso.view.trigger.VoltLevelMouseAdapter;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.widget.custom.effect.LabelValueUnitPane;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.trigger.help.EnumNValue;
import com.owon.uppersoft.vds.ui.layout.OneRowLayout;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PulsePane
extends TriggerLoaderPane
implements ItemListener,
ChangeListener {
    private CComboBox cbbcoupling;
    private CComboBox cbbsweep;
    private CComboBox cbbpcondition;
    private CLabel lblcdt;
    private HoldoffSpinnerModel hospin;
    private TrgConditionSpinnerModel conspin;
    private LabelValueUnitPane hovup;
    private ChannelInfo ci;
    private boolean listening = false;
    private CLabel sweeplbl;
    private CLabel couplinglbl;
    private CLabel trvtLbl;
    private CLabel trvtValueLbl;
    private LabelValueUnitContactor holvuc;
    private LabelValueUnitContactor conlvuc;
    private LabelValueUnitPane convup;

    public void updateTrVtValueLbl(int n) {
        this.ci = Platform.getDataHouse().getWaveFormManager().getWaveForm((int)n).wfi.ci;
        String string = this.getTrigger().getLabelText(this.ci);
        string = "<html><font><u>" + string + "<u></font></html>";
        this.trvtValueLbl.setText(string);
    }

    @Override
    public void loadTrigger(int n) {
        this.setChannel(n);
        this.updateTrVtValueLbl(n);
        this.listening = false;
        PulseTrigger pulseTrigger = this.getTrigger();
        this.cbbpcondition.setSelectedIndex(pulseTrigger.condition);
        this.conspin.setValue(pulseTrigger.trgcondition);
        this.conlvuc.updateStepIndex(pulseTrigger.trgcondition.getStepIndex());
        this.hospin.setValue(pulseTrigger.etvho);
        this.holvuc.updateStepIndex(pulseTrigger.etvho.getStepIndex());
        this.cbbcoupling.setSelectedIndex(pulseTrigger.coupling);
        if (this.getTriggerPane().getTriggerControl().isSweepEnable()) {
            this.cbbsweep.setSelectedIndex(pulseTrigger.getSweep());
            this.cbbsweep.setEnabled(true);
        } else {
            this.cbbsweep.setSelectedIndex(pulseTrigger.setSweep(0));
            this.cbbsweep.setEnabled(false);
        }
        this.listening = true;
    }

    @Override
    public AbsTrigger submitTrigger() {
        PulseTrigger pulseTrigger = this.getTrigger();
        pulseTrigger.condition = this.cbbpcondition.getSelectedIndex();
        pulseTrigger.trgcondition.set((EnumNValue)this.conspin.getValue());
        pulseTrigger.etvho.set((EnumNValue)this.hospin.getValue());
        pulseTrigger.setSweep(this.cbbsweep.getSelectedIndex());
        pulseTrigger.coupling = this.cbbcoupling.getSelectedIndex();
        return pulseTrigger;
    }

    @Override
    public PulseTrigger getTrigger() {
        return this.getTriggerPane().curTrgSet().pulse;
    }

    public PulsePane(TriggerPane triggerPane) {
        super(triggerPane);
        PulseTrigger pulseTrigger = this.getTrigger();
        ETV_Holdoff eTV_Holdoff = pulseTrigger.etvho;
        this.nrip(new OneRowLayout(new Insets(3, 3, 3, 3), 1));
        this.lblcdt = new CLabel();
        this.cbbpcondition = new CComboBox();
        this.cbbpcondition.setModel(new DefaultComboBoxModel<LObject>(LObject.getLObjects(TriggerDefine.CONDITIONS_PULSE)));
        this.ip.add(this.lblcdt);
        this.ip.add(this.cbbpcondition);
        this.nrip();
        this.conspin = new TrgConditionSpinnerModel(pulseTrigger.trgcondition);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(TriggerDefine.CONDITION_STEP_TIME_UNIT);
        this.convup = new LabelValueUnitPane("", this.conspin, defaultComboBoxModel);
        this.conlvuc = new LabelValueUnitContactor(new TriggerLoaderPane.DefaultValueChange(){

            @Override
            protected void submitChange() {
                Submitable submitable = SubmitorFactory.reInit();
                byte by = PulsePane.this.getTriggerPane().getTriggerControl().getChannelModeAlpha();
                PulsePane.this.getTrigger().submitCondition(by, PulsePane.this.getChannel(), submitable);
                submitable.apply_trg();
                PulsePane.this.getTriggerPane().updateTrgVoltPane();
            }
        }, this.convup.comboBox, this.convup.spinner);
        this.ip.add(this.convup);
        this.nrip();
        this.trvtLbl = new CLabel();
        this.trvtValueLbl = new CLabel();
        this.ip.add(this.trvtLbl);
        this.ip.add(this.trvtValueLbl);
        this.trvtValueLbl.setCursor(Cursor.getPredefinedCursor(12));
        this.trvtValueLbl.addMouseListener(new VoltLevelMouseAdapter(this, this.getTriggerPane().getTriggerControl(), 125));
        this.nrip();
        this.sweeplbl = new CLabel();
        this.ip.add(this.sweeplbl);
        this.cbbsweep = new CComboBox();
        this.ip.add(this.cbbsweep);
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(TriggerDefine.HOLDOFF_STEP_TIME_UNIT);
        this.hospin = new HoldoffSpinnerModel(eTV_Holdoff);
        this.hovup = new LabelValueUnitPane("", this.hospin, defaultComboBoxModel2);
        this.holvuc = new LabelValueUnitContactor(new TriggerLoaderPane.HoldoffValueChange(this), this.hovup.comboBox, this.hovup.spinner);
        this.nrip().add(this.hovup);
        this.couplinglbl = new CLabel();
        this.cbbcoupling = new CComboBox();
        this.cbbcoupling.setModel(new DefaultComboBoxModel<String>(TriggerDefine.COUPLING));
        this.cbbsweep.setModel(new DefaultComboBoxModel<LObject>(LObject.getLObjects(TriggerDefine.SWEEP)));
        this.addListeners();
    }

    @Override
    protected void addListeners() {
        this.cbbsweep.addItemListener(this);
        this.cbbcoupling.addItemListener(this);
        this.cbbpcondition.addItemListener(this);
        this.listening = true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.listening) {
            return;
        }
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (itemEvent.getSource() == this.cbbsweep) {
            int n = this.cbbsweep.getSelectedIndex();
            this.getTrigger().c_setSweep(n, this.getTriggerPane().getTriggerControl());
            return;
        }
        if (itemEvent.getSource() == this.cbbcoupling) {
            int n;
            this.getTrigger().coupling = n = this.cbbcoupling.getSelectedIndex();
            this.bodySend();
            return;
        }
        if (itemEvent.getSource() == this.cbbpcondition) {
            int n;
            this.getTrigger().condition = n = this.cbbpcondition.getSelectedIndex();
            this.bodySend();
            this.getTriggerPane().updateTrgVoltPane();
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.listening) {
            return;
        }
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.lblcdt.setText(resourceBundle.getString("M.Trg.P.Condition") + ": ");
        this.trvtLbl.setText(resourceBundle.getString("M.Trg.TrgVolt") + ": ");
        this.sweeplbl.setText(resourceBundle.getString("M.Trg.TrigMode") + ": ");
        this.couplinglbl.setText(resourceBundle.getString("M.Trg.Coupling") + ": ");
        this.hovup.setLabel(resourceBundle.getString("M.Trg.Holdoff") + ": ");
        boolean bl = this.listening;
        this.listening = false;
        this.cbbpcondition.setSelectedItem(this.cbbpcondition.getSelectedItem());
        this.cbbsweep.setSelectedItem(this.cbbsweep.getSelectedItem());
        this.listening = bl;
    }

    @Override
    public void bodySend() {
        this.getTriggerPane().bodySend();
    }

    @Override
    public void fireProperty(PropertyChangeEvent propertyChangeEvent) {
        int n;
        int n2;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("UpdateVoltsense")) {
            int n3;
            int n4 = (Integer)propertyChangeEvent.getNewValue();
            if (n4 == (n3 = this.getChannel())) {
                this.updateTrVtValueLbl(n3);
            }
        } else if (string.equals("NextStatus")) {
            this.listening = false;
            this.cbbpcondition.setSelectedIndex(this.getTrigger().condition);
            this.listening = true;
        } else if (string.equals("T_SweepOnce2Auto")) {
            this.listening = false;
            this.cbbsweep.setSelectedIndex(this.getTrigger().getSweep());
            this.listening = true;
        } else if (string.equals("NextSingleChannel")) {
            this.setChannel((Integer)propertyChangeEvent.getNewValue());
            this.updateTrVtValueLbl(this.getChannel());
        } else if (string.equals("T_2SweepOnce")) {
            this.cbbsweep.setSelectedIndex(this.getTrigger().getSweep());
        } else if (string.equals("UpdateCondition") && (n2 = ((Integer)propertyChangeEvent.getNewValue()).intValue()) == (n = this.getChannel())) {
            this.conspin.setValue(this.getTrigger().trgcondition);
        }
    }
}

