/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.trigger;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.EdgeTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerDefine;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_Holdoff;
import com.owon.uppersoft.dso.model.trigger.helper.LabelValueUnitContactor;
import com.owon.uppersoft.dso.model.trigger.holdoff.HoldoffSpinnerModel;
import com.owon.uppersoft.dso.view.trigger.TriggerLoaderPane;
import com.owon.uppersoft.dso.view.trigger.TriggerPane;
import com.owon.uppersoft.dso.view.trigger.VoltLevelMouseAdapter;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.widget.custom.effect.LabelValueUnitPane;
import com.owon.uppersoft.vds.core.trigger.help.EnumNValue;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;

public class EdgePane
extends TriggerLoaderPane
implements ItemListener {
    private CComboBox cbbsweep;
    private CComboBox cbbcoupling;
    private CComboBox cbbrnf;
    private CLabel lblcdt;
    private HoldoffSpinnerModel hospin;
    private LabelValueUnitPane vup;
    private boolean listening = false;
    private CLabel couplinglbl;
    private CLabel sweepLbl;
    private CLabel trvtLbl;
    private CLabel trvtValueLbl;
    private LabelValueUnitContactor lvuc;
    private VoltLevelMouseAdapter voltLevelMouseAdapter;

    public void updateTrVtValueLbl(int n) {
        boolean bl = this.getTriggerPane().getTriggerControl().isExtTrg(n);
        this.trvtValueLbl.setVisible(!bl);
        if (bl) {
            this.trvtValueLbl.setText("EX");
        } else {
            WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
            ChannelInfo channelInfo = waveFormManager.getWaveForm((int)n).wfi.ci;
            String string = this.getTrigger().getLabelText(channelInfo);
            string = "<html><font><u>" + string + "<u></font></html>";
            this.trvtValueLbl.setText(string);
        }
    }

    @Override
    public void loadTrigger(int n) {
        this.setChannel(n);
        this.updateTrVtValueLbl(n);
        this.listening = false;
        EdgeTrigger edgeTrigger = this.getTrigger();
        this.cbbrnf.setSelectedIndex(edgeTrigger.raisefall);
        this.cbbcoupling.setSelectedIndex(edgeTrigger.coupling);
        this.cbbsweep.setSelectedIndex(edgeTrigger.getSweep());
        this.hospin.setValue(edgeTrigger.etvho);
        this.lvuc.updateStepIndex(edgeTrigger.etvho.getStepIndex());
        if (this.getTriggerPane().getTriggerControl().isSweepEnable()) {
            this.cbbsweep.setSelectedIndex(edgeTrigger.getSweep());
            this.cbbsweep.setEnabled(true);
        } else {
            this.cbbsweep.setSelectedIndex(edgeTrigger.setSweep(0));
            this.cbbsweep.setEnabled(false);
        }
        this.listening = true;
    }

    @Override
    public AbsTrigger submitTrigger() {
        EdgeTrigger edgeTrigger = this.getTrigger();
        edgeTrigger.raisefall = this.cbbrnf.getSelectedIndex();
        edgeTrigger.setSweep(this.cbbsweep.getSelectedIndex());
        edgeTrigger.coupling = this.cbbcoupling.getSelectedIndex();
        edgeTrigger.etvho.set((EnumNValue)this.hospin.getValue());
        return edgeTrigger;
    }

    @Override
    public EdgeTrigger getTrigger() {
        return this.getTriggerPane().curTrgSet().edge;
    }

    public EdgePane(TriggerPane triggerPane) {
        super(triggerPane);
        ETV_Holdoff eTV_Holdoff = this.getTrigger().etvho;
        this.hospin = new HoldoffSpinnerModel(eTV_Holdoff);
        this.nrip();
        this.couplinglbl = new CLabel();
        this.cbbcoupling = new CComboBox();
        this.lblcdt = new CLabel();
        this.ip.add(this.lblcdt);
        this.cbbrnf = new CComboBox();
        this.ip.add(this.cbbrnf);
        this.nrip();
        this.trvtLbl = new CLabel();
        this.trvtValueLbl = new CLabel();
        this.ip.add(this.trvtLbl);
        this.ip.add(this.trvtValueLbl);
        this.trvtValueLbl.setCursor(Cursor.getPredefinedCursor(12));
        this.voltLevelMouseAdapter = new VoltLevelMouseAdapter(this, this.getTriggerPane().getTriggerControl(), 125);
        this.trvtValueLbl.addMouseListener(this.voltLevelMouseAdapter);
        this.nrip();
        this.sweepLbl = new CLabel();
        this.ip.add(this.sweepLbl);
        this.cbbsweep = new CComboBox();
        this.ip.add(this.cbbsweep);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(TriggerDefine.HOLDOFF_STEP_TIME_UNIT);
        this.vup = new LabelValueUnitPane("", this.hospin, defaultComboBoxModel);
        this.lvuc = new LabelValueUnitContactor(new TriggerLoaderPane.HoldoffValueChange(this), this.vup.comboBox, this.vup.spinner);
        this.nrip().add(this.vup);
        this.cbbcoupling.setModel(new DefaultComboBoxModel<String>(TriggerDefine.COUPLING));
        this.cbbrnf.setModel(new DefaultComboBoxModel<LObject>(EdgeTrigger.RiseFall));
        this.cbbsweep.setModel(new DefaultComboBoxModel<LObject>(LObject.getLObjects(TriggerDefine.SWEEP)));
        this.addListeners();
    }

    @Override
    protected void addListeners() {
        this.cbbsweep.addItemListener(this);
        this.cbbcoupling.addItemListener(this);
        this.cbbrnf.addItemListener(this);
        this.listening = true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.listening) {
            return;
        }
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (itemEvent.getSource() == this.cbbrnf) {
            this.getTrigger().raisefall = this.cbbrnf.getSelectedIndex();
            this.bodySend();
            this.getTriggerPane().updateTrgVoltPane();
            return;
        }
        if (itemEvent.getSource() == this.cbbcoupling) {
            int n;
            this.getTrigger().coupling = n = this.cbbcoupling.getSelectedIndex();
            this.bodySend();
            return;
        }
        if (itemEvent.getSource() == this.cbbsweep) {
            int n = this.cbbsweep.getSelectedIndex();
            this.getTrigger().c_setSweep(n, this.getTriggerPane().getTriggerControl());
            this.bodySend();
            return;
        }
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.lblcdt.setText(resourceBundle.getString("M.Trg.P.Condition") + ": ");
        this.trvtLbl.setText(resourceBundle.getString("M.Trg.TrgVolt") + ": ");
        this.couplinglbl.setText(resourceBundle.getString("M.Trg.Coupling") + ": ");
        this.sweepLbl.setText(resourceBundle.getString("M.Trg.TrigMode") + ": ");
        this.vup.setLabel(resourceBundle.getString("M.Trg.Holdoff") + ": ");
        boolean bl = this.listening;
        this.listening = false;
        this.cbbrnf.setSelectedItem(this.cbbrnf.getSelectedObjects());
        this.cbbsweep.setSelectedItem(this.cbbsweep.getSelectedObjects());
        this.listening = bl;
    }

    @Override
    public void bodySend() {
        this.getTriggerPane().bodySend();
    }

    @Override
    public void fireProperty(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("UpdateVoltsense")) {
            int n;
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            if (n2 == (n = this.getChannel())) {
                this.updateTrVtValueLbl(n);
            }
        } else if (string.equals("NextStatus")) {
            this.listening = false;
            this.cbbrnf.setSelectedIndex(this.getTrigger().raisefall);
            this.listening = true;
        } else if (string.equals("T_SweepOnce2Auto")) {
            this.listening = false;
            this.cbbsweep.setSelectedIndex(this.getTrigger().getSweep());
            this.listening = true;
        } else if (string.equals("NextSingleChannel")) {
            this.setChannel((Integer)propertyChangeEvent.getNewValue());
            this.updateTrVtValueLbl(this.getChannel());
        } else if (string.equals("T_2SweepOnce")) {
            this.cbbsweep.setSelectedIndex(this.getTrigger().getSweep());
        }
    }
}

