/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.trigger;

import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.trigger.TrgTypeDefine;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerUIInfo;
import com.owon.uppersoft.dso.view.trigger.ChannelSelectItemListner;
import com.owon.uppersoft.dso.view.trigger.TriggerPane;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.help.RadioButtonGroup;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

public class ChannelSelectionPane
extends JPanel {
    private CardLayout cl = new CardLayout();
    private CComboBox cbbchl;
    private RadioButtonGroup rbg;
    private TriggerControl tc;
    private TriggerPane tp;
    private WaveFormInfoControl wfic;
    private boolean isExtTrgSupport;
    private PropertyChangeListener radioBtnPCL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!ChannelSelectionPane.this.tp.isListening()) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("radio")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                TriggerUIInfo triggerUIInfo = ChannelSelectionPane.this.tc.getTriggerUIInfo();
                triggerUIInfo.setCurrentAltChannel(n);
                TrgTypeDefine trgTypeDefine = triggerUIInfo.getCurrentTriggerSet().getTrigger().type;
                ChannelSelectionPane.this.tp.simpleSelectCBBMode(trgTypeDefine);
                ChannelSelectionPane.this.tp.switch2Pane(trgTypeDefine);
            }
        }
    };

    public ChannelSelectionPane(boolean bl, TriggerControl triggerControl, TriggerPane triggerPane, WaveFormInfoControl waveFormInfoControl, ChannelSelectItemListner channelSelectItemListner) {
        this.tp = triggerPane;
        this.wfic = waveFormInfoControl;
        this.tc = triggerControl;
        this.isExtTrgSupport = bl;
        this.setOpaque(false);
        this.setLayout(this.cl);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setOpaque(false);
        this.cbbchl = new CComboBox();
        this.onSingleTrgForEdgeChannelSelectJudge();
        triggerPane.setListening(false);
        this.rbg = new RadioButtonGroup(waveFormInfoControl.getWaveFormInfos(), this.radioBtnPCL, -1, 45, 30);
        jPanel.add((Component)this.cbbchl, "West");
        this.add((Component)jPanel, "single");
        this.add((Component)this.rbg, "alternate");
        this.cbbchl.addItemListener(channelSelectItemListner);
    }

    public void onSingleTrgForEdgeChannelSelectJudge() {
        int n;
        String[] stringArray;
        this.tp.setListening(false);
        int n2 = this.wfic.getLowMachineChannels();
        if (this.isExtTrgSupport && TrgTypeDefine.Edge == this.tc.getSingleTriggerSet().getTrigger().type) {
            stringArray = new String[n2 + 1];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = "CH" + (n + 1);
            }
            stringArray[n] = "EXT";
        } else {
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = "CH" + (n + 1);
            }
        }
        this.cbbchl.setModel(new DefaultComboBoxModel<String>(stringArray));
        n = this.tc.getSingleTrgChannel();
        if (n >= n2) {
            n = n2;
        }
        this.cbbchl.setSelectedIndex(n);
        this.tp.setListening(true);
    }

    public void setChannel(int n) {
        this.cbbchl.setSelectedIndex(n);
        this.rbg.setSelected(n);
    }

    public void updateSingleChannel() {
        this.tp.setListening(false);
        TriggerUIInfo triggerUIInfo = this.tc.getTriggerUIInfo();
        this.cbbchl.setSelectedIndex(triggerUIInfo.getCurrentChannel());
        this.tp.setListening(true);
    }

    public void updateChlPane() {
        if (this.tc.isSingleTrg()) {
            this.cl.show(this, "single");
        } else {
            this.cl.show(this, "alternate");
        }
    }

    public int getCurrentChannel() {
        if (this.tc.isSingleTrg()) {
            return this.cbbchl.getSelectedIndex();
        }
        return this.rbg.getSelection();
    }

    public CComboBox getChannelsComboBox() {
        return this.cbbchl;
    }
}

