/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.sub;

import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.pref.Style;
import com.owon.uppersoft.dso.view.sub.InfoBlock;
import com.owon.uppersoft.dso.view.sub.Label;
import com.owon.uppersoft.dso.view.sub.TrgToolBar;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class TriggerInfoPane
extends JPanel
implements Localizable,
PropertyChangeListener {
    public static final String trgvoltPath = Define.def.style.path + Style.Trgvoltname;
    public static final int floor0 = 22;
    public static final int BlockHeigth = 103;
    public static final int BlockWidth = 128;
    public static final int forceBtnOrigin = 85;
    public static final int titleWidth = 47;
    private Image img = SwingResourceManager.getIcon(InfoBlock.class, trgvoltPath).getImage();
    private DataHouse dh;
    private List<Label> ibs = new LinkedList<Label>();
    private ListIterator<Label> li;
    private JPanel con;
    private TrgToolBar trgToolbar;

    public TriggerInfoPane(DataHouse dataHouse) {
        this.dh = dataHouse;
        this.setOpaque(false);
        this.setLayout(new BorderLayout(3, 3));
        this.trgToolbar = new TrgToolBar(dataHouse);
        this.add((Component)this.trgToolbar, "North");
        this.con = new JPanel();
        this.add((Component)this.con, "Center");
        this.con.setOpaque(false);
        this.con.setLayout(new OneColumnLayout());
        this.initTitle();
    }

    protected void init() {
        this.li = this.ibs.listIterator();
    }

    protected void end() {
        while (this.li.hasNext()) {
            Label label = this.li.next();
            this.li.remove();
            this.con.remove(label);
        }
    }

    protected void updateLabel(int n) {
        this.init();
        while (this.li.hasNext()) {
            Label label = this.li.next();
            if (label.getIdx() != n) continue;
            label.repaint();
            break;
        }
    }

    protected Label process(TriggerSet triggerSet, int n) {
        Label label;
        if (this.li.hasNext()) {
            label = this.li.next();
            label.setTriggerSet(triggerSet, n);
        } else {
            label = new Label(this.dh, triggerSet, n);
            this.li.add(label);
            this.con.add(label);
        }
        return label;
    }

    public void updateInfos(TriggerControl triggerControl) {
        this.init();
        if (!triggerControl.isSingleTrg()) {
            int n = triggerControl.getChannelsNumber();
            for (int i = 0; i < n; ++i) {
                TriggerSet triggerSet = triggerControl.getAlternateTriggerSet(i);
                this.process(triggerSet, i);
            }
        } else {
            int n = triggerControl.getSingleTrgChannel();
            this.process(triggerControl.singleTriggerSet, n);
        }
        this.end();
        this.con.doLayout();
        this.repaint();
    }

    public Label get(int n) {
        this.init();
        while (this.li.hasNext()) {
            Label label = this.li.next();
            if (n != label.getIdx()) continue;
            return label;
        }
        return null;
    }

    private void initTitle() {
        I18nProvider.LocalizeSelf(this.trgToolbar);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage(this.img, 0, 0, null);
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.trgToolbar.localize(resourceBundle);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("FFT_ON")) {
            this.trgToolbar.setTrgInfPaneEnable(false);
        } else if (string.equals("FFT_OFF")) {
            this.trgToolbar.setTrgInfPaneEnable(true);
        }
    }
}

