/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.sub;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.model.trigger.common.Voltsensor;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.trigger.VoltSliderAdapter;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.slider.SliderBarLocation;
import com.owon.uppersoft.vds.ui.slider.SymmetrySliderBar;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class Label
extends JComponent
implements MouseListener,
SliderBarLocation,
MouseMotionListener,
PropertyChangeListener {
    public static final String imageRoot = "/com/owon/uppersoft/dso/image/";
    public static final Dimension DefaultBlockSize = new Dimension(126, 18);
    private TriggerControl tc;
    private Icon img2;
    private TriggerSet ts;
    private int idx;
    private ChannelInfo ci;
    private WaveFormManager wfm;
    private ControlManager cm;
    private boolean rolloverL = false;
    private boolean rolloverMid = false;
    private boolean rolloverR = false;
    public static final int hlstart = 55;
    public static final int borderwidth = 70;
    public static final int chstart = 5;
    public static final int trgmodstart = 32;
    public static final int BlockWidth = 130;

    public Label(DataHouse dataHouse, TriggerSet triggerSet, int n) {
        this.cm = dataHouse.controlManager;
        this.tc = this.cm.getTriggerControl();
        this.wfm = dataHouse.getWaveFormManager();
        this.setPreferredSize(DefaultBlockSize);
        this.setFont(Define.def.alphafont);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setTriggerSet(triggerSet, n);
        this.cm.pcs.addPropertyChangeListener(this);
    }

    public int getIdx() {
        return this.idx;
    }

    private void loadImage2(AbsTrigger absTrigger) {
        String string = absTrigger.getIconKey();
        this.img2 = string != null ? SwingResourceManager.getIcon(Label.class, imageRoot + string) : null;
    }

    public void setTriggerSet(TriggerSet triggerSet, int n) {
        this.ts = triggerSet;
        this.idx = n;
        if (this.tc.isExtTrg(n)) {
            this.idx = -1;
            this.ci = null;
        } else {
            this.ci = this.wfm.getWaveForm((int)n).wfi.ci;
        }
        this.loadImage2(triggerSet.getTrigger());
    }

    private String getText() {
        if (this.ci == null) {
            return " TTL ";
        }
        String string = this.ts.getTrigger().getLabelText(this.ci);
        return string;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.shouldLabelClose()) {
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawOval(6, 1, 16, 16);
            object = this.ci != null ? String.valueOf(this.ci.getNumber() + 1) : "E";
            graphics2D.drawString((String)object, 10, 14);
            graphics2D.setColor(Color.GRAY);
        } else {
            if (this.ts.isVoltsenseSupport() && this.rolloverR) {
                graphics2D.setColor(Define.def.style.CO_INFOBLOCK_HIGHLIGHT);
                graphics2D.fillRect(55, 1, 70, 20);
            }
            if (this.rolloverMid) {
                graphics2D.setColor(Define.def.style.CO_INFOBLOCK_HIGHLIGHT);
                graphics2D.fillRect(32, 1, 23, 20);
            }
            if (this.rolloverL) {
                graphics2D.setColor(Define.def.style.CO_INFOBLOCK_HIGHLIGHT);
                graphics2D.fillRect(2, 1, 27, 16);
            }
            if (this.ci != null) {
                graphics2D.setColor(this.ci.getColor());
                graphics2D.fillOval(6, 1, 16, 16);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(String.valueOf(this.ci.getNumber() + 1), 10, 14);
            } else {
                object = graphics2D.getColor();
                graphics2D.setColor(Color.WHITE);
                graphics2D.drawString("EXT", 2, 15);
                graphics2D.setColor((Color)object);
            }
            if (this.img2 != null) {
                this.img2.paintIcon(null, graphics, 32, 2);
                object = this.ts.getTrigger();
                graphics2D.setColor(Color.WHITE);
                Font font = graphics2D.getFont();
                graphics2D.setFont(Define.def.insideFont);
                ((AbsTrigger)object).paintIcon(graphics2D);
                graphics2D.setFont(font);
            }
            graphics2D.setColor(Color.WHITE);
        }
        object = this.getText();
        if (object != null) {
            graphics2D.drawString((String)object, 58, 14);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && (n = mouseEvent.getX()) >= 55 && n < 125 && this.ts.isVoltsenseSupport() && this.idx >= 0) {
            this.wfm.getWaveForm(this.idx).doubleClickOnLevel();
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.rolloverR = false;
        this.rolloverMid = false;
        this.rolloverL = false;
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.shouldLabelClose()) {
            return;
        }
        int n = mouseEvent.getX();
        if (n > 57 && n < 125) {
            if (!this.tc.isTrgEnable()) {
                return;
            }
            if (!this.rolloverR) {
                this.rolloverR = true;
                if (this.ts.isVoltsenseSupport()) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.repaint();
                }
            }
            return;
        }
        if (n > 34 && n < 53) {
            if (!this.rolloverMid) {
                this.rolloverMid = true;
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.repaint();
            }
            return;
        }
        if (n > 5 && n < 30) {
            if (!this.rolloverL && this.tc.isSingleTrg()) {
                this.rolloverL = true;
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.repaint();
            }
            return;
        }
        if (this.rolloverR) {
            this.rolloverR = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        }
        if (this.rolloverMid) {
            this.rolloverMid = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        }
        if (this.rolloverL) {
            this.rolloverL = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        }
    }

    @Override
    public Point getSliderBarLocation(int n, int n2, int n3, int n4, Component component) {
        int n5 = 124;
        int n6 = MainWindow.MAX_WIDTH;
        if ((n = n3 - n + n5 + 6) >= n6 - 19) {
            n -= n5 + 19;
        }
        n2 = 25 + n4 - n2 - 178;
        return new Point(n, n2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.shouldLabelClose()) {
            return;
        }
        if (n < 55 && n >= 32) {
            AbsTrigger absTrigger = this.ts.getTrigger();
            absTrigger.nextStatus();
            this.tc.doSubmit();
            this.cm.pcs.firePropertyChange("NextStatus", null, null);
            this.loadImage2(absTrigger);
            this.repaint();
            return;
        }
        if (n >= 55 && n < 125) {
            Point point = this.getSliderBarLocation(n, n2, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getComponent());
            if (this.ts.isVoltsenseSupport() && this.ci != null) {
                int n3 = this.ts.getVoltsenseHalfRange();
                VoltsensableTrigger voltsensableTrigger = (VoltsensableTrigger)this.ts.getTrigger();
                Voltsensor voltsensor = this.ts.getVoltsense();
                int n4 = voltsensor.c_getVoltsense();
                n4 = this.ci.getInverseValue(n4);
                SymmetrySliderBar.createSymmetrySliderFrame(WindowUtil.getWindow(mouseEvent), point.x, point.y, n3, this.ci.getPos0byRange(n3), n3 - n4, true, this.ci.getColor(), 3, new VoltSliderAdapter(this.tc, this.ci, this.ts.getVoltsenseHalfRange(), voltsensableTrigger), I18nProvider.bundle());
                Platform.getMainWindow().update_ChangeVoltsense(this.idx);
            }
            return;
        }
        if (n >= 5 && n < 32) {
            if (this.tc.isSingleTrg()) {
                int n5;
                while ((n5 = this.tc.nextSingleChannel()) < this.tc.getChannelsNumber() && !this.wfm.getWaveForm((int)n5).wfi.ci.isOn()) {
                }
                this.cm.pcs.firePropertyChange("NextSingleChannel", null, (Object)this.tc.singleTriggerSet.getChannel());
                this.tc.doSubmit();
                this.setTriggerSet(this.tc.singleTriggerSet, this.tc.getSingleTrgChannel());
                this.repaint();
                this.cm.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
            }
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SwitchSlowMove")) {
            this.repaint();
        } else if (string.equals("SwitchNormalMove")) {
            this.repaint();
        } else if (string.equals("UpdateVoltsense")) {
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            if (n2 == this.idx) {
                this.repaint();
            }
        } else if (string.equals("UpdateUppLow") && (n = ((Integer)propertyChangeEvent.getNewValue()).intValue()) == this.idx) {
            this.repaint();
        }
    }

    private boolean shouldLabelClose() {
        return this.ci != null && !this.ci.isOn() || this.cm.getFFTControl().isFFTon() || !this.tc.isTrgEnable();
    }
}

