/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.sub;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.dso.view.sub.InfoBlock;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.ui.layout.OneRowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class InfoPane
extends JPanel
implements Localizable,
PropertyChangeListener {
    private List<InfoBlock> ibs = new LinkedList<InfoBlock>();
    private ListIterator<InfoBlock> li;
    private WaveFormManager wfm;

    public InfoPane(DataHouse dataHouse) {
        this.setOpaque(false);
        this.setLayout(new OneRowLayout(1));
        this.initInfoBlocks(dataHouse);
    }

    private void initInfoBlocks(DataHouse dataHouse) {
        this.ibs.clear();
        this.removeAll();
        WaveFormManager waveFormManager = dataHouse.getWaveFormManager();
        this.init();
        int n = 1;
        Iterator<WaveForm> iterator = waveFormManager.getWaveFormInfoControl().getLowMachineWFIterator();
        ControlManager controlManager = dataHouse.controlManager;
        int n2 = controlManager.getSupportChannelsNumber();
        while (iterator.hasNext()) {
            WaveForm waveForm = iterator.next();
            if (n > n2) break;
            InfoBlock infoBlock = new InfoBlock(this, waveForm, controlManager);
            this.li.add(infoBlock);
            this.add(infoBlock);
            ++n;
        }
    }

    protected void init() {
        this.li = this.ibs.listIterator();
    }

    protected InfoBlock processSingle(WaveForm waveForm, boolean bl) {
        InfoBlock infoBlock = null;
        boolean bl2 = this.li.hasNext();
        if (bl2) {
            infoBlock = this.li.next();
            infoBlock.setWaveForm(waveForm);
            infoBlock.setSelected(bl);
        }
        return infoBlock;
    }

    protected void end() {
        while (this.li.hasNext()) {
            InfoBlock infoBlock = this.li.next();
            this.li.remove();
            this.remove(infoBlock);
        }
    }

    public void notify_a(InfoBlock infoBlock) {
        this.init();
        while (this.li.hasNext()) {
            InfoBlock infoBlock2 = this.li.next();
            if (infoBlock == infoBlock2) continue;
            infoBlock2.setSelected(false);
        }
        infoBlock.setSelected(true);
        int n = infoBlock.getChannelNumber();
        this.wfm.setSelectedWaveForm(n);
        this.repaint();
    }

    public void updatePos0(int n) {
        this.init();
        while (this.li.hasNext()) {
            InfoBlock infoBlock = this.li.next();
            if (infoBlock.getChannelNumber() != n) continue;
            infoBlock.updatePos0();
            infoBlock.repaint();
            break;
        }
    }

    public void updateFreqs() {
        this.init();
        while (this.li.hasNext()) {
            InfoBlock infoBlock = this.li.next();
            infoBlock.updateFreq();
        }
        this.repaint();
    }

    public void updateSelected(int n) {
        this.init();
        while (this.li.hasNext()) {
            InfoBlock infoBlock = this.li.next();
            boolean bl = infoBlock.getChannelNumber() == n;
            infoBlock.setSelected(bl);
        }
        this.repaint();
    }

    public void updateInfos(WaveFormManager waveFormManager) {
        this.wfm = waveFormManager;
        Iterator<WaveForm> iterator = waveFormManager.getWaveFormInfoControl().getLowMachineWFIterator();
        this.init();
        WaveForm waveForm = waveFormManager.getSelectedWaveForm();
        while (iterator.hasNext()) {
            WaveForm waveForm2 = iterator.next();
            this.processSingle(waveForm2, waveForm.equals(waveForm2));
        }
        this.repaint();
    }

    public void updateInfos2(WaveFormManager waveFormManager) {
        this.wfm = waveFormManager;
        Iterator<WaveForm> iterator = waveFormManager.getWaveFormInfoControl().getLowMachineWFIterator();
        this.init();
        WaveForm waveForm = waveFormManager.getSelectedWaveForm();
        while (iterator.hasNext()) {
            WaveForm waveForm2 = iterator.next();
            InfoBlock infoBlock = this.ibs.get(waveForm2.getChannelNumber());
            infoBlock.setWaveForm(waveForm2);
            infoBlock.setSelected(waveForm.equals(waveForm2));
        }
        this.repaint();
    }

    public void updateInfo(WaveForm waveForm) {
        InfoBlock infoBlock = this.get(waveForm.getChannelNumber());
        if (infoBlock != null) {
            infoBlock.setWaveForm(waveForm);
        }
        infoBlock.repaint();
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.init();
        while (this.li.hasNext()) {
            InfoBlock infoBlock = this.li.next();
            infoBlock.localize(resourceBundle);
        }
        this.repaint();
    }

    public void vbChangeForChannel(int n, int n2) {
        WaveForm waveForm = this.wfm.getWaveForm(n);
        if (waveForm.isOn()) {
            InfoBlock infoBlock = this.get(n);
            if (infoBlock != null) {
                infoBlock.getComboBoxOwner().selected(n2);
                Platform.getMainWindow().getToolPane().updateChannels();
            } else {
                DBG.errprintln("InfoPane cannot find InfoBlock!");
            }
        } else {
            this.wfm.setVoltBaseIndex(waveForm, n2);
        }
    }

    public InfoBlock get(int n) {
        this.init();
        while (this.li.hasNext()) {
            InfoBlock infoBlock = this.li.next();
            if (n != infoBlock.getChannelNumber()) continue;
            return infoBlock;
        }
        return null;
    }

    public void setInfoPaneEnable(boolean bl) {
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (string.equals("FFT_ON")) {
            this.setInfoPaneEnable(false);
        } else if (string.equals("FFT_OFF")) {
            this.setInfoPaneEnable(true);
        } else if (string.equals("ChannelOption")) {
            int n = (Integer)object;
            this.get(n).propertyChange(propertyChangeEvent);
        } else if (string.equals("tune_vbbChange")) {
            ChannelInfo channelInfo = (ChannelInfo)object;
            this.get(channelInfo.getNumber()).propertyChange(propertyChangeEvent);
        } else if (string.equals("UPDATE_CHLVOLT")) {
            int n = (Integer)object;
            this.get(n).propertyChange(propertyChangeEvent);
        }
    }
}

