/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.sub;

import com.owon.uppersoft.dso.function.MarkCursorControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.ChartScreen;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.sub.InfoBlock;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.ui.slider.SliderBarLocation;
import com.owon.uppersoft.vds.ui.slider.SliderDelegate;
import com.owon.uppersoft.vds.ui.slider.SymmetrySliderBar;
import com.owon.uppersoft.vds.ui.slider.SymmetrySliderView;
import com.owon.uppersoft.vds.ui.widget.ComboBoxOwner;
import com.owon.uppersoft.vds.ui.widget.OwnedComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeSupport;

public class InfoBlockAction
implements ComboBoxOwner,
SliderDelegate,
SliderBarLocation {
    private InfoBlock ib;
    private OwnedComboBox vbcbb = null;
    private MarkCursorControl mcctr;
    private ControlManager cm;
    private PropertyChangeSupport pcs;

    public InfoBlockAction(ControlManager controlManager, InfoBlock infoBlock) {
        this.ib = infoBlock;
        this.cm = controlManager;
        this.pcs = controlManager.pcs;
        this.mcctr = controlManager.mcctr;
    }

    @Override
    public void removeOwnedComboBox() {
        if (this.vbcbb != null) {
            this.ib.remove(this.vbcbb);
            this.vbcbb = null;
        }
    }

    @Override
    public void afterRemoved() {
        this.ib.returnVbFloor();
        this.pcs.firePropertyChange("dock_repaint", null, null);
    }

    public void incretSelect(int n) {
        WaveForm waveForm = this.ib.getWaveForm();
        if (!waveForm.isOn()) {
            return;
        }
        ChannelInfo channelInfo = waveForm.wfi.ci;
        this.selected(channelInfo.getVoltbaseIndex() + n);
    }

    @Override
    public void selected(int n) {
        WaveForm waveForm = this.ib.getWaveForm();
        ChannelInfo channelInfo = waveForm.wfi.ci;
        WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
        boolean bl = waveFormManager.setVoltBaseIndex(waveForm, n);
        if (!bl) {
            return;
        }
        this.mcctr.computeYValues();
        waveFormManager.getFFTView().updateYScaleRate();
        this.pcs.firePropertyChange("tune_vbbChange", null, channelInfo);
        this.ib.repaint();
        Platform.getMainWindow().getChartScreen().repaint();
    }

    public void onBlockPressed2Select(ChannelInfo channelInfo) {
        ChartScreen chartScreen = Platform.getMainWindow().getChartScreen();
        chartScreen.setScreenSelectWFidx(channelInfo.getNumber());
        chartScreen.re_paint();
    }

    public void f2_pos0Pressed(WaveForm waveForm, MouseEvent mouseEvent) {
        ChannelInfo channelInfo = waveForm.wfi.ci;
        this.cm.reduceFrame();
        if (this.vbcbb != null) {
            this.vbcbb.onReleaseFocus();
        }
        Point point = this.getSliderBarLocation(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getComponent());
        int n = point.x;
        int n2 = point.y;
        int n3 = channelInfo.getHalfPosRange();
        int n4 = channelInfo.getPos0byRange(n3);
        if (mouseEvent.getClickCount() == 2) {
            Dimension dimension = new Dimension(19, 178);
            SymmetrySliderView symmetrySliderView = new SymmetrySliderView(dimension, (n3 << 1) + 1, n3, n4, true, channelInfo.getColor(), this);
            symmetrySliderView.setDefault();
        } else {
            SymmetrySliderBar.createSymmetrySliderFrame(Platform.getMainWindow().getFrame(), n, n2, n3, n3, n4, true, channelInfo.getColor(), 1, this, I18nProvider.bundle());
        }
    }

    @Override
    public Point getSliderBarLocation(int n, int n2, int n3, int n4, Component component) {
        int n5 = 124;
        n = n5 + n3 - n + 2;
        n2 = 61 + n4 - n2 - 178 + 10;
        return new Point(n, n2);
    }

    public void f1_vbPressed(ChannelInfo channelInfo, int n) {
        this.cm.reduceFrame();
        this.ib.requestFocus();
        if (this.vbcbb == null) {
            Object[] objectArray = channelInfo.getVoltageLabels();
            this.vbcbb = new OwnedComboBox(objectArray, channelInfo.getVoltbaseIndex(), this, true);
            this.vbcbb.setMaximumRowCount(objectArray.length);
            this.vbcbb.setSelectedIndex(channelInfo.getVoltbaseIndex());
            this.vbcbb.setBounds(30, n - 19, 90, 22);
            this.ib.add(this.vbcbb);
            this.vbcbb.requestFocus();
            this.vbcbb.showPopup();
        }
    }

    public void f0_back_uncheck_Pressed(WaveForm waveForm) {
        ChannelInfo channelInfo = waveForm.wfi.ci;
        boolean bl = channelInfo.isOn();
        WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
        channelInfo.c_setOn(!bl);
        MainWindow mainWindow = Platform.getMainWindow();
        if (bl && this.cm.mathControl.isMathChannelUse(waveForm.getChannelNumber())) {
            String string = I18nProvider.bundle().getString("M.Math.Name") + ":" + waveForm.toString() + " " + I18nProvider.bundle().getString("M.Channel.OffRemind");
            FadeIOShell fadeIOShell = new FadeIOShell();
            fadeIOShell.prompt(string, mainWindow.getFrame());
        }
        this.pcs.firePropertyChange("ChannelOption", -1, channelInfo.getNumber());
        this.pcs.firePropertyChange("tune_chlnumsChange", null, null);
        mainWindow.channelOnOffRepaint(waveForm);
    }

    public void f1_couplingPressed(ChannelInfo channelInfo) {
        channelInfo.c_setNextCoupling();
        this.pcs.firePropertyChange("CouplingOption", null, null);
        this.ib.repaint();
    }

    protected void clickInverse(ChannelInfo channelInfo) {
        channelInfo.c_setInverse(!channelInfo.isInverse());
        this.pcs.firePropertyChange("UpdateVoltsense", -1, channelInfo.getNumber());
        Platform.getMainWindow().updateShow();
        this.ib.repaint();
    }

    public void f1_notPressed() {
        if (this.vbcbb != null) {
            this.vbcbb.onReleaseFocus();
        }
    }

    public void chl_dockToggle(boolean bl) {
        if (bl || !this.cm.getDockControl().isVisible()) {
            this.cm.getDockControl().dockDialogQuickOpenHide("M.Channel.Name");
        }
        this.chl_dockSelect();
    }

    public void chl_dockSelect() {
        if (this.cm.getDockControl().isVisible()) {
            this.pcs.firePropertyChange("CHOOSE_CHANNELS", null, null);
        }
    }

    @Override
    public void valueChanged(int n, int n2) {
        WaveForm waveForm = this.ib.getWaveForm();
        ChannelInfo channelInfo = waveForm.wfi.ci;
        n2 = channelInfo.getHalfPosRange() - n2;
        this.valueChanged_Directly(n2);
    }

    public int valueChanged_Directly(int n) {
        WaveForm waveForm = this.ib.getWaveForm();
        ChannelInfo channelInfo = waveForm.wfi.ci;
        MainWindow mainWindow = Platform.getMainWindow();
        DataHouse dataHouse = Platform.getDataHouse();
        dataHouse.getWaveFormManager().setZeroYLoc(waveForm, n, true);
        this.ib.updatePos0();
        this.ib.repaint();
        this.mcctr.computeYValues();
        mainWindow.update_Pos0();
        return channelInfo.getPos0();
    }

    @Override
    public void actionOff() {
    }

    @Override
    public void on50percent() {
    }

    @Override
    public void onDispose() {
    }
}

