/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.sub;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.pref.Style;
import com.owon.uppersoft.dso.view.sub.InfoBlockAction;
import com.owon.uppersoft.dso.view.sub.InfoPane;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.widget.ComboBoxOwner;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;

public class InfoBlock
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
Localizable,
PropertyChangeListener {
    public static final int floor0 = 30;
    public static final int floor1 = 45;
    public static final int floor2 = 61;
    public static final int floor3 = 77;
    public static final int BlockHeight = 82;
    public static final int BlockWidth = 124;
    public static final Dimension DefaultBlockSize = new Dimension(125, 83);
    public String vblbl;
    public String pos0lbl;
    public String freqlbl;
    private WaveForm wf;
    private boolean select = false;
    private int name;
    private static final String onPath = "/com/owon/uppersoft/dso/image/on.png";
    private static final String offPath = "/com/owon/uppersoft/dso/image/off.png";
    public static final Icon onImage;
    public static final Icon offImage;
    private static final String selPath;
    private static final String unsPath;
    public static final Image selImage;
    public static final Image unsImage;
    private InfoPane inp;
    private ControlManager cm;
    private InfoBlockAction ibd;
    private boolean onVBline;
    public static final int txtstart = 40;
    public static final int hlstart = 35;
    public static final int hllen = 85;
    public static final int hlhigh = 15;
    public static final int onoffstart = 102;
    public static final int iconend = 25;
    private int leftlinePos = -1;
    private int linePos = -1;
    private boolean mouseover = false;
    private Icon onoffImage;

    public void setSelected(boolean bl) {
        this.select = bl;
    }

    public WaveForm getWaveForm() {
        return this.wf;
    }

    private ChannelInfo getChannelInfo() {
        return this.wf.wfi.ci;
    }

    public int getChannelNumber() {
        return this.getChannelInfo().getNumber();
    }

    private String getDivUnit() {
        return this.cm.getDivUnit();
    }

    private String getDivUnits() {
        return this.cm.getDivUnits();
    }

    public void updateVolt() {
        ChannelInfo channelInfo = this.getChannelInfo();
        this.vblbl = channelInfo.getVoltageLabel() + "/" + this.getDivUnit();
    }

    private void updateVBLabel() {
        ChannelInfo channelInfo = this.getChannelInfo();
        this.vblbl = channelInfo.getVoltageLabel() + "/" + this.getDivUnit();
    }

    public void updatePos0() {
        ChannelInfo channelInfo = this.getChannelInfo();
        this.pos0lbl = (double)channelInfo.getPos0() / 25.0 + " " + this.getDivUnits();
    }

    public void updateFreq() {
        this.freqlbl = this.cm.getFreqLabel(this.getChannelInfo());
    }

    private void updateONOFFImage() {
        this.onoffImage = this.getChannelInfo().isOn() ? offImage : onImage;
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.updateVolt();
        this.updatePos0();
    }

    public void setWaveForm(WaveForm waveForm) {
        this.wf = waveForm;
        WaveFormInfo waveFormInfo = waveForm.wfi;
        ChannelInfo channelInfo = waveFormInfo.ci;
        this.vblbl = channelInfo.getVoltageLabel() + "/" + this.getDivUnit();
        this.pos0lbl = (double)channelInfo.getPos0() / 25.0 + " " + this.getDivUnits();
        this.freqlbl = this.cm.getFreqLabel(channelInfo);
        this.name = channelInfo.getNumber() + 1;
        this.updateONOFFImage();
    }

    public InfoBlock(InfoPane infoPane, WaveForm waveForm, ControlManager controlManager) {
        this.ibd = new InfoBlockAction(controlManager, this);
        this.cm = controlManager;
        this.inp = infoPane;
        this.setWaveForm(waveForm);
        this.setPreferredSize(DefaultBlockSize);
        this.setLayout(null);
        this.setOpaque(false);
        this.setFont(Define.def.alphafont);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public InfoBlockAction getInfoBlockDelegate() {
        return this.ibd;
    }

    public ComboBoxOwner getComboBoxOwner() {
        return this.ibd;
    }

    public void returnVbFloor() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        Point point2 = this.getLocationOnScreen();
        if (point.x >= point2.x + 35 && point.x <= point2.x + 85 && point.y >= point2.y + 30 && point.y <= point2.y + 45) {
            this.linePos = 45;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        ChannelInfo channelInfo = this.getChannelInfo();
        boolean bl = channelInfo.isOn();
        boolean bl2 = this.cm.getFFTControl().isFFTon();
        boolean bl3 = this.select;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (bl && n2 < 30 && n >= 102 && !bl2) {
            this.ibd.f0_back_uncheck_Pressed(this.wf);
            this.select = false;
            return;
        }
        if (!bl3) {
            this.inp.notify_a(this);
            this.ibd.onBlockPressed2Select(channelInfo);
        }
        if (!bl && !bl2) {
            this.ibd.f0_back_uncheck_Pressed(this.wf);
            this.ibd.chl_dockSelect();
            return;
        }
        if (this.linePos == 61) {
            if (bl) {
                this.ibd.f2_pos0Pressed(this.wf, mouseEvent);
            }
        } else if (this.linePos == 45) {
            if (bl) {
                this.ibd.f1_vbPressed(channelInfo, 45);
            }
        } else if (n2 < 30) {
            if (n > 25 && n < 102) {
                this.ibd.chl_dockSelect();
            } else if (n <= 25) {
                this.ibd.chl_dockToggle(bl3);
            } else if (n >= 102) {
                if (this.cm.getFFTControl().isFFTon()) {
                    return;
                }
                this.ibd.f0_back_uncheck_Pressed(this.wf);
            }
        }
        if (this.linePos != 45) {
            this.ibd.f1_notPressed();
        }
        if (this.leftlinePos == 45 && bl) {
            this.ibd.f1_couplingPressed(channelInfo);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 12;
        boolean bl = this.wf.isOn();
        boolean bl2 = false;
        this.onVBline = false;
        if (n2 > 30) {
            if (!bl) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (n < 35) {
                int n4;
                this.linePos = -1;
                bl2 = true;
                if (n2 < 45) {
                    n4 = 45;
                } else if (n2 >= 45 && n2 < 61) {
                    n4 = 61;
                    n3 = 0;
                } else {
                    n4 = 77;
                    n3 = 0;
                }
                if (this.leftlinePos != n4) {
                    this.leftlinePos = n4;
                    bl2 = true;
                    this.setCursor(Cursor.getPredefinedCursor(n3));
                }
            } else {
                int n5;
                this.leftlinePos = -1;
                bl2 = true;
                if (n2 < 45) {
                    n5 = 45;
                    this.onVBline = true;
                } else if (n2 >= 45 && n2 < 61) {
                    n5 = 61;
                } else {
                    n5 = 77;
                    n3 = 0;
                }
                if (this.linePos != n5) {
                    this.linePos = n5;
                    bl2 = true;
                    this.setCursor(Cursor.getPredefinedCursor(n3));
                }
            }
        } else {
            int n6 = 30;
            n3 = 0;
            if (this.linePos != n6) {
                this.leftlinePos = this.linePos = n6;
                bl2 = true;
            }
            this.setCursor(Cursor.getPredefinedCursor(n3));
        }
        if (bl2) {
            this.applyDetailPaneToolTip(this.linePos);
            this.repaint();
        }
    }

    private void applyDetailPaneToolTip(int n) {
        ResourceBundle resourceBundle = I18nProvider.bundle();
        block0 : switch (this.leftlinePos) {
            case 45: {
                this.setToolTipText(resourceBundle.getString("ToolTip.Coupling"));
                break;
            }
            default: {
                switch (n) {
                    case 45: {
                        int n2 = this.getChannelNumber() + 1;
                        this.setToolTipText(resourceBundle.getString("ToolTip.Voltbase.CH" + n2));
                        break block0;
                    }
                    case 61: {
                        this.setToolTipText(resourceBundle.getString("ToolTip.Offset"));
                        break block0;
                    }
                }
                this.setToolTipText(null);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseover = false;
        this.linePos = -1;
        this.leftlinePos = -1;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        ChannelInfo channelInfo = this.getChannelInfo();
        boolean bl = channelInfo.isOn();
        if (bl && this.select) {
            graphics2D.setColor(channelInfo.getColor());
            graphics2D.fillRoundRect(0, 0, 123, 81, 11, 11);
            graphics2D.drawImage(selImage, 0, 0, null);
        } else {
            graphics2D.drawImage(unsImage, 0, 0, null);
        }
        if (this.linePos > 30 && this.linePos < 77 && bl) {
            graphics2D.setColor(Define.def.style.CO_INFOBLOCK_HIGHLIGHT);
            graphics2D.fillRect(35, this.linePos - 15, 85, 15);
        }
        if (this.leftlinePos == 45) {
            graphics2D.setColor(Define.def.style.CO_INFOBLOCK_HIGHLIGHT);
            graphics2D.fillRect(0, 30, 35, 15);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!bl) {
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawRoundRect(5, 4, 20, 20, 6, 6);
            graphics2D.drawString(String.valueOf(channelInfo.getNumber() + 1), 11, 19);
        } else {
            graphics2D.setColor(channelInfo.getColor());
            graphics2D.fillRoundRect(5, 4, 20, 20, 6, 6);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(String.valueOf(channelInfo.getNumber() + 1), 11, 19);
        }
        if (this.mouseover) {
            graphics2D.setColor(Color.WHITE);
            Font font = graphics2D.getFont();
            graphics2D.setFont(Define.def.OnOffFont);
            if (!this.cm.getFFTControl().isFFTon()) {
                this.onoffImage.paintIcon(null, graphics, 102, 5);
            }
            graphics2D.setFont(font);
            if (bl) {
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(channelInfo.getProbeLabel(), graphics);
                graphics2D.drawLine(40, 61, 110, 61);
                graphics2D.drawLine(5, 45, 30, 45);
                graphics2D.drawLine(40, 45, 110, 45);
            }
        }
        graphics2D.setColor(bl ? Color.WHITE : Color.DARK_GRAY);
        if (channelInfo.isBandlimit() && this.cm.isBandLimit()) {
            graphics2D.drawString("(b)", 40, 25);
        }
        graphics2D.drawString(this.vblbl, 40, 43);
        graphics2D.drawString(this.pos0lbl, 40, 59);
        graphics2D.drawString(this.freqlbl, 40, 75);
        graphics2D.drawString(ChannelInfo.COUPLINGCHARS[channelInfo.getCouplingIdx()], 5, 43);
        graphics2D.setColor(this.mouseover || this.select ? channelInfo.getColor() : Define.def.CO_INFOBLOCK_BORDER);
        graphics2D.drawRoundRect(0, 0, 123, 81, 11, 11);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void paintLightText(Graphics2D graphics2D) {
        if (this.mouseover) {
            Font font = graphics2D.getFont();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.15f));
            graphics2D.setFont(Define.def.LightTextFont);
            graphics2D.setColor(this.wf.getColor());
            graphics2D.drawString(this.vblbl, 38, 43);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.setFont(font);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        ChannelInfo channelInfo = this.getChannelInfo();
        if (!channelInfo.isOn()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n2 < 30) {
            // empty if block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseover = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.onVBline) {
            int n = mouseWheelEvent.getWheelRotation();
            this.ibd.incretSelect(n);
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("ChannelOption")) {
            this.updateONOFFImage();
        } else if (string.equals("tune_vbbChange")) {
            this.updateVBLabel();
        } else if (string.equals("UPDATE_CHLVOLT")) {
            this.updateVolt();
            this.repaint();
        }
    }

    static {
        selPath = Define.def.style.path + Style.selname + ".png";
        unsPath = Define.def.style.path + Style.unsname + ".png";
        offImage = SwingResourceManager.getIcon(InfoBlock.class, offPath);
        onImage = SwingResourceManager.getIcon(InfoBlock.class, onPath);
        selImage = SwingResourceManager.getIcon(InfoBlock.class, selPath).getImage();
        unsImage = SwingResourceManager.getIcon(InfoBlock.class, unsPath).getImage();
    }
}

