/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.sub;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.mode.control.DeepMemoryControl;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.pref.Style;
import com.owon.uppersoft.dso.view.sub.InfoBlock;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.zoom.AssitControl;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.data.Range;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.slider.SliderAdapter;
import com.owon.uppersoft.vds.ui.slider.SliderBarLocation;
import com.owon.uppersoft.vds.ui.slider.SymmetrySliderBar;
import com.owon.uppersoft.vds.ui.widget.ComboBoxOwner;
import com.owon.uppersoft.vds.ui.widget.OwnedComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class DetailPane
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
Localizable,
SliderBarLocation,
PropertyChangeListener {
    public static final String horposPath = Define.def.style.path + Style.DetailPname;
    private static Image img = SwingResourceManager.getIcon(InfoBlock.class, horposPath).getImage();
    public static final int BlockHeigth = 103;
    public static final int BlockWidth = 126;
    public static final int floor0 = 22;
    public static final int floor1 = 47;
    public static final int floor2 = 72;
    public static final int floor3 = 96;
    private String timebase;
    private String trigPos;
    private String memdepth;
    private String sampling;
    private OwnedComboBox tbcbb;
    private OwnedComboBox dmcbb;
    private ControlManager cm;
    private DataHouse dh;
    protected CoreControl cc;
    private TimeControl tc;
    private DeepMemoryControl dmc;
    private String ht;
    private int linePos = -1;
    public static final int hllen = 120;
    public static final int hlhigh = 19;
    private boolean enable;

    public DetailPane(DataHouse dataHouse) {
        this.dh = dataHouse;
        this.cm = dataHouse.controlManager;
        this.cc = this.cm.getCoreControl();
        this.tc = this.cc.getTimeControl();
        this.dmc = this.cc.getDeepMemoryControl();
        this.setLayout(null);
        this.setOpaque(false);
        this.setFont(Define.def.alphafont);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.updateInfo();
    }

    public void updateInfo() {
        AssitControl assitControl = this.cm.getZoomAssctr();
        this.ht = assitControl.isonZoom() ? "W     " : "M      ";
        this.timebase = this.ht + this.tc.getTimebaseLabel() + " /" + this.cm.getDivUnit();
        this.trigPos = "T      " + this.tc.getHorizontalTriggerLabel();
        this.memdepth = "D      " + this.dmc.getDeepLabel();
        this.updateSampleRate();
    }

    public void updateDM_Sample() {
        this.memdepth = "D      " + this.dmc.getDeepLabel();
        this.updateSampleRate();
        this.repaint();
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.timebase = this.ht + this.tc.getTimebaseLabel() + " /" + this.cm.getDivUnit();
    }

    public void doUpdateSampleRate() {
        this.updateSampleRate();
        this.repaint();
    }

    private void updateSampleRate() {
        String string = this.cc.getCurrentSampleRate_Text();
        this.sampling = string == null || string.length() == 0 ? "" : "S      " + string;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.enable) {
            return;
        }
        int n = mouseEvent.getY();
        int n2 = -1;
        n2 = n >= 0 && n < 22 ? 22 : (n >= 22 && n < 47 ? 47 : (n >= 47 && n < 72 ? 72 : 96));
        if (n2 != this.linePos) {
            this.linePos = n2;
            this.applyDetailPaneToolTip(this.linePos);
            this.repaint();
        }
    }

    private void applyDetailPaneToolTip(int n) {
        ResourceBundle resourceBundle = I18nProvider.bundle();
        switch (n) {
            case 22: {
                this.setToolTipText(resourceBundle.getString("ToolTip.Timebase"));
                break;
            }
            case 47: {
                this.setToolTipText(resourceBundle.getString("ToolTip.HorTrgPos"));
                break;
            }
            case 72: {
                this.setToolTipText(resourceBundle.getString("ToolTip.DeepMemory"));
                break;
            }
            case 96: {
                this.setToolTipText(resourceBundle.getString("ToolTip.Sampling"));
                break;
            }
        }
    }

    public void nextTimeBase(int n) {
        boolean bl = this.cm.isTimeOperatable();
        if (!bl) {
            return;
        }
        int n2 = this.tc.getTimebaseIdx();
        this.changeTimeBase(n2 += n);
    }

    public void removeTBOwnedComboBox() {
        if (this.tbcbb != null) {
            this.remove(this.tbcbb);
            this.tbcbb = null;
            this.repaint();
        }
    }

    public void changeTimeBase(int n) {
        boolean bl = Platform.getControlApps().interComm.isTimeOperatableNTryGetDM();
        if (!bl) {
            return;
        }
        this.tc.c_setTimebaseIdx(n, true);
    }

    public void changeFFTTimeBase(int n) {
        this.tc.c_setTimebaseIdx(n, true);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.enable) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        AssitControl assitControl = this.cm.getZoomAssctr();
        if (this.linePos == 22) {
            if (assitControl.isonAssistSet()) {
                FadeIOShell fadeIOShell = new FadeIOShell();
                fadeIOShell.prompt(I18nProvider.bundle().getString("M.Zoom.Warn"), this.getWindow());
                return;
            }
            if (n < 30) {
                if (!AssitControl.FastMWstwich) {
                    return;
                }
                int n3 = assitControl.isonZoom() ? 0 : 2;
                assitControl.changeZoomstatus(this.cm, n3);
                this.cm.pcs.firePropertyChange("zoomSelected", null, (Object)n3);
                if (this.tbcbb != null) {
                    this.tbcbb.onReleaseFocus();
                }
                this.updateInfo();
                this.repaint();
            } else {
                boolean bl = Platform.getControlApps().interComm.isTimeOperatableNTryGetDM();
                if (!bl) {
                    return;
                }
                if (assitControl.isonZoom() && !AssitControl.FastMWstwich) {
                    return;
                }
                this.requestFocus();
                if (this.tbcbb == null) {
                    this.tbcbb = new OwnedComboBox(this.cc.getMachineInfo().TIMEBASE, this.tc.getTimebaseIdx(), new ComboBoxOwner(){

                        @Override
                        public void selected(int n) {
                            DetailPane.this.changeTimeBase(n);
                        }

                        @Override
                        public void removeOwnedComboBox() {
                            DetailPane.this.removeTBOwnedComboBox();
                        }

                        @Override
                        public void afterRemoved() {
                            ((DetailPane)DetailPane.this).cm.pcs.firePropertyChange("dock_repaint", null, null);
                        }
                    }, true);
                    this.tbcbb.setMaximumRowCount(12);
                    this.add(this.tbcbb);
                    this.tbcbb.setBounds(35, 4, 80, 22);
                    this.tbcbb.setSelectedIndex(this.tc.getTimebaseIdx());
                    this.tbcbb.requestFocus();
                    this.tbcbb.showPopup();
                }
            }
        } else if (this.linePos == 72) {
            if (this.dmcbb == null && this.cc.getDeepProvider().getDeepNumber() > 1) {
                this.dmcbb = new OwnedComboBox(this.cc.getMachineInfo().DEEP, this.dmc.getDeepIdx(), new ComboBoxOwner(){

                    @Override
                    public void selected(int n) {
                        DetailPane.this.dmselected(n);
                    }

                    @Override
                    public void removeOwnedComboBox() {
                        if (DetailPane.this.dmcbb != null) {
                            DetailPane.this.remove(DetailPane.this.dmcbb);
                            DetailPane.this.dmcbb = null;
                            DetailPane.this.repaint();
                        }
                    }

                    @Override
                    public void afterRemoved() {
                    }
                }, true);
                this.add(this.dmcbb);
                this.dmcbb.setBounds(35, 54, 80, 22);
                this.dmcbb.setSelectedIndex(this.dmc.getDeepIdx());
                this.dmcbb.requestFocus();
                this.dmcbb.showPopup();
            }
        } else if (this.linePos == 47) {
            if (this.tbcbb != null) {
                this.tbcbb.onReleaseFocus();
            }
            if (this.dmcbb != null) {
                this.dmcbb.onReleaseFocus();
            }
            if (!this.cm.shouldAdjustHorTrgPos()) {
                return;
            }
            Range range = this.tc.getHorTrgRange();
            Point point = this.getSliderBarLocation(n, n2, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getComponent());
            SymmetrySliderBar.createUnsymmetrySliderFrame(this.getWindow(), point.x, point.y, -range.left, -range.right, false, -this.tc.getHorizontalTriggerPosition(), new SliderAdapter(){

                @Override
                public void valueChanged(int n, int n2) {
                    DetailPane.this.setHorizontalTriggerPosition(-n2);
                }

                @Override
                public void actionOff() {
                }
            }, I18nProvider.bundle());
        }
        if (this.linePos != 72 && this.dmcbb != null) {
            this.dmcbb.onReleaseFocus();
        }
        if (this.linePos != 22 && this.tbcbb != null) {
            this.tbcbb.onReleaseFocus();
        }
    }

    public int getHorizontalTriggerPosition() {
        int n = this.tc.getHorizontalTriggerPosition();
        return n;
    }

    public void setHorizontalTriggerPosition(int n) {
        this.tc.c_setHorizontalTriggerPosition(n);
        this.trigPos = "T       " + this.tc.getHorizontalTriggerLabel();
        this.repaint();
        this.cm.mcctr.computeXValues();
        this.cm.getZoomAssctr().updateZoomHtp();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(img, 0, 0, null);
        int n = 10;
        if (this.linePos >= 22 && this.linePos < 96) {
            graphics.setColor(Define.def.style.CO_INFOBLOCK_HIGHLIGHT);
            graphics.fillRect(3, this.linePos - 17, 120, 19);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.enable) {
            graphics.setColor(Color.gray);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.drawString(this.timebase, n, 22);
        graphics.drawString(this.trigPos, n, 47);
        graphics.drawString(this.memdepth, n, 72);
        graphics.drawString(this.sampling, n, 96);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.linePos == 22) {
            int n = mouseWheelEvent.getWheelRotation();
            this.nextTimeBase(n);
        } else if (this.linePos == 72) {
            int n = mouseWheelEvent.getWheelRotation();
            this.nextDMselected(n);
        }
    }

    private void nextDMselected(int n) {
        int n2 = this.dmc.getDeepIdx();
        this.dmselected(this.dmc.restrictDMidx(n2 + n));
    }

    public void dmselected(int n) {
        boolean bl;
        if (this.cm.displayControl.isXYModeOn() && (bl = DeepMemoryControl.restrictShouldChange(n))) {
            FadeIOShell fadeIOShell = new FadeIOShell();
            fadeIOShell.prompt(I18nProvider.bundle().getString("Info.XYModeForceDeepMemory"), this.getWindow());
            return;
        }
        this.dmc.c_setDeepIdx(n);
        this.updateDM_Sample();
    }

    private Window getWindow() {
        return Platform.getMainWindow().getWindow();
    }

    @Override
    public Point getSliderBarLocation(int n, int n2, int n3, int n4, Component component) {
        n = n3 - n - 25;
        n2 = n4 - n2 + 47 + 5;
        return new Point(n, n2);
    }

    public void setDetailPaneEnable(boolean bl) {
        this.enable = bl;
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("FFT_ON")) {
            this.setDetailPaneEnable(false);
            this.doUpdateSampleRate();
        } else if (string.equals("FFT_OFF")) {
            this.setDetailPaneEnable(true);
            this.doUpdateSampleRate();
        } else if (string.equals("onTimebaseUpdated")) {
            this.updateInfo();
            this.repaint();
        } else if (string.equals("onHTPChanged")) {
            this.updateInfo();
            this.repaint();
        } else if (string.equals("onHorTrgPosChangedByTimebase")) {
            this.updateInfo();
            this.repaint();
        } else if (string.equals("sampleRateUpdated")) {
            this.updateInfo();
            this.repaint();
        }
    }
}

