/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.sub;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.pref.Style;
import com.owon.uppersoft.dso.view.ChartScreen;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.TitlePane;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.paint.PaintContext;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.widget.custom.LButton;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ButtonPane
extends JPanel
implements Localizable,
PropertyChangeListener {
    public static final String UPDATE_TUNE_BUTTON = "updateTuneButton";
    public static final String ToolPath = Define.def.style.path + Style.Toolname;
    public static final String Tool_pPath = Define.def.style.path + Style.Tool_pname;
    public static final String _3in1Path = Define.def.style.path + Style._3in1name;
    public static final String _1in1Path = Define.def.style.path + Style._3in1_pname;
    public static final String factoryPath = Define.def.style.path + "factoryset.png";
    public static final String factory_pPath = Define.def.style.path + "factoryset_p.png";
    public static final String exportPath = Define.def.style.path + "export.png";
    public static final String export_pPath = Define.def.style.path + "export_p.png";
    public static final String export_dPath = Define.def.style.path + "export_d.png";
    private MainWindow mw;
    private DataHouse dh;
    private JLabel empty;
    private JLabel frmlbl;
    private float fps;
    private int cmdCount;
    private int wfs;
    private int points;
    private String pkn = "";
    static int v;
    public static final int Height = 70;
    private static final int btnW = 37;
    private static final int btnH = 45;
    private LButton btn_3in1;
    private LButton toolbtn;
    private LButton factorybtn;
    private LButton pau_expbtn;
    private JButton tunebtn;

    public ButtonPane(final MainWindow mainWindow, final ControlManager controlManager, final DataHouse dataHouse) {
        this.mw = mainWindow;
        this.dh = dataHouse;
        this.setBackground(Color.BLACK);
        FlowLayout flowLayout = new FlowLayout(2, 0, 0);
        this.setLayout(flowLayout);
        LButton lButton = new LButton("Patch");
        lButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dataHouse.getControlManager().isRuntime()) {
                    ButtonPane.this.quickPatch();
                }
            }
        });
        lButton.setVisible(false);
        this.tunebtn = new LButton("tune");
        this.tunebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                controlManager.getPrinciple().openTuneDialog(mainWindow.getFrame(), controlManager.pcs);
            }
        });
        this.tunebtn.setVisible(false);
        ImageIcon imageIcon = SwingResourceManager.getIcon(TitlePane.class, exportPath);
        this.pau_expbtn = new LButton();
        this.pau_expbtn.setIcon(imageIcon);
        imageIcon = SwingResourceManager.getIcon(TitlePane.class, export_pPath);
        this.pau_expbtn.setRolloverIcon(imageIcon);
        imageIcon = SwingResourceManager.getIcon(TitlePane.class, export_dPath);
        this.pau_expbtn.setDisabledIcon(imageIcon);
        this.pau_expbtn.setPreferredSize(new Dimension(37, 45));
        this.pau_expbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                controlManager.ewc.exportDMfile(mainWindow.getFrame());
            }
        });
        imageIcon = SwingResourceManager.getIcon(TitlePane.class, factoryPath);
        this.factorybtn = new LButton();
        this.factorybtn.setIcon(imageIcon);
        imageIcon = SwingResourceManager.getIcon(TitlePane.class, factory_pPath);
        this.factorybtn.setRolloverIcon(imageIcon);
        this.factorybtn.setPreferredSize(new Dimension(37, 45));
        this.factorybtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                controlManager.defaultSet();
                controlManager.pcs.firePropertyChange("UPDATE_FACTORY_VIEW", null, null);
            }
        });
        this.toolbtn = new LButton();
        controlManager.getDockControl().initialize(mainWindow.getWindow(), controlManager.pcs, this.toolbtn);
        this.toolbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                controlManager.getDockControl().dockDlgOnOff();
            }
        });
        imageIcon = SwingResourceManager.getIcon(TitlePane.class, ToolPath);
        this.toolbtn.setIcon(imageIcon);
        this.toolbtn.setRolloverIcon(SwingResourceManager.getIcon(TitlePane.class, Tool_pPath));
        this.toolbtn.setPressedIcon(imageIcon);
        this.toolbtn.setPreferredSize(new Dimension(45, 45));
        imageIcon = SwingResourceManager.getIcon(TitlePane.class, _3in1Path);
        this.btn_3in1 = new LButton();
        this.btn_3in1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonPane.this.switch_3in1();
            }
        });
        this.btn_3in1.setIcon(imageIcon);
        imageIcon = SwingResourceManager.getIcon(TitlePane.class, _1in1Path);
        this.btn_3in1.setRolloverIcon(imageIcon);
        this.btn_3in1.setPreferredSize(new Dimension(37, 45));
        this.frmlbl = new JLabel();
        this.frmlbl.setPreferredSize(new Dimension(250, 25));
        this.frmlbl.setForeground(Color.white);
        this.empty = new JLabel();
        this.empty.setPreferredSize(new Dimension(37, 95 - this.toolbtn.getHeight()));
        this.add(this.empty);
        this.add(lButton);
        this.add(this.tunebtn);
        this.add(this.factorybtn);
        this.add(this.pau_expbtn);
        this.add(this.btn_3in1);
        this.add(this.toolbtn);
        this.add(this.frmlbl);
        this.onekeyTurnPrint(false);
        this.updateLabel();
    }

    private void onekeyTurnPrint(boolean bl) {
        this.empty.setVisible(!bl);
        this.frmlbl.setVisible(bl);
    }

    private void updateFramesPerSe(float f) {
        this.fps = f;
        this.updateLabel();
    }

    private void updateCMDCounter(int n) {
        this.cmdCount = n;
        this.updateLabel();
    }

    private void updateFrameCounter(int n, int n2) {
        this.wfs = n;
        this.points = n2;
        this.updateLabel();
    }

    private void updateLabel() {
        this.frmlbl.setText(SFormatter.dataformat("fps:%.1f,cmd:%d,wfs:%d,pts:%d%s", Float.valueOf(this.fps), this.cmdCount, this.wfs, this.points, this.pkn));
    }

    public void factorySet() {
        int n = JOptionPane.showConfirmDialog(WindowUtil.getWindow(this), I18nProvider.bundle().getString("M.Utility.FactorySet.ConfirmTxt"), "", 0, 3);
        if (n == 0) {
            this.dh.controlManager.factorySet();
            this.factoryViewSet();
        }
    }

    protected void quickPatch() {
    }

    public void factoryViewSet() {
        this.factory_1in1();
        this.dh.controlManager.getDockControl().dockDialog2HomePage();
    }

    private void factory_1in1() {
        this.switch_3in1_fft(false);
    }

    public void switch_3in1() {
        ChartScreen chartScreen = this.mw.getChartScreen();
        boolean bl = chartScreen.is3in1();
        this.apply_3in1(!bl);
    }

    private void apply_3in1(boolean bl) {
        ChartScreen chartScreen = this.mw.getChartScreen();
        boolean bl2 = chartScreen.is3in1();
        if (bl != bl2) {
            bl2 = !bl2;
            chartScreen.update3in1(bl2);
        }
        this.updateBtn_3in1ToolTip(I18nProvider.bundle());
    }

    public void switch_3in1_fft(boolean bl) {
        boolean bl2 = this.dh.getWaveFormManager().getXYView().isOn();
        ChartScreen chartScreen = this.mw.getChartScreen();
        chartScreen.update3in1(bl |= bl2);
        this.updateBtn_3in1ToolTip(I18nProvider.bundle());
    }

    public void switch_3in1_xy(boolean bl) {
        boolean bl2 = this.dh.controlManager.getFFTControl().isFFTon();
        this.apply_3in1(bl |= bl2);
    }

    private void updateBtn_3in1ToolTip(ResourceBundle resourceBundle) {
        PaintContext paintContext = this.mw.getChartScreen().getPaintContext();
        if (paintContext.isScreenMode_3()) {
            this.btn_3in1.setToolTipText(resourceBundle.getString("ToolTip.3in1"));
        } else {
            this.btn_3in1.setToolTipText(resourceBundle.getString("ToolTip.1in1"));
        }
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.pau_expbtn.setToolTipText(resourceBundle.getString("ToolTip.Save"));
        this.factorybtn.setToolTipText(resourceBundle.getString("ToolTip.Restore"));
        this.toolbtn.setToolTipText(resourceBundle.getString("ToolTip.FuncMenu"));
        this.updateBtn_3in1ToolTip(resourceBundle);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("FFT_ON")) {
            this.pau_expbtn.setEnabled(false);
        } else if (string.equals("FFT_OFF")) {
            this.pau_expbtn.setEnabled(true);
        } else if (string.equals("ADMIN_ROOT_PASSWORD_NOTIFY")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.onekeyTurnPrint(bl);
            this.tunebtn.setVisible(bl);
        } else if (string.equals("UPDATE_CMD_COUNTER")) {
            this.updateCMDCounter((Integer)propertyChangeEvent.getNewValue());
        } else if (string.equals(UPDATE_TUNE_BUTTON)) {
            this.tunebtn.setVisible(true);
        } else if (string.equals("Pau_expBtnUpdate")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.pau_expbtn.setEnabled(bl);
        } else if (string.equals("UPDATE_FPS")) {
            Float f = (Float)propertyChangeEvent.getNewValue();
            this.updateFramesPerSe(f.floatValue());
        } else if (string.equals("UPDATE_PK")) {
            String string2;
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            String string3 = string2 = bl ? "pk" : "";
            if (!this.pkn.equals(string2)) {
                this.pkn = string2;
                this.updateLabel();
            }
        } else if (string.equals("updateFrameCounter")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            int n2 = (Integer)propertyChangeEvent.getOldValue();
            this.updateFrameCounter(n2, n);
        } else if (string.equals("UPDATE_FACTORY_VIEW")) {
            this.factoryViewSet();
        }
    }
}

