/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.function;

import com.owon.uppersoft.dso.about.AboutDialog;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.page.function.UtilityPage;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.TipsWindow;
import com.owon.uppersoft.dso.view.pane.dock.ContentPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.pref.Config;
import com.owon.uppersoft.vds.print.PrinterPreviewFrame;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import javax.swing.DefaultComboBoxModel;

public class UtilityPane
extends FunctionPanel {
    protected MainWindow mw;
    protected ContentPane cp;
    private boolean SCPIconsole = true;
    private CComboBox cbblocale;
    private CButton pau_expbtn;
    private Dimension pageDimension = new Dimension(125, 33);
    private boolean listening = false;

    public UtilityPane(ControlManager controlManager, ContentPane contentPane, UtilityPage utilityPage) {
        super(controlManager);
        this.cp = contentPane;
        this.mw = Platform.getMainWindow();
        Config config = controlManager.getConfig();
        MachineType machineType = controlManager.getMachine();
        this.createDataIOGroup(this.pageDimension, contentPane, utilityPage);
        this.createFunctionGroup(machineType, this.pageDimension, contentPane, utilityPage);
        this.createSoftGroup(config);
        this.localizeSelf();
        this.listening = true;
    }

    private void createSoftGroup(final Config config) {
        this.ncgp();
        this.nrip();
        this.nlbl("Action.Help");
        CButton cButton = this.nbtn("About.Name");
        this.nrip();
        CButton cButton2 = this.nbtn("M.TipsWindow.Tips");
        CButton cButton3 = this.nbtn("Action.Manual");
        cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.handleAboutInstance(config, UtilityPane.this.cm);
            }
        });
        cButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TipsWindow.show(UtilityPane.this.mw, UtilityPane.this.cm);
            }
        });
        cButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((UtilityPane)UtilityPane.this).cm.docManager.helpAction();
            }
        });
    }

    protected void createFunctionGroup(MachineType machineType, Dimension dimension, final ContentPane contentPane, final UtilityPage utilityPage) {
        CButton cButton;
        this.ncgp();
        this.nrip();
        this.nlbl("M.Utility.Settings");
        CButton cButton2 = this.nbtn("Action.FactorySet");
        this.nrip();
        final Config config = this.cm.getConfig();
        this.nlbl("M.Locale.Name");
        this.cbblocale = this.nccb(config.getLocales());
        this.cbblocale.setSelectedIndex(config.getLocaleIndex());
        this.cbblocale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                UtilityPane.this.executeLocalize(config);
                contentPane.repaint();
            }
        });
        this.nrip();
        this.nbtn("Action.Restore").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UtilityPane.this.cm.defaultSet();
                ((UtilityPane)UtilityPane.this).cm.pcs.firePropertyChange("UPDATE_FACTORY_VIEW", null, null);
            }
        });
        this.nbtn("Action.Store").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UtilityPane.this.cm.persist(UtilityPane.this.cm.getConfig().getSessionProperties());
            }
        });
        this.nrip();
        CButton cButton3 = this.nbtn("Action.SelfCorrect");
        cButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UtilityPane.this.askAutoCal();
            }
        });
        cButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UtilityPane.this.factorySet();
            }
        });
        if (machineType.isSupportNetwork()) {
            this.nrip();
            cButton = this.nbtn("M.Utility.MachineNet");
            cButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    contentPane.applyContent(utilityPage.getContentID(), "M.Utility.MachineNet", 1);
                }
            });
        }
        if (this.SCPIconsole) {
            this.nrip();
            cButton = this.nbtn("M.Utility.Console");
            cButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((UtilityPane)UtilityPane.this).cm.scpiServer.startSCPIConsole();
                }
            });
        }
    }

    protected void askAutoCal() {
    }

    private void createDataIOGroup(Dimension dimension, ContentPane contentPane, UtilityPage utilityPage) {
        this.ncgp();
        this.nrip();
        this.nlbl("M.Autoscale.Wave");
        CButton cButton = this.nbtn("Print.Print");
        cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterPreviewFrame.handlePrinterPreview(UtilityPane.this.mw, UtilityPane.this.cm);
            }
        });
        this.nrip();
        CButton cButton2 = this.nbtn("Action.Open");
        cButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UtilityPane.this.loadBinFile();
            }
        });
        this.pau_expbtn = this.nbtn("Action.Save");
        this.pau_expbtn.setEnabled(this.cm.isPau_expEnable());
        this.pau_expbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((UtilityPane)UtilityPane.this).cm.ewc.exportDMfile(UtilityPane.this);
            }
        });
    }

    private void loadBinFile() {
        Platform.getControlManager().ewc.loadDMfile(this);
    }

    public void factorySet() {
        this.mw.getToolPane().getButtonPane().factorySet();
    }

    protected void executeLocalize(Config config) {
        int n = this.cbblocale.getSelectedIndex();
        Platform.getDataHouse().adjustLocale_LocalizeWindow(config, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("Pau_expBtnUpdate")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.pau_expbtn.setEnabled(bl);
        } else if (string.equals("updateTxtLocales")) {
            this.cbblocale.setModel(new DefaultComboBoxModel<Object>(this.cm.getConfig().getLocales().toArray()));
            this.cbblocale.setSelectedIndex(this.cm.getConfig().getLocaleIndex());
        }
    }
}

