/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.function;

import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.source.usb.USBSourceManager;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import com.owon.uppersoft.vds.util.ui.ContextFileChooser;
import com.owon.uppersoft.vds.util.ui.ListComboBoxModel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestPane
extends FunctionPanel
implements Runnable {
    private USBSourceManager usbsm;
    private CLabel cl;
    private CComboBox comboBox;
    private CButton refreshButton;
    private CButton connectButton;
    private ControlApps ca;
    private CButton gen;
    private CButton autoGenButton;
    private CButton stopButton;
    private JProgressBar jpb;
    public static final int MaxMeasureTimes = 10;
    private boolean listening = false;

    public TestPane(ControlManager controlManager) {
        super(controlManager);
        this.usbsm = controlManager.sourceManager.getUSBSourceManager();
    }

    private void createConnectGroup() {
        this.ncgp();
        this.nrip();
        this.comboBox = this.nccb();
        this.refreshButton = this.nbtnt("refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(TestPane.this).start();
            }
        });
        this.connectButton = this.nbtnt(this.usbsm.isConnected() ? "Action.Disconnect" : "Action.Connect");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TestPane.this.usbsm.isConnected()) {
                    IDevice iDevice = (IDevice)TestPane.this.comboBox.getSelectedItem();
                    if (iDevice != null && ((TestPane)TestPane.this).cm.sourceManager.connectUSB(iDevice)) {
                        TestPane.this.connectButton.setText(I18nProvider.bundle().getString("Action.Disconnect"));
                    }
                } else {
                    ((TestPane)TestPane.this).cm.sourceManager.disconnectSource();
                    TestPane.this.connectButton.setText(I18nProvider.bundle().getString("Action.Connect"));
                }
            }
        });
        this.ca = Platform.getControlApps();
        this.nrip();
        this.gen = this.nbtnt("get");
        this.gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                    }
                }.start();
            }
        });
        this.autoGenButton = this.nbtnt("auto get");
        this.autoGenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestPane.this.ca.keepload();
            }
        });
        this.stopButton = this.nbtnt("stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestPane.this.ca.stopkeep();
            }
        });
        this.nrip();
        CButton cButton = this.nbtnt("StaDat");
        cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        final CButton cButton2 = this.nbtnt("DMem");
        this.nrip();
        this.jpb = new JProgressBar();
        this.ip.add(this.jpb);
        this.cl = this.nlblt("%");
        this.cl.setPreferredSize(new Dimension(80, 0));
        final ContextFileChooser contextFileChooser = new ContextFileChooser();
        cButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cButton2.setEnabled(false);
                File file = contextFileChooser.save();
                if (file == null) {
                    cButton2.setEnabled(true);
                    return;
                }
                new Thread(){

                    @Override
                    public void run() {
                    }
                }.start();
            }
        });
        this.localizeSelf();
        this.refreshButton.setEnabled(false);
        this.comboBox.setEditable(false);
        new Thread(this).start();
    }

    @Override
    public void run() {
        List<IDevice> list = this.usbsm.refreshUSBPort();
        ListComboBoxModel listComboBoxModel = new ListComboBoxModel(list);
        this.comboBox.setModel(listComboBoxModel);
        this.comboBox.setEnabled(true);
        this.refreshButton.setEnabled(true);
    }

    public void addInsideConfig() {
        this.ncgp();
        this.nrip();
        this.nlblt("Times: ");
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.cm.displayControl.CompositDrawTimes, 1, 10, 1));
        this.ip.add(jSpinner);
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!TestPane.this.listening) {
                    return;
                }
                ((TestPane)TestPane.this).cm.displayControl.CompositDrawTimes = (Integer)jSpinner.getValue();
            }
        });
        this.ncgp();
        this.nrip();
        this.listening = true;
    }

    private class PropertyCL
    implements PropertyChangeListener {
        private int num = -1;
        private int len = -1;
        private int range = -1;
        private int vl = 0;

        public PropertyCL() {
            TestPane.this.jpb.setValue(0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("TransFail")) {
                return;
            }
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (string.equals("DataLen")) {
                if (this.range < 0) {
                    this.len = n;
                    this.range = this.len * this.num;
                    TestPane.this.jpb.setMaximum(this.range);
                    TestPane.this.cl.setText(this.range + "");
                    this.vl = 0;
                    TestPane.this.jpb.setValue(0);
                }
            } else if (string.equals("ChlNum")) {
                this.num = n;
            } else if (string.equals("Progress")) {
                TestPane.this.jpb.setValue(this.vl += n);
            }
        }
    }
}

