/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.function;

import com.owon.uppersoft.dso.function.PFRuleManager;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.page.function.RulePage;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.vds.function.rule.AdditionComboBoxModel;
import com.owon.uppersoft.vds.function.rule.PFRuleControl;
import com.owon.uppersoft.vds.function.rule.RuleDetail;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CToggleButton;
import com.owon.uppersoft.vds.ui.widget.help.ToggleListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RulePane
extends FunctionPanel {
    private static final String MATH_ITEM = "Math";
    private PFRuleControl pfrc;
    private JSpinner horspin;
    private JSpinner verspin;
    private CComboBox chlccb;
    private WaveFormManager wfm = Platform.getDataHouse().getWaveFormManager();
    private PFRuleManager ruleManager;
    private CToggleButton rstbn;
    private CToggleButton abtbn;
    private ToggleListener able_al;
    private ToggleListener run_al;

    private void disableRule() {
        boolean bl = this.rstbn.isSelected();
        if (bl) {
            this.rstbn.setSelected(this.run_al.toggle(null, bl));
        }
        this.pfrc.disableRule();
        this.rstbn.setEnabled(false);
    }

    private void enableRule() {
        this.pfrc.enableRule();
        this.config_enable();
        this.rstbn.setEnabled(true);
    }

    public RulePane(final ControlManager controlManager) {
        super(controlManager);
        this.ruleManager = controlManager.ruleManager;
        this.pfrc = this.ruleManager.getPFRuleControl();
        this.ncgp();
        this.nrip();
        this.able_al = new ToggleListener(){

            @Override
            public boolean toggle(ActionEvent actionEvent, boolean bl) {
                if (!RulePane.this.checkConnect()) {
                    return bl;
                }
                boolean bl2 = RulePane.this.pfrc.isRuleEnable();
                if (bl2) {
                    RulePane.this.disableRule();
                } else {
                    RulePane.this.enableRule();
                }
                if (!controlManager.isRuntime()) {
                    Platform.getMainWindow().updateShow();
                }
                return !bl;
            }
        };
        this.run_al = new ToggleListener(){

            @Override
            public boolean toggle(ActionEvent actionEvent, boolean bl) {
                if (!RulePane.this.checkConnect()) {
                    return bl;
                }
                boolean bl2 = RulePane.this.ruleManager.isChecking();
                if (bl2) {
                    RulePane.this.ruleManager.stopCheck();
                } else {
                    RulePane.this.ruleManager.runCheck();
                }
                return !bl;
            }
        };
        this.abtbn = this.ntbtn("M.Rule.disable", "M.Rule.enable", this.able_al, 125, 28, this.pfrc.isRuleEnable());
        this.rstbn = this.ntbtn("M.Rule.stop", "M.Rule.run", this.run_al, 125, 28, this.ruleManager.isChecking());
        this.rstbn.setEnabled(this.pfrc.isRuleEnable());
        this.ncgp();
        this.createRulePart(controlManager);
        this.ncgp();
        this.nrip();
        final CComboBox cComboBox = this.nccb(RulePage.pf, 110, 28);
        cComboBox.setSelectedIndex(this.ruleManager.getOutputRule());
        cComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                int n = cComboBox.getSelectedIndex();
                RulePane.this.ruleManager.setOutputRule(n);
            }
        });
        final CCheckBox cCheckBox = this.ncb("M.Rule.msg");
        cCheckBox.setSelected(this.ruleManager.isShowMsg());
        cCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RulePane.this.ruleManager.setShowMsg(cCheckBox.isSelected());
                Platform.getMainWindow().re_paint();
            }
        });
        this.nrip();
        final CCheckBox cCheckBox2 = this.ncb("M.Rule.ring");
        cCheckBox2.setSelected(this.ruleManager.isRing());
        cCheckBox2.setPreferredSize(new Dimension(110, 28));
        cCheckBox2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RulePane.this.ruleManager.setRing(cCheckBox2.isSelected());
            }
        });
        final CCheckBox cCheckBox3 = this.ncb("M.Rule.stopOnce");
        cCheckBox3.setSelected(this.ruleManager.isStopOnOutput());
        cCheckBox3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RulePane.this.ruleManager.setStopOnOutput(cCheckBox3.isSelected());
            }
        });
        this.ncgp();
        this.nrip();
        this.nlbl("M.Rule.rule");
        this.nrip();
        CButton cButton = this.nbtn("M.Rule.save");
        CButton cButton2 = this.nbtn("M.Rule.use");
        CButton cButton3 = this.nbtn("M.Rule.remove");
        this.nrip();
        final CComboBox cComboBox2 = this.nccb();
        final AdditionComboBoxModel additionComboBoxModel = new AdditionComboBoxModel(this.ruleManager.getRuleList(), I18nProvider.bundle().getString("M.Rule.new"));
        cComboBox2.setModel(additionComboBoxModel);
        cComboBox2.setSelectedIndex(0);
        cComboBox2.setPreferredSize(new Dimension(250, 28));
        cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = RulePane.this.chlccb.getSelectedIndex();
                double d = (Double)RulePane.this.horspin.getValue();
                double d2 = (Double)RulePane.this.verspin.getValue();
                int n3 = cComboBox2.getSelectedIndex();
                if (n3 == (n = cComboBox2.getItemCount()) - 1) {
                    RuleDetail ruleDetail = new RuleDetail(n2, d, d2);
                    additionComboBoxModel.addElement(ruleDetail);
                    cComboBox2.setSelectedIndex(n3);
                    return;
                }
                RuleDetail ruleDetail = (RuleDetail)additionComboBoxModel.getElementAt(n3);
                ruleDetail.set(n2, d, d2);
                additionComboBoxModel.fireContentsChanged(additionComboBoxModel, 0, n);
            }
        });
        cButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = cComboBox2.getSelectedIndex();
                if (n2 == (n = cComboBox2.getItemCount()) - 1) {
                    return;
                }
                additionComboBoxModel.removeElementAt(n2);
                cComboBox2.setSelectedIndex(n2);
            }
        });
        cButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = cComboBox2.getSelectedIndex();
                if (n == cComboBox2.getItemCount() - 1) {
                    return;
                }
                RulePane.this.fillDetail((RuleDetail)additionComboBoxModel.getElementAt(n));
                RulePane.this.config_enable();
            }
        });
        this.localizeSelf();
    }

    private void fillDetail(RuleDetail ruleDetail) {
        this.chlccb.setSelectedIndex(ruleDetail.chl);
        this.horspin.setValue(ruleDetail.hor);
        this.verspin.setValue(ruleDetail.ver);
    }

    private void createRulePart(ControlManager controlManager) {
        this.nrip();
        if (controlManager.getAllChannelsNumber() == 1) {
            Object[] objectArray = controlManager.getCoreControl().getWaveFormInfos();
            this.chlccb = this.nccb(objectArray);
            this.chlccb.setEnabled(false);
        } else {
            Object[] objectArray = RulePane.getComposite_suffix(controlManager.getCoreControl().getWaveFormInfos(), MATH_ITEM);
            this.chlccb = this.nccb(objectArray);
        }
        this.chlccb.setSelectedIndex(this.pfrc.getRuleChannel());
        this.chlccb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                int n = RulePane.this.chlccb.getSelectedIndex();
                RulePane.this.checkChannelAvailable(n);
            }
        });
        CButton cButton = this.nbtn("M.Rule.create");
        this.nrip();
        this.nlbl("M.Rule.Hor");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.pfrc.getHor(), 0.0, 10.0, 0.02);
        this.horspin = new JSpinner(spinnerNumberModel);
        this.horspin.setPreferredSize(new Dimension(80, 28));
        this.ip.add(this.horspin);
        this.nnlbl("M.Rule.Div");
        this.nrip();
        this.nlbl("M.Rule.Ver");
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.pfrc.getVer(), 0.0, 5.0, 0.04);
        this.verspin = new JSpinner(spinnerNumberModel2);
        this.verspin.setPreferredSize(new Dimension(80, 28));
        this.ip.add(this.verspin);
        this.nnlbl("M.Rule.Div");
        cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulePane.this.config_enable();
            }
        });
    }

    private void config_enable() {
        int n = this.chlccb.getSelectedIndex();
        boolean bl = this.checkChannelAvailable(n);
        if (!bl) {
            return;
        }
        double d = (Double)this.horspin.getValue();
        double d2 = (Double)this.verspin.getValue();
        this.ruleManager.resetPFCounts();
        this.pfrc.configRule(n, d, d2);
    }

    private boolean checkChannelAvailable(int n) {
        boolean bl = true;
        if (this.chlccb.getModel().getElementAt(n).toString().equals(MATH_ITEM)) {
            if (!this.wfm.getCompositeWaveForm().isOn()) {
                bl = false;
            }
        } else if (!this.wfm.getWaveForm(n).isOn()) {
            bl = false;
        }
        if (!bl) {
            FadeIOShell fadeIOShell = new FadeIOShell();
            fadeIOShell.prompt(I18nProvider.bundle().getString("M.Rule.chlnotavlb"), Platform.getMainWindow().getFrame());
        }
        return bl;
    }

    private boolean checkConnect() {
        boolean bl = Platform.getDataHouse().controlManager.sourceManager.isConnected();
        if (!bl) {
            FadeIOShell fadeIOShell = new FadeIOShell();
            fadeIOShell.prompt(I18nProvider.bundle().getString("M.Rule.notconnect"), Platform.getMainWindow().getFrame());
        }
        return bl;
    }
}

