/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.function;

import com.owon.uppersoft.dso.function.ReferenceWaveControl;
import com.owon.uppersoft.dso.function.ref.ReferenceFile;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBoxList;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ReferenceWavePane
extends FunctionPanel {
    private MainWindow mw;
    private ReferenceWaveControl rwc;
    private WaveFormManager wfm;
    private List<ReferenceFile> refFiles;
    private CComboBox itemscb;
    private CButton colorbt;
    private JSpinner showspn;
    private CCheckBox infocb;
    private CComboBox sourceccb;
    private CButton savebtn;
    private CButton clearbtn;
    private CButton clearAllbtn;
    private CCheckBoxList itemscbl;
    private JTextField renamtxf;
    PlainDocument ipf = new PlainDocument(){

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = this.getText(0, this.getLength());
            String string3 = string2.substring(0, n) + string + string2.substring(n);
            boolean bl = true;
            if (string3.length() > 14) {
                bl = false;
                ResourceBundle resourceBundle = I18nProvider.bundle();
                FadeIOShell fadeIOShell = new FadeIOShell();
                fadeIOShell.prompt(resourceBundle.getString("M.ReferenceWave.Warn2") + 14 + " !", Platform.getMainWindow().getFrame());
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            }
        }
    };

    public ReferenceWavePane(ControlManager controlManager) {
        super(controlManager);
        this.mw = Platform.getMainWindow();
        this.rwc = controlManager.rwc;
        this.wfm = this.mw.getDataHouse().getWaveFormManager();
        this.ncgp();
        this.nrip();
        this.nnlbl("Action.To");
        this.itemscb = this.nccb();
        this.itemscb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = ReferenceWavePane.this.itemscb.getSelectedItem();
                if (object instanceof ReferenceFile) {
                    ReferenceFile referenceFile = (ReferenceFile)object;
                    ReferenceWavePane.this.renamtxf.setText(referenceFile.getName());
                } else {
                    ReferenceWavePane.this.renamtxf.setText("");
                }
            }
        });
        this.nrip();
        this.nlbl("M.Trg.Source");
        int n = controlManager.getAllChannelsNumber();
        this.sourceccb = n > 1 ? this.nccb(ReferenceWavePane.getComposite_suffix(controlManager.getCoreControl().getWaveFormInfos(), "Math")) : this.nccb(controlManager.getCoreControl().getWaveFormInfos());
        this.nrip();
        this.nlbl("M.ReferenceWave.Rename");
        this.renamtxf = this.ntf("");
        this.renamtxf.setPreferredSize(new Dimension(120, 30));
        this.renamtxf.setDocument(this.ipf);
        this.renamtxf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 10) {
                    return;
                }
                keyEvent.consume();
                ReferenceWavePane.this.renameReference(ReferenceWavePane.this.renamtxf.getText());
                ReferenceWavePane.this.mw.re_paint();
            }
        });
        this.nrip();
        this.savebtn = this.nbtn("Action.Save");
        this.clearbtn = this.nbtn("M.ReferenceWave.Remove");
        this.ncgp();
        this.nrip();
        this.nnlbl("M.ReferenceWave.Items");
        this.clearAllbtn = this.nbtn("M.ReferenceWave.RemoveAll");
        this.nrip();
        this.itemscbl = new CCheckBoxList();
        this.itemscbl.setBackground(Define.def.style.CO_DockContainer);
        this.itemscbl.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ReferenceWavePane.this.updateReferenceShow();
                ReferenceWavePane.this.mw.re_paint();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.itemscbl);
        jScrollPane.setPreferredSize(new Dimension(180, 150));
        jScrollPane.setBorder(new LineBorder(Color.GRAY, 1, true));
        this.ip.add(jScrollPane);
        this.nrip();
        this.colorbt = this.nbtco("Label.Color");
        this.colorbt.setBackground(this.rwc.color);
        this.nrip();
        this.nnlbl("M.ReferenceWave.ShowMax");
        this.showspn = new JSpinner(new SpinnerNumberModel(this.rwc.showCount, 0, 8, 1));
        this.showspn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((ReferenceWavePane)ReferenceWavePane.this).rwc.showCount = (Integer)ReferenceWavePane.this.showspn.getValue();
                ReferenceWavePane.this.mw.re_paint();
            }
        });
        this.ip.add(this.showspn);
        this.nrip();
        this.infocb = this.ncb("M.ReferenceWave.ShowInfo");
        this.infocb.setSelected(this.rwc.showInfo);
        this.infocb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ((ReferenceWavePane)ReferenceWavePane.this).rwc.showInfo = ReferenceWavePane.this.infocb.isSelected();
                ReferenceWavePane.this.mw.re_paint();
            }
        });
        this.sourceccb.setSelectedIndex(this.rwc.getSourceIdx());
        this.sourceccb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferenceWavePane.this.rwc.setSourceIdx(ReferenceWavePane.this.sourceccb.getSelectedIndex());
            }
        });
        this.colorbt.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((ReferenceWavePane)ReferenceWavePane.this).rwc.color = (Color)propertyChangeEvent.getNewValue();
                ReferenceWavePane.this.mw.re_paint();
            }
        });
        this.savebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferenceWavePane.this.saveReference();
                ReferenceWavePane.this.mw.re_paint();
            }
        });
        this.clearbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferenceWavePane.this.removeReference();
                ReferenceWavePane.this.mw.re_paint();
            }
        });
        this.clearAllbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferenceWavePane.this.rwc.removeAll();
                ReferenceWavePane.this.updateReferenceList();
                ReferenceWavePane.this.mw.re_paint();
            }
        });
        this.updateReferenceList();
        this.mw.re_paint();
        this.localizeSelf();
    }

    private void saveReference() {
        int n = this.sourceccb.getSelectedIndex();
        String string = this.renamtxf.getText();
        if (this.itemscb.getSelectedIndex() > 0) {
            ReferenceFile referenceFile = (ReferenceFile)this.itemscb.getSelectedItem();
            this.rwc.saveWave(referenceFile.id, n, string).setVisible(true);
            this.updateReferenceShow();
        } else {
            this.rwc.saveWave(n, string).setVisible(true);
            this.renamtxf.setText("");
            this.updateReferenceList();
        }
    }

    private void removeReference() {
        if (this.itemscb.getItemCount() <= 1) {
            return;
        }
        int n = Math.max(1, this.itemscb.getSelectedIndex());
        ReferenceFile referenceFile = (ReferenceFile)this.itemscb.getItemAt(n);
        this.rwc.removeReference(referenceFile);
        this.updateReferenceList();
    }

    private void renameReference(String string) {
        if (this.itemscb.getItemCount() <= 1) {
            return;
        }
        int n = Math.max(1, this.itemscb.getSelectedIndex());
        ReferenceFile referenceFile = (ReferenceFile)this.itemscb.getItemAt(n);
        referenceFile.setName(string);
        this.updateReferenceShow();
    }

    private void updateReferenceShow() {
        this.itemscb.updateUI();
        this.itemscbl.updateUI();
    }

    private void updateReferenceList() {
        this.itemscb.removeAllItems();
        this.itemscb.addItem("+               ");
        for (ReferenceFile referenceFile : ReferenceWavePane.reverse(this.rwc.getReferences())) {
            this.itemscb.addItem(referenceFile);
        }
        this.itemscbl.removeAll();
        for (ReferenceFile referenceFile : this.rwc.getReferences()) {
            this.itemscbl.add(new CCheckBoxRef(referenceFile));
        }
        this.updateReferenceShow();
    }

    private static ReferenceFile[] reverse(Collection<ReferenceFile> collection) {
        int n = collection.size();
        ReferenceFile[] referenceFileArray = new ReferenceFile[n];
        for (ReferenceFile referenceFile : collection) {
            referenceFileArray[--n] = referenceFile;
        }
        return referenceFileArray;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("CHOOSE_CHANNELS")) {
            int n = this.cm.getWaveFormInfoControl().getSelectedwfIdx();
            this.sourceccb.setSelectedIndex(n);
            return;
        }
        if (string.equals("ReferenceChanged")) {
            this.updateReferenceList();
            return;
        }
    }

    private static class CCheckBoxRef
    extends JCheckBox {
        private ReferenceFile rf;

        public CCheckBoxRef(final ReferenceFile referenceFile) {
            this.rf = referenceFile;
            this.setFont(FontCenter.getLabelFont());
            this.setForeground(Define.def.CO_DockFore);
            this.setModel(new JToggleButton.ToggleButtonModel(){

                @Override
                public boolean isSelected() {
                    return referenceFile.isVisible();
                }

                @Override
                public void setSelected(boolean bl) {
                    super.setSelected(bl);
                    referenceFile.setVisible(bl);
                }
            });
        }

        @Override
        public String getText() {
            return this.rf == null ? null : this.rf.toString();
        }

        public ReferenceFile getValue() {
            return this.rf;
        }
    }
}

