/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.function;

import com.owon.uppersoft.dso.function.PlayerControl;
import com.owon.uppersoft.dso.function.RecordControl;
import com.owon.uppersoft.dso.function.record.OpenPropertyChangeEvent;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.GroupPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.ItemPane;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import com.owon.uppersoft.vds.ui.widget.custom.HCLabel;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import com.owon.uppersoft.vds.util.FileUtil;
import com.owon.uppersoft.vds.util.MyFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RecordPane
extends FunctionPanel {
    private PlayerControl pc;
    private RecordControl rc;
    private CLabel cnt;
    private CLabel cnt1;
    private CLabel cnt2;
    private CButton rbtn;
    private CButton rbrw;
    private JSpinner rjs;
    private JSpinner mjs;
    private CButton pbtn;
    private JSpinner pjs;
    private JSlider timelineslider;
    private CCheckBox cycle;
    private JSpinner sta;
    private JSpinner end;
    private GroupPane fgp;
    private GroupPane rgp;
    private GroupPane pgp;
    private HCLabel rhcl;
    private HCLabel phcl;
    private ResourceBundle rb;
    private ControlManager cm;
    private FunctionPanel rp;
    private FunctionPanel fp;
    private File file;
    boolean listening = true;

    private void beforePlayLeave() {
        CByteArrayInputStream cByteArrayInputStream;
        boolean bl = this.pc.isPlaying();
        if (bl && (cByteArrayInputStream = this.pc.getCByteArrayInputStream()) != null) {
            this.pc.pausePlaying();
            this.updateComponents();
            cByteArrayInputStream.dispose();
        }
        this.pc.saveCurrent();
    }

    public RecordPane(ControlManager controlManager) {
        super(controlManager);
        this.cm = controlManager;
        this.fp = this;
        this.pc = controlManager.playCtrl;
        this.rc = controlManager.rc;
        this.rb = I18nProvider.bundle();
        this.createFilePane(controlManager);
        this.createRecordPane(controlManager);
        this.createPlayPane(controlManager);
        this.updateComponents();
        this.localizeSelf();
        this.pc.loadAsync();
    }

    private FunctionPanel createRecordPane(ControlManager controlManager) {
        this.rgp = this.fp.ncgp();
        this.fp.nrip();
        this.rbtn = this.fp.nbtnt("");
        this.rbtn.setPreferredSize(new Dimension(135, 30));
        this.rc.setPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equalsIgnoreCase("RecordFrameIndex")) {
                    OpenPropertyChangeEvent openPropertyChangeEvent = (OpenPropertyChangeEvent)propertyChangeEvent;
                    int n = openPropertyChangeEvent.newInt;
                    if (n >= 0) {
                        RecordPane.this.cnt1.setText(String.valueOf(n));
                    } else {
                        RecordPane.this.updateComponents();
                        RecordPane.this.cnt1.setText("");
                        RecordPane.this.pc.loadAsync();
                    }
                }
            }
        });
        this.fp.nlbl("M.Record.Frame");
        this.cnt1 = this.fp.nlblt("");
        ItemPane itemPane = this.fp.nrip();
        this.fp.nlbl("Action.TimeGap");
        int n = this.rc.intervalTime;
        this.rjs = new JSpinner(new SpinnerNumberModel(n, 0, 100000, 10));
        this.rjs.setPreferredSize(new Dimension(80, 30));
        itemPane.add(this.rjs);
        this.rjs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((RecordPane)RecordPane.this).rc.intervalTime = (Integer)RecordPane.this.rjs.getValue();
            }
        });
        CLabel cLabel = new CLabel();
        cLabel.setText("ms");
        itemPane.add(cLabel);
        ItemPane itemPane2 = this.fp.nrip();
        this.fp.nlbl("Action.RecordEndFrame");
        int n2 = this.rc.endFrame;
        this.mjs = new JSpinner(new SpinnerNumberModel(n2, 1, 100000, 1));
        this.mjs.setPreferredSize(new Dimension(80, 30));
        itemPane2.add(this.mjs);
        this.mjs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((RecordPane)RecordPane.this).rc.endFrame = (Integer)RecordPane.this.mjs.getValue();
            }
        });
        this.rbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordPane.this.rc.setTimegap((Integer)RecordPane.this.rjs.getValue());
                int n = (Integer)RecordPane.this.mjs.getValue();
                RecordPane.this.rc.setMaxframe(n);
                RecordPane.this.cnt2.setText("");
                boolean bl = RecordPane.this.rc.switchRecording(new Runnable(){

                    @Override
                    public void run() {
                        String string = I18nProvider.bundle().getString("M.Record.PathInvalid");
                        String string2 = I18nProvider.bundle().getString("M.Record.Name");
                        int n = JOptionPane.showConfirmDialog(WindowUtil.getWindow(RecordPane.this), string, string2, 0, 0);
                        if (n == 0) {
                            RecordPane.this.browseforSaveas();
                        }
                    }
                });
                if (bl) {
                    RecordPane.this.updateComponents();
                }
            }
        });
        return this.fp;
    }

    public void browseforSaveas() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.rbrw.getText());
        jFileChooser.setPreferredSize(new Dimension(500, 500));
        jFileChooser.addChoosableFileFilter(MyFileFilter.CAPFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setCurrentDirectory(new File(this.rc.getFilePath()).getParentFile());
        JFrame jFrame = Platform.getMainWindow().getFrame();
        int n = jFileChooser.showDialog(jFrame, this.rb.getString("Option.OK"));
        if (n == 0) {
            File file = FileUtil.checkFileSuffix(jFileChooser, MyFileFilter.CAPFilter.getEnds());
            this.rc.setPath(file);
            this.pc.setPath(file, true);
            this.rhcl.setText(this.rc.getFilePath());
            this.updateComponents();
            this.pc.loadAsync();
        }
    }

    private FunctionPanel createPlayPane(final ControlManager controlManager) {
        this.pc.setPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                OpenPropertyChangeEvent openPropertyChangeEvent;
                String string = propertyChangeEvent.getPropertyName();
                if (string.equalsIgnoreCase("PlayProgress")) {
                    openPropertyChangeEvent = (OpenPropertyChangeEvent)propertyChangeEvent;
                    n = openPropertyChangeEvent.newInt;
                    if (n >= 0) {
                        RecordPane.this.listening = false;
                        RecordPane.this.timelineslider.setValue(n);
                        RecordPane.this.cnt2.setText(String.valueOf(n));
                        RecordPane.this.listening = true;
                        RecordPane.this.pc.updateCurrentScreen();
                    } else {
                        RecordPane.this.updateComponents();
                    }
                }
                if (string.equalsIgnoreCase("ReadHeader")) {
                    openPropertyChangeEvent = (OpenPropertyChangeEvent)propertyChangeEvent;
                    n = openPropertyChangeEvent.newInt;
                    RecordPane.this.sta.setValue(1);
                    RecordPane.this.cnt.setText(String.valueOf(n));
                    RecordPane.this.cnt2.setText("");
                    RecordPane.this.end.setValue(n);
                    RecordPane.this.listening = false;
                    RecordPane.this.timelineslider.setMinimum(1);
                    RecordPane.this.timelineslider.setMaximum(n);
                    RecordPane.this.timelineslider.setValue(n);
                    RecordPane.this.listening = true;
                    RecordPane.this.pc.setTimegap((Integer)RecordPane.this.pjs.getValue());
                    RecordPane.this.pc.setStartEndFrame((Integer)RecordPane.this.sta.getValue(), (Integer)RecordPane.this.end.getValue());
                    RecordPane.this.loadPauseStatus();
                    RecordPane.this.updateComponents();
                }
            }
        });
        this.pgp = this.fp.ncgp();
        this.fp.nrip();
        this.pbtn = this.fp.nbtnt("");
        this.pbtn.setPreferredSize(new Dimension(135, 30));
        this.fp.nlbl("M.Record.Frame");
        this.cnt2 = this.fp.nlblt("");
        this.ip = this.fp.nrip();
        this.timelineslider = new JSlider();
        this.timelineslider.setPreferredSize(new Dimension(250, 25));
        this.ip.add(this.timelineslider);
        this.timelineslider.addMouseListener(new MouseAdapter(){
            boolean foreplaying;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (RecordPane.this.pc.fileInvalid()) {
                    return;
                }
                if (!RecordPane.this.timelineslider.isEnabled()) {
                    return;
                }
                if (controlManager.isRuntime()) {
                    RecordPane.this.pc.confirmStopRunningforPlaying();
                }
                if (RecordPane.this.pc.isPlaying()) {
                    RecordPane.this.pc.pausePlaying();
                    RecordPane.this.updateComponents();
                }
                int n = RecordPane.this.timelineslider.getValue();
                RecordPane.this.cnt2.setText(String.valueOf(n));
                RecordPane.this.pc.setCurrentNStreamPointer(n - 1);
                RecordPane.this.pc.updateCurrentScreen();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.timelineslider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!RecordPane.this.listening) {
                    return;
                }
                if (RecordPane.this.pc.fileInvalid()) {
                    return;
                }
                int n = RecordPane.this.timelineslider.getValue();
                RecordPane.this.cnt2.setText(String.valueOf(n));
                if (n < 1 || n > ((RecordPane)RecordPane.this).pc.counter) {
                    return;
                }
                RecordPane.this.pc.setCurrentNStreamPointer(n - 1);
                if (!controlManager.isRuntime()) {
                    RecordPane.this.pc.updateCurrentScreen();
                }
            }
        });
        ItemPane itemPane = this.fp.nrip();
        this.fp.nlbl("Action.TimeGap");
        this.pjs = new JSpinner(new SpinnerNumberModel(200, 0, 100000, 10));
        this.pjs.setPreferredSize(new Dimension(80, 30));
        itemPane.add(this.pjs);
        this.pjs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RecordPane.this.pc.setTimegap((Integer)RecordPane.this.pjs.getValue());
            }
        });
        CLabel cLabel = new CLabel();
        cLabel.setText("ms");
        itemPane.add(cLabel);
        this.pbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = controlManager.isRuntime();
                if (bl2 && !(bl = RecordPane.this.pc.confirmStopRunningforPlaying())) {
                    return;
                }
                if (RecordPane.this.pc.fileInvalid()) {
                    RecordPane.this.phcl.setText(RecordPane.this.rb.getString("M.Record.LoadInvalid") + "\n" + RecordPane.this.pc.getFilePath());
                    RecordPane.this.pc.promptInvalidLoad();
                    return;
                }
                RecordPane.this.pc.switchPlaying();
                RecordPane.this.updateComponents();
            }
        });
        itemPane = this.fp.nrip();
        this.fp.nlbl("M.Record.Start");
        this.sta = new JSpinner(new SpinnerNumberModel(1, 1, 10000, 1));
        this.sta.setPreferredSize(new Dimension(60, 30));
        itemPane.add(this.sta);
        this.sta.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RecordPane.this.pc.setStartEndFrame((Integer)RecordPane.this.sta.getValue(), (Integer)RecordPane.this.end.getValue());
            }
        });
        this.fp.nlbl("M.Record.End");
        this.end = new JSpinner(new SpinnerNumberModel(30, 1, 10000, 1));
        this.end.setPreferredSize(new Dimension(60, 30));
        itemPane.add(this.end);
        this.end.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RecordPane.this.pc.setStartEndFrame((Integer)RecordPane.this.sta.getValue(), (Integer)RecordPane.this.end.getValue());
            }
        });
        this.fp.nrip();
        this.cycle = this.fp.ncb("M.Record.Cycle");
        this.cycle.setSelected(this.pc.cyc);
        this.cycle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((RecordPane)RecordPane.this).pc.cyc = RecordPane.this.cycle.isSelected();
            }
        });
        return this.fp;
    }

    private void createFilePane(ControlManager controlManager) {
        this.fgp = this.fp.ncgp();
        this.fp.nrip();
        this.rbrw = this.fp.nbtn("Action.Use");
        this.fp.nlbl("Action.FrameCount");
        this.cnt = this.fp.nlblt(String.valueOf(this.rc.getCounter()));
        this.fp.nrip();
        this.rhcl = this.fp.nlbldt(this.rc.getFilePath());
        this.rhcl.setOpaque(false);
        this.rhcl.setEditable(false);
        this.phcl = this.rhcl;
        this.rbrw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordPane.this.browseforSaveas();
            }
        });
    }

    private void loadPauseStatus() {
        this.pc.loadSavedCurrent();
        this.cnt2.setText("");
        this.listening = false;
        this.timelineslider.setValue(this.pc.getSavedCurrent() + 1);
        this.listening = true;
    }

    private void updateComponents() {
        boolean bl = this.rc.isRecording();
        boolean bl2 = this.pc.isPlaying();
        boolean bl3 = !bl2 && !bl;
        RecordPane.setEnabledRecursive(this.fgp, bl3);
        this.rhcl.setEnabled(true);
        this.rhcl.setForeground(bl3 ? Color.WHITE : Color.GRAY);
        String string = bl ? "Action.EndRecord" : "Action.BeginRecord";
        bl3 = !bl2;
        RecordPane.setEnabledRecursive(this.rgp, bl3);
        this.rbtn.setText(this.rb.getString(string));
        if (bl3 && bl) {
            this.rjs.setEnabled(false);
            this.mjs.setEnabled(false);
        }
        string = bl2 ? "Action.Pause" : "Action.Play";
        bl3 = !bl && !this.pc.fileInvalid();
        RecordPane.setEnabledRecursive(this.pgp, bl3);
        this.pbtn.setText(this.rb.getString(string));
        if (bl3 && bl2) {
            this.pjs.setEnabled(false);
            this.sta.setEnabled(false);
            this.end.setEnabled(false);
        }
        if (bl || this.pc.fileInvalid()) {
            this.cnt.setText("");
            this.cnt2.setText("");
        }
    }

    private static void setEnabledRecursive(Component component, Boolean bl) {
        if (component instanceof JPanel) {
            JPanel jPanel = (JPanel)component;
            int n = jPanel.getComponentCount();
            while (--n >= 0) {
                RecordPane.setEnabledRecursive(jPanel.getComponent(n), bl);
            }
        } else {
            component.setEnabled(bl);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equalsIgnoreCase("Keepget")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        }
    }

    @Override
    public void beforeLeave() {
        this.beforePlayLeave();
    }

    public boolean canLeave() {
        return true;
    }
}

