/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.function;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.mode.control.SysControl;
import com.owon.uppersoft.dso.page.function.MachineSettingPage;
import com.owon.uppersoft.dso.source.comm.AbsInterCommunicator;
import com.owon.uppersoft.dso.source.manager.SourceManager;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.vds.ui.widget.IPPane;
import com.owon.uppersoft.vds.ui.widget.custom.NLabel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class MachineSettingPane
extends FunctionPanel {
    private MachineSettingPage msp;
    private SysControl sc;
    private JTextField ptf;
    private JTextField mactf;
    private IPPane iptfs;
    private IPPane smtfs;
    private IPPane gwtfs;
    private NLabel macdiplaylbl;

    public MachineSettingPane(ControlManager controlManager, MachineSettingPage machineSettingPage) {
        super(controlManager);
        this.msp = machineSettingPage;
        this.sc = controlManager.getSysControl();
        this.ncgp();
        this.nrip();
        this.iptfs = this.nip4net("M.Utility.MachineNet.IP", this.sc.ipaddress);
        this.nrip();
        this.smtfs = this.nip4net("M.Utility.MachineNet.SM", this.sc.smaddress);
        this.nrip();
        this.gwtfs = this.nip4net("M.Utility.MachineNet.GW", this.sc.gwaddress);
        this.nrip();
        this.nlbl("M.Utility.MachineNet.Port").setPreferredSize(new Dimension(79, 0));
        this.ptf = this.ntf(String.valueOf(this.sc.port));
        this.ptf.setPreferredSize(new Dimension(60, 30));
        this.nlblt("(0~65535)");
        this.nrip();
        this.nlbl("M.Utility.MachineSetting.Mac").setPreferredSize(new Dimension(80, 0));
        this.mactf = this.ntf(this.sc.getMac());
        this.mactf.setPreferredSize(new Dimension(110, 30));
        this.mactf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                MachineSettingPane.this.sc.isMacvalid(MachineSettingPane.this.mactf.getText());
            }
        });
        this.nrip().setLayout(new FlowLayout(2));
        this.nbtn("M.Utility.MachineNet.Rework").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        MachineSettingPane.this.showTips();
                        AbsInterCommunicator absInterCommunicator = Platform.getControlApps().interComm;
                        MachineSettingPane.this.okAction();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        absInterCommunicator.rebootMachine();
                        Platform.getControlApps().releaseConnect();
                    }
                }.start();
            }
        });
        this.localizeSelf();
        this.updateMacDisplay();
    }

    protected void saveSetting() {
        this.iptfs.saveIP2Array(this.sc.ipaddress);
        this.smtfs.saveIP2Array(this.sc.smaddress);
        this.gwtfs.saveIP2Array(this.sc.gwaddress);
        int n = 0;
        try {
            n = Integer.parseInt(this.ptf.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sc.port = n;
        this.sc.saveMac(this.mactf.getText());
    }

    @Override
    public void beforeLeave() {
        this.saveSetting();
    }

    private void okAction() {
        this.saveSetting();
        this.cm.getSysControl().c_network();
        DBG.outprintln("OK");
    }

    private void showTips() {
        SourceManager sourceManager = Platform.getControlManager().sourceManager;
        String string = sourceManager.isNETConnect() ? I18nProvider.bundle().getString("M.Utility.MachineNet.ReworkNetTips") : I18nProvider.bundle().getString("M.Utility.MachineNet.ReworkUsbTips");
        JOptionPane.showMessageDialog(Platform.getMainWindow().getFrame(), string);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("updateMacDisplay")) {
            this.mactf.setText(this.sc.getMac());
        }
    }

    public void updateMacDisplay() {
        AbsInterCommunicator absInterCommunicator = Platform.getControlApps().interComm;
        absInterCommunicator.queryALL();
    }
}

