/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.function;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.mode.control.SysControl;
import com.owon.uppersoft.dso.page.function.MachineNetPage;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.source.comm.AbsInterCommunicator;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.dso.view.pane.dock.ContentPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.ItemPane;
import com.owon.uppersoft.vds.ui.widget.IPPane;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MachineNetPane
extends FunctionPanel {
    private IPPane iptfs;
    private JTextField ptf;
    private SysControl sc;

    public MachineNetPane(ControlManager controlManager, final ContentPane contentPane, final MachineNetPage machineNetPage) {
        super(controlManager);
        int n = 40;
        this.ncgp();
        this.nrip();
        this.nlbl("M.Utility.MachineNet.TipsTitle");
        ItemPane itemPane = this.nrip();
        String string = I18nProvider.bundle().getString("M.Utility.MachineNet.Tips");
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setBackground(Define.def.style.CO_DockContainer);
        jTextArea.setForeground(Color.WHITE);
        jTextArea.setFont(Define.def.alphafont);
        jTextArea.setPreferredSize(new Dimension(Define.def.DockFrameWidth, n));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setHighlighter(null);
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        itemPane.add(jTextArea);
        this.nrip().setLayout(new FlowLayout(2));
        CButton cButton = this.nbtn("Action.OK");
        cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                contentPane.applyContent(machineNetPage.getContentID(), "M.Utility.MachineSetting", 1);
            }
        });
        this.sc = controlManager.getSysControl();
        this.ncgp();
        this.nrip();
        this.nlbl("Action.Connect");
        this.nrip();
        this.iptfs = this.nip4net("M.Utility.MachineNet.IP", this.sc.link_ip_address);
        this.nrip();
        this.nlbl("M.Utility.MachineNet.Port").setPreferredSize(new Dimension(79, 0));
        this.ptf = this.ntf(String.valueOf(this.sc.link_port));
        this.ptf.setPreferredSize(new Dimension(60, 30));
        this.nrip();
        final CButton cButton2 = this.nbtn("Action.Connect");
        cButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MachineNetPane.this.saveLink();
                MachineNetPane.this.link(((MachineNetPane)MachineNetPane.this).sc.link_ip_address, ((MachineNetPane)MachineNetPane.this).sc.link_port);
                cButton2.setEnabled(false);
            }
        });
        CButton cButton3 = this.nbtn("Action.Disconnect");
        cButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MachineNetPane.this.dislink();
                cButton2.setEnabled(true);
            }
        });
        this.nrip();
        this.nlbld("M.Utility.MachineNet.PowerTips").setPreferredSize(new Dimension(Define.def.DockFrameWidth, 110));
        this.localizeSelf();
    }

    @Override
    public void beforeLeave() {
        this.saveLink();
    }

    private void saveLink() {
        this.iptfs.saveIP2Array(this.sc.link_ip_address);
        int n = 0;
        try {
            n = Integer.parseInt(this.ptf.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sc.link_port = n;
    }

    private void link(final byte[] byArray, final int n) {
        final AbsInterCommunicator absInterCommunicator = Platform.getControlApps().interComm;
        new Thread(){

            @Override
            public void run() {
                ((MachineNetPane)MachineNetPane.this).cm.sourceManager.connectNet(byArray, n);
                absInterCommunicator.initMachine(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        DBG.outprintln(propertyChangeEvent.getPropertyName() + ": " + propertyChangeEvent.getNewValue());
                    }
                });
            }
        }.start();
    }

    private void dislink() {
        Platform.getControlApps().releaseConnect();
    }
}

