/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.function;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.page.IContentPage;
import com.owon.uppersoft.dso.page.function.HomePage;
import com.owon.uppersoft.dso.page.function.PageManager;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.pane.dock.ContentPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.HomePageListCellRenderer;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.util.ui.CListModel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class HomePane
extends FunctionPanel {
    private HomePage hp;
    private PageManager pm;
    private ContentPane cp;

    public HomePane(HomePage homePage, ContentPane contentPane, ControlManager controlManager) {
        super(controlManager);
        this.cp = contentPane;
        this.hp = homePage;
        this.pm = contentPane.getPageManager();
        this.setLayout(new OneColumnLayout(new Insets(8, 8, 8, 8), 8));
        this.setBackground(Define.def.style.CO_DockHomeBack);
        this.pm.createLists(this);
    }

    public void createList(CListModel cListModel) {
        JList jList = new JList(cListModel);
        jList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                IContentPage iContentPage = (IContentPage)object;
                String string = iContentPage.getContentID();
                String string2 = I18nProvider.bundle().getString(string);
                int n2 = 2;
                if (jList.getModel().getSize() - 1 == n) {
                    n2 = 3;
                } else if (n == 0) {
                    n2 = 1;
                }
                HomePane.this.cp.setIconButtonId(string);
                Icon icon = HomePane.this.pm.getIcon(string);
                return new HomePageListCellRenderer(n2, string2, bl2, icon);
            }
        });
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                HomePane.this.cp.applyContent(HomePane.this.hp.getContentID(), ((IContentPage)jList.getModel().getElementAt(n)).getContentID(), 1);
            }
        });
        this.add(jList);
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        super.localize(resourceBundle);
        this.repaint();
    }
}

