/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.dock.widget;

import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.page.IContentPage;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.pane.dock.ContentPane;
import com.owon.uppersoft.dso.view.pane.dock.DockDialog;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.widget.custom.LButton;
import com.owon.uppersoft.vds.ui.widget.help.ComponentChaser;
import com.owon.uppersoft.vds.ui.window.ComponentMover;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TitleBar
extends JPanel
implements Localizable {
    public static final int H = 40;
    public static final int BackW = 42;
    public static final int XAlign = 3;
    public static final int RoundOffset = 10;
    public static final int W = 272;
    public static final Color CO_MainContainer = Color.DARK_GRAY;
    public static final int rw = 10;
    public static final int rh = 10;
    public static final GradientPaint GradientTexturePaint = new GradientPaint(0.0f, 0.0f, Define.def.style.CO_TitleBarTop, 0.0f, 40.0f, Define.def.style.CO_TitleBarBottom, false);
    public static final String BackPath = "/com/owon/uppersoft/dso/image/back.png";
    public static final String MinimizePath = "/com/owon/uppersoft/dso/image/minimize.png";
    private IContentPage current;
    private IContentPage back;
    private JButton backBtn;
    private LButton miniBtn;
    private String tlbl;

    public TitleBar(final ContentPane contentPane) {
        this.setPreferredSize(new Dimension(272, 35));
        this.setLayout(null);
        this.backBtn = new JButton();
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TitleBar.this.goBack(contentPane);
            }
        });
        this.add(this.backBtn);
        ImageIcon imageIcon = SwingResourceManager.getIcon(TitleBar.class, BackPath);
        this.backBtn.setIcon(imageIcon);
        this.backBtn.setBounds(3, 3, 42, 30);
        this.miniBtn = new LButton();
        this.miniBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                contentPane.minimize();
            }
        });
        this.add(this.miniBtn);
        imageIcon = SwingResourceManager.getIcon(TitleBar.class, MinimizePath);
        this.miniBtn.setIcon(imageIcon);
        this.miniBtn.setPressedIcon(LineDrawTool.getRolloverIcon(imageIcon));
        this.miniBtn.setBounds(272, 3, 42, 30);
        this.setFont(FontCenter.getBigtitlefont());
        DockDialog dockDialog = contentPane.getDockDialog();
        new ComponentMover(dockDialog.getDialog(), this);
        new ComponentChaser(dockDialog.getJFrame(), dockDialog.getDialog(), this, new Runnable(){

            @Override
            public void run() {
                contentPane.minimize();
            }
        });
    }

    public void goBack(ContentPane contentPane) {
        contentPane.applyContent(this.current.getContentID(), this.back.getContentID(), -1);
    }

    public void load(IContentPage iContentPage, IContentPage iContentPage2) {
        this.current = iContentPage;
        this.back = iContentPage2;
        this.backBtn.setVisible(iContentPage2 != null);
        this.tlbl = I18nProvider.bundle().getString(iContentPage.getContentID());
    }

    public String getCurrentName() {
        return this.tlbl;
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.tlbl = resourceBundle.getString(this.current.getContentID());
        Font font = FontCenter.getBigtitlefont();
        this.setFont(font);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setPaint(GradientTexturePaint);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fillRoundRect(0, 0, n, n2 + 15, 15, 15);
        graphics2D.setStroke(Define.def.Stroke2);
        graphics2D.setColor(Color.WHITE);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.tlbl, graphics2D);
        int n3 = n - (int)rectangle2D.getWidth() >> 1;
        n3 = Math.max(n3, 45);
        int n4 = (n2 - (int)rectangle2D.getHeight() >> 1) + graphics2D.getFontMetrics().getAscent();
        graphics2D.drawString(this.tlbl, n3, n4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }
}

