/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.dock;

import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.page.IContentPage;
import com.owon.uppersoft.dso.page.function.PageManager;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.pane.dock.ContentPane;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import com.owon.uppersoft.vds.ui.widget.custom.ICLButton;
import com.owon.uppersoft.vds.util.ui.CListModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class IconBar
extends JPanel
implements Localizable {
    private PageManager pm;
    private ContentPane cp;
    private ICLButton[] b;
    private int buttonSize;
    private String[] s;

    public IconBar(ContentPane contentPane) {
        this.setLayout(new OneColumnLayout(new Insets(8, 0, 8, 0), 0));
        this.setPreferredSize(new Dimension(41, 0));
        this.setBackground(Define.def.style.CO_DockHomeCellBack);
        this.cp = contentPane;
        this.pm = contentPane.getPageManager();
        this.buttonSize = 0;
        this.pm.createLists(this);
    }

    public void createList(CListModel cListModel) {
        this.buttonSize = cListModel.getSize();
        this.b = new ICLButton[this.buttonSize];
        this.s = new String[this.buttonSize];
        for (int i = 0; i < this.buttonSize; ++i) {
            final IContentPage iContentPage = (IContentPage)cListModel.getElementAt(i);
            this.s[i] = iContentPage.getContentID();
            Icon icon = this.pm.getIcon(this.s[i]);
            this.b[i] = new ICLButton();
            this.b[i].setPreferredSize(new Dimension(0, 33));
            this.b[i].setIcon(icon);
            this.b[i].setRolloverIcon(LineDrawTool.getRolloverIcon((ImageIcon)icon));
            this.b[i].setId(this.s[i]);
            this.b[i].setBackgroundColor(Color.gray);
            this.b[i].setBorderColor(Color.gray);
            if (this.cp.getIconButtonId() == this.s[i]) {
                this.b[i].setNotEnabledColor(Define.def.style.CO_DockHomeBack);
                this.b[i].setDisabledIcon(icon);
                this.b[i].setNotEnabled();
            }
            this.b[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IconBar.this.cp.applyContent("M.Home.Name", iContentPage.getContentID(), 1);
                }
            });
            this.add(this.b[i]);
        }
        this.localize(I18nProvider.bundle());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRoundRect(0, -15, n + 15, n2 + 15, 15, 15);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.buttonSize; ++i) {
            stringBuffer.setLength(0);
            stringBuffer.append("<html><span style=font-family:" + FontCenter.getLabelFont().getFamily() + ";font-size:11px;font-weight:bold;>" + resourceBundle.getString(this.s[i]) + "</span></html>");
            this.b[i].setToolTipText(stringBuffer.toString());
        }
    }
}

