/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.dock;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.page.function.PageManager;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.pane.dock.ContentPane;
import com.owon.uppersoft.vds.ui.window.MaxMinAnimator;
import com.owon.uppersoft.vds.ui.window.WindowChaser;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JWindow;

public class DockDialog
implements PropertyChangeListener {
    private JWindow dlg;
    private Window wnd;
    private PropertyChangeSupport host;
    private JComponent jc;
    private ControlManager cm;
    private PageManager pm;
    private MaxMinAnimator mu = new MaxMinAnimator();
    private ContentPane cp;

    public Window getJFrame() {
        return this.wnd;
    }

    public DockDialog(Window window, ControlManager controlManager, PropertyChangeSupport propertyChangeSupport, JComponent jComponent, PageManager pageManager) {
        this.wnd = window;
        this.cm = controlManager;
        this.jc = jComponent;
        this.pm = pageManager;
        this.host = propertyChangeSupport;
        if (this.host != null) {
            this.host.addPropertyChangeListener(this);
        }
    }

    public void dockDlgSetVisible(boolean bl) {
        Point point = this.jc.getLocationOnScreen();
        this.setVisible(new Rectangle(point.x, point.y, this.jc.getWidth(), 80), bl);
    }

    protected void onClosing() {
        if (this.host != null) {
            this.host.removePropertyChangeListener(this);
        }
    }

    public JWindow getDialog() {
        return this.dlg;
    }

    public void close() {
        if (this.dlg != null) {
            this.dlg.dispose();
        }
    }

    public void setVisible(Rectangle rectangle, boolean bl) {
        if (this.dlg == null) {
            this.init();
        }
        this.dlg.setVisible(bl);
    }

    public boolean isVisible() {
        if (this.dlg == null) {
            return false;
        }
        return this.dlg.isVisible();
    }

    public ContentPane getContentPane() {
        if (this.dlg == null) {
            this.init();
        }
        return this.cp;
    }

    private void init() {
        this.dlg = new JWindow(this.wnd){

            @Override
            public String getName() {
                return DockDialog.this.cp.getCurrentName();
            }

            @Override
            public void dispose() {
                this.setVisible(false);
            }
        };
        this.dlg.setType(Window.Type.UTILITY);
        this.dlg.setBackground(Define.def.style.CO_DockBack);
        this.cp = new ContentPane(this, this.cm, this.pm);
        this.dlg.setContentPane(this.cp);
        this.dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DockDialog.this.onClosing();
                DockDialog.this.dlg = null;
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DockDialog.this.cp.beforeLeave();
            }
        });
        Point point = this.wnd.getLocation();
        this.dlg.setBounds(point.x + 1000 - 265 - 41, point.y + 47, 321, 500);
        this.wnd.addComponentListener(new WindowChaser(this.wnd, this.dlg));
        WindowUtil.cutCorners(this.dlg, 15);
        WindowUtil.disableTraversFocus(this.dlg);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.cp != null) {
            this.cp.apply2LContainer(propertyChangeEvent);
        }
        if (this.dlg != null && propertyChangeEvent.getPropertyName().equals("dock_repaint")) {
            this.dlg.repaint();
        }
    }
}

