/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane.dock;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.page.IContentPage;
import com.owon.uppersoft.dso.page.function.PageManager;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.pane.dock.BottomBar;
import com.owon.uppersoft.dso.view.pane.dock.DockDialog;
import com.owon.uppersoft.dso.view.pane.dock.SwitchPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.TitleLContainer;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.ui.widget.custom.ICLButton;
import com.owon.uppersoft.vds.ui.widget.custom.LContainer;
import com.owon.uppersoft.vds.util.LocalizeCenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ContentPane
extends JPanel
implements Localizable {
    private static final long serialVersionUID = 879817008906914669L;
    private SwitchPane switchPane;
    private ControlManager controlManager;
    private BottomBar bb;
    private DockDialog dock;
    private String iconButtonId;
    private PageManager pm;
    private TitleLContainer[] tlcs;
    private TitleLContainer curtlc;
    private LContainer currentLC;
    private IContentPage currentPage;

    public DockDialog getDockDialog() {
        return this.dock;
    }

    public ContentPane(DockDialog dockDialog, ControlManager controlManager, PageManager pageManager) {
        this.dock = dockDialog;
        this.controlManager = controlManager;
        this.iconButtonId = ICLButton.INIT_ID;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.switchPane = new SwitchPane();
        this.add((Component)this.switchPane, "Center");
        this.pm = pageManager;
        LocalizeCenter localizeCenter = this.controlManager.getLocalizeCenter();
        localizeCenter.addLocalizable(this);
    }

    public BottomBar getBottomBar() {
        return this.bb;
    }

    public void minimize() {
        this.dock.dockDlgSetVisible(false);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Define.def.CO_DockBorder);
        graphics2D.setStroke(Define.def.Stroke3);
        graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, 15, 15);
    }

    public SwitchPane getSwitchPane() {
        return this.switchPane;
    }

    public PageManager getPageManager() {
        return this.pm;
    }

    public ControlManager getControlManager() {
        return this.controlManager;
    }

    public void setIconButtonId(String string) {
        this.iconButtonId = string;
    }

    public String getIconButtonId() {
        return this.iconButtonId;
    }

    protected TitleLContainer getAvalableTitleLContainer() {
        if (this.tlcs == null) {
            this.tlcs = new TitleLContainer[2];
            this.tlcs[0] = new TitleLContainer(this);
            this.tlcs[1] = new TitleLContainer(this);
            this.curtlc = null;
        }
        if (this.curtlc == this.tlcs[0]) {
            this.curtlc = this.tlcs[1];
            return this.curtlc;
        }
        this.curtlc = this.tlcs[0];
        return this.curtlc;
    }

    public LContainer createContainerWithBackWard(FunctionPanel functionPanel, IContentPage iContentPage, IContentPage iContentPage2) {
        TitleLContainer titleLContainer = this.getAvalableTitleLContainer();
        titleLContainer.load(iContentPage, iContentPage2, functionPanel);
        return titleLContainer;
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        if (this.currentLC != null) {
            this.currentLC.localize(resourceBundle);
        }
    }

    public String getCurrentName() {
        return ((TitleLContainer)this.currentLC).getTitleBar().getCurrentName();
    }

    public IContentPage getCurrentPage() {
        return this.currentPage;
    }

    public void apply2LContainer(PropertyChangeEvent propertyChangeEvent) {
        if (this.currentLC == null) {
            return;
        }
        TitleLContainer titleLContainer = (TitleLContainer)this.currentLC;
        titleLContainer.getSub().propertyChange(propertyChangeEvent);
    }

    public void beforeLeave() {
        if (this.currentLC == null) {
            return;
        }
        TitleLContainer titleLContainer = (TitleLContainer)this.currentLC;
        titleLContainer.getSub().beforeLeave();
    }

    public boolean isCurrentPage(String string) {
        return this.currentPage != null && string.equals(this.currentPage.getContentID());
    }

    public void applyDestPane(String string) {
        if (this.dock == null) {
            return;
        }
        if (this.isCurrentPage(string)) {
            return;
        }
        this.applyContent("M.Home.Name", string, 1, false);
    }

    public void applyContent(String string, String string2, int n) {
        this.applyContent(string, string2, n, true);
    }

    public void applyContent(String string, String string2, int n, boolean bl) {
        IContentPage iContentPage = this.pm.getContentPage(string);
        IContentPage iContentPage2 = this.pm.getContentPage(string2);
        this.applyContent(iContentPage, iContentPage2, n, bl);
    }

    public void applyContent(IContentPage iContentPage, IContentPage iContentPage2, int n, boolean bl) {
        if (iContentPage2 == null) {
            return;
        }
        if (this.currentPage != null) {
            if (!this.currentPage.canLeave()) {
                return;
            }
            this.currentPage.beforeLeave();
        }
        this.setIconButtonId(iContentPage2.getContentID());
        this.currentLC = iContentPage2.createPage(iContentPage, this, n);
        this.switchPane.doSwitch(this.currentLC, n, bl);
        this.currentPage = iContentPage2;
    }
}

