/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.mode.control.ISampleControl;
import com.owon.uppersoft.dso.mode.control.SampleControl;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.ItemPane;
import com.owon.uppersoft.vds.core.data.MinMax;
import com.owon.uppersoft.vds.ui.widget.CNumberSpinner;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SamplePane
extends FunctionPanel {
    private CComboBox samplingcbb;
    private CNumberSpinner avgTimes;
    private ISampleControl sc;
    private boolean listening = false;
    private ItemPane ip2;
    private ItemPane ip1;

    public SamplePane(ControlManager controlManager, final ISampleControl iSampleControl) {
        super(controlManager);
        this.sc = iSampleControl;
        this.ncgp();
        this.nrip();
        this.nlbl("M.Sample.Mode");
        this.samplingcbb = this.nccb(SampleControl.SamplingMode);
        this.ip1 = this.nrip();
        this.nlbl("M.Sample.AvgTimes");
        this.ip2 = this.nrip();
        this.nlblt(SampleControl.MinAverageSampleTimes + "<=");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        MinMax minMax = iSampleControl.getAvgTimesRange();
        spinnerNumberModel.setMaximum(Long.valueOf(minMax.getMax()));
        spinnerNumberModel.setMinimum(Long.valueOf(minMax.getMin()));
        spinnerNumberModel.setStepSize(1L);
        spinnerNumberModel.setValue(iSampleControl.getAvgTimes());
        this.avgTimes = new CNumberSpinner(spinnerNumberModel);
        this.avgTimes.setPreferredSize(new Dimension(100, 30));
        this.ip.add(this.avgTimes);
        this.nlblt("<=" + SampleControl.MaxAverageSampleTimes);
        int n = iSampleControl.getModelIdx();
        this.showAvg(n);
        this.samplingcbb.setSelectedIndex(n);
        this.localizeSelf();
        this.avgTimes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!SamplePane.this.listening) {
                    return;
                }
                int n = ((Number)SamplePane.this.avgTimes.getValue()).intValue();
                iSampleControl.c_setAvgTimes(n);
            }
        });
        this.samplingcbb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!SamplePane.this.listening) {
                    return;
                }
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                int n = SamplePane.this.samplingcbb.getSelectedIndex();
                iSampleControl.c_setModelIdx(n);
                SamplePane.this.showAvg(n);
            }
        });
        this.listening = true;
    }

    protected void showAvg(int n) {
        boolean bl = n == 2;
        this.ip2.setVisible(bl);
        this.ip1.setVisible(bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("APPLY_SAMPLING")) {
            this.listening = false;
            int n = this.sc.getModelIdx();
            this.samplingcbb.setSelectedIndex(n);
            this.avgTimes.setValue(this.sc.getAvgTimes());
            this.showAvg(n);
            this.listening = true;
        }
    }
}

