/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane;

import com.owon.uppersoft.dso.function.FFTView;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.mode.control.FFTControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.GroupPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.ItemPane;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.control.MathControl;
import com.owon.uppersoft.vds.core.fft.WndType;
import com.owon.uppersoft.vds.core.paint.PaintContext;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;

public class MathPane
extends FunctionPanel {
    public static final boolean SupportOffChannel = false;
    public final boolean SupportMarkCursorInFFT = true;
    private GroupPane mathg;
    private GroupPane fftg;
    private CButton colorbt;
    private ItemPane mathp1;
    private ItemPane mathp2;
    private ItemPane mathp3;
    private ItemPane fcp;
    private ItemPane fwp;
    private ItemPane ffp;
    private ItemPane fsp;
    private ItemPane ftbp;
    private CCheckBox mathcb;
    private CCheckBox fftcb;
    private CComboBox mtx1;
    private CComboBox mtx2;
    private CComboBox mtop;
    private CComboBox mvb;
    private CComboBox ftch;
    private CComboBox ftwt;
    private CComboBox ftfm;
    private CComboBox ftv;
    private CComboBox ftsc;
    private CComboBox fttb;
    private CLabel remindLbl;
    boolean listening = false;
    private CComboBox attcbb;
    private FFTView fftv;
    private MathControl mc;
    private FFTControl fftc;
    private WaveFormManager wfm;
    private DataHouse dh = Platform.getDataHouse();

    private void createMathPart(final ControlManager controlManager) {
        if (!this.wfm.isMathSupport()) {
            return;
        }
        this.mathg = this.ncgp();
        this.nrip();
        this.mathcb = this.ncb("M.Math.Name");
        Object[] objectArray = controlManager.getCoreControl().getWaveFormInfos();
        this.mathp1 = this.nrip();
        this.mtx1 = this.nccb(objectArray);
        this.mtop = this.nccb(MathControl.operations);
        this.mtx2 = this.nccb(objectArray);
        this.mathp2 = this.nrip();
        this.nlbl("M.Math.Volt");
        this.mvb = this.nccb(this.mc.getMathVBs());
        this.mvb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                MathPane.this.resetPersistence();
                MathPane.this.mc.setMathvbidx(MathPane.this.mvb.getSelectedIndex());
                MathPane.this.updateMathCompute();
            }
        });
        this.nrip();
        this.colorbt = this.nbtco("Label.Color");
        this.colorbt.setBackground(this.mc.color);
        this.colorbt.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((MathPane)MathPane.this).mc.color = (Color)propertyChangeEvent.getNewValue();
                Platform.getMainWindow().updateDefaultAll();
            }
        });
        this.mathp3 = this.nrip();
        this.remindLbl = this.nlblt("");
        boolean bl = this.mc.mathon;
        this.mathcb.setSelected(bl);
        this.mathshow(bl);
        if (bl) {
            this.updateMathVbIdx();
            this.mvb.setSelectedIndex(this.mc.getMathvbidx());
        }
        this.mathcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                ((MathPane)MathPane.this).mc.mathon = MathPane.this.mathcb.isSelected();
                boolean bl = ((MathPane)MathPane.this).mc.mathon;
                if (!bl) {
                    MathPane.this.mc.setMathvbidx(-1);
                    MathPane.this.getMainWindow().updateShow();
                    controlManager.mcctr.computeYValues();
                } else {
                    MathPane.this.updateMathVbIdx();
                    MathPane.this.listening = false;
                    MathPane.this.refreshMathVoltBase();
                    MathPane.this.listening = true;
                    MathPane.this.updateMathCompute();
                }
                MathPane.this.mathshow(bl);
                MathPane.this.updateMathRemindLbl(MathPane.this.wfm, true);
            }
        });
        this.mtx1.setSelectedIndex(this.mc.m1);
        this.mtx2.setSelectedIndex(this.mc.m2);
        this.mtop.setSelectedIndex(this.mc.operation);
        this.updateMathRemindLbl(this.wfm, true);
        this.mtx1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                MathPane.this.resetPersistence();
                ((MathPane)MathPane.this).mc.m1 = MathPane.this.mtx1.getSelectedIndex();
                MathPane.this.updateMathCompute();
                MathPane.this.refreshMathVoltBase();
                MathPane.this.updateMathRemindLbl(MathPane.this.wfm, true);
            }
        });
        this.mtop.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                MathPane.this.wfm.setMathOperation(MathPane.this.mtop.getSelectedIndex());
                MathPane.this.updateMathCompute();
                MathPane.this.mvb.setModel(new DefaultComboBoxModel<String>(MathPane.this.mc.getMathVBs()));
                MathPane.this.refreshMathVoltBase();
            }
        });
        this.mtx2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                MathPane.this.resetPersistence();
                ((MathPane)MathPane.this).mc.m2 = MathPane.this.mtx2.getSelectedIndex();
                MathPane.this.updateMathCompute();
                MathPane.this.refreshMathVoltBase();
                MathPane.this.updateMathRemindLbl(MathPane.this.wfm, true);
            }
        });
    }

    public MathPane(ControlManager controlManager) {
        super(controlManager);
        this.mc = controlManager.mathControl;
        this.fftc = controlManager.getFFTControl();
        this.wfm = this.dh.getWaveFormManager();
        this.fftv = this.wfm.getFFTView();
        this.createMathPart(controlManager);
        Object[] objectArray = controlManager.getCoreControl().getWaveFormInfos();
        this.fftg = this.ncgp();
        this.nrip();
        this.fftcb = this.ncbt("FFT");
        this.fcp = this.nrip();
        this.nlbl("M.Math.Channel");
        this.ftch = this.nccb(objectArray);
        if (controlManager.getAllChannelsNumber() == 1) {
            this.ftch.setEnabled(false);
        }
        this.fwp = this.nrip();
        this.nlbl("M.Math.FFT.Window");
        this.ftwt = this.nccb((Object[])WndType.values());
        this.ffp = this.nrip();
        this.nlbl("M.Math.FFT.Format");
        this.ftfm = this.nccb(FFTControl.format);
        this.reBuildValuePerDivComboBox(this.mc);
        this.fsp = this.nrip();
        this.nlbl("M.Math.FFT.Scale");
        this.ftsc = this.nccb(FFTControl.scale);
        this.ftbp = this.nrip();
        this.nlbl("M.Math.FFT.Freq");
        this.fttb = this.nccb(controlManager.getMachineInfo().FFTTimeBases);
        this.fttb.setSelectedIndex(this.fftc.getFFTTimebaseIndex());
        this.fttb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                MathPane.this.fftc.setFFTTimebaseIndex(MathPane.this.fttb.getSelectedIndex());
                MathPane.this.updateFFT();
            }
        });
        this.fftcb.setSelected(this.fftc.isFFTon());
        this.nrip();
        this.colorbt = this.nbtco("Label.Color");
        this.colorbt.setBackground(this.fftc.color);
        this.colorbt.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((MathPane)MathPane.this).fftc.color = (Color)propertyChangeEvent.getNewValue();
                Platform.getMainWindow().updateDefaultAll();
            }
        });
        this.fftshow(this.fftc.isFFTon());
        this.localizeSelf();
        this.fftcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                MathPane.this.ftsc.setSelectedIndex(0);
                MathPane.this.fftcb.setEnabled(false);
                MathPane.this.changeFFT(MathPane.this.fftcb.isSelected());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                MathPane.this.fftcb.setEnabled(true);
            }
        });
        int n = this.fftc.getFFTchl();
        this.ftch.setSelectedIndex(n);
        final int n2 = this.ftch.getItemCount() - 1;
        this.ftwt.setSelectedIndex(this.fftc.getFFTwnd());
        this.ftfm.setSelectedIndex(this.fftc.fftvaluetype);
        this.ftsc.setSelectedIndex(this.fftc.fftscale);
        this.ftch.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                int n = MathPane.this.ftch.getSelectedIndex();
                if (MathPane.this.fftc.getFFTchl() == n) {
                    return;
                }
                WaveForm waveForm = MathPane.this.wfm.getWaveForm(n);
                if (waveForm == null) {
                    return;
                }
                MathPane.this.fftc.c_setFFTchl(n);
                MathPane.this.reBuildValuePerDivComboBox(MathPane.this.mc);
                MathPane.this.updateFFT();
                MathPane.this.dh.getMainWindow().getToolPane().getInfoPane().repaint();
            }
        });
        this.ftwt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                MathPane.this.fftc.setFFTwnd(MathPane.this.ftwt.getSelectedIndex());
                MathPane.this.updateFFT();
            }
        });
        this.ftfm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                ((MathPane)MathPane.this).fftc.fftvaluetype = MathPane.this.ftfm.getSelectedIndex();
                MathPane.this.fftv.reset();
                MathPane.this.updateFFT();
                MathPane.this.reBuildValuePerDivComboBox(MathPane.this.mc);
            }
        });
        this.ftsc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                ((MathPane)MathPane.this).fftc.fftscale = n = MathPane.this.ftsc.getSelectedIndex();
                MathPane.this.fftv.scale();
                MathPane.this.updateFFT();
            }
        });
        this.listening = true;
    }

    private MainWindow getMainWindow() {
        return this.dh.getMainWindow();
    }

    protected void updateFFT() {
        if (this.cm.isKeepGet()) {
            return;
        }
        this.fftv.receiveNewData();
        this.getMainWindow().updateShow();
    }

    protected void resetPersistence() {
        this.cm.resetPersistence();
    }

    public void changeFFT(boolean bl) {
        this.fftc.c_setFFTon(bl);
        this.fftshow(bl);
        if (bl) {
            this.listening = false;
            this.fttb.setSelectedIndex(this.fftc.getFFTTimebaseIndex());
            this.cm.pcs.firePropertyChange("TURN_ON_MARKBULLETIN", null, (Object)false);
            this.listening = true;
        }
        this.getMainWindow().getToolPane().getButtonPane().switch_3in1_fft(bl);
        if (!this.cm.sourceManager.isConnected() && bl) {
            this.updateFFT();
        }
    }

    private void reBuildValuePerDivComboBox(MathControl mathControl) {
        if (this.ftv != null) {
            this.ffp.remove(this.ftv);
            this.ftv = null;
        }
        switch (this.fftc.fftvaluetype) {
            case 0: {
                WaveForm waveForm = this.fftc.getWaveForm();
                if (this.fftv.vrmsbaseidx < 0) {
                    this.fftv.vrmsbaseidx = Math.max(0, waveForm.getVoltbaseIndex() - 1);
                }
                this.ftv = new CComboBox(this.fftc.VOLTAGEs);
                this.ffp.add(this.ftv);
                this.ftv.setSelectedIndex(this.fftv.vrmsbaseidx);
                this.fftv.setVrmsIdx(this.ftv.getSelectedIndex());
                break;
            }
            case 1: {
                this.ftv = new CComboBox(this.fftc.dBPerDiv);
                this.ffp.add(this.ftv);
                this.ftv.setSelectedIndex(this.fftv.dBbaseidx);
                this.fftv.setVrmsIdx(this.ftv.getSelectedIndex());
            }
        }
        this.ftv.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MathPane.this.listening) {
                    return;
                }
                if (1 != itemEvent.getStateChange()) {
                    return;
                }
                int n = 0;
                switch (((MathPane)MathPane.this).fftc.fftvaluetype) {
                    case 0: {
                        ((MathPane)MathPane.this).fftv.vrmsbaseidx = n = MathPane.this.ftv.getSelectedIndex();
                        break;
                    }
                    case 1: {
                        ((MathPane)MathPane.this).fftv.dBbaseidx = n = MathPane.this.ftv.getSelectedIndex();
                    }
                }
                MathPane.this.fftv.setVrmsIdx(n);
                MathPane.this.updateFFT();
            }
        });
        this.ffp.repaint();
    }

    protected void updateTimebase() {
        this.fttb.setSelectedIndex(this.fftc.getFFTTimebaseIndex());
    }

    protected void fftshow(boolean bl) {
        int n = this.fftg.getComponentCount();
        while (--n > 0) {
            this.fftg.getComponent(n).setVisible(bl);
        }
    }

    protected void updateMathVbIdx() {
        WaveForm waveForm = this.wfm.getM1();
        WaveForm waveForm2 = this.wfm.getM2();
        this.mc.updateMathVbIdx(waveForm, waveForm2);
    }

    protected void updateMathCompute() {
        this.cm.mcctr.computeYValues();
        if (this.cm.isKeepGet()) {
            return;
        }
        MainWindow mainWindow = this.getMainWindow();
        PaintContext paintContext = mainWindow.getChartScreen().getPaintContext();
        this.updateMathVbIdx();
        this.wfm.getCompositeWaveForm().receiveNewData(paintContext);
        mainWindow.updateShow();
    }

    protected void updateMathRemindLbl(WaveFormManager waveFormManager, boolean bl) {
        boolean bl2 = this.mathcb.isSelected();
        if (bl2) {
            String string = waveFormManager.getClosedChannelName(this.mc.m1, this.mc.m2);
            if (string.length() == 0) {
                this.mathp3.setVisible(false);
            } else {
                String string2 = string + " " + I18nProvider.bundle().getString("M.Channel.OffRemind");
                this.remindLbl.setText(string2);
                this.mathp3.setVisible(true);
                if (bl) {
                    FadeIOShell fadeIOShell = new FadeIOShell();
                    String string3 = I18nProvider.bundle().getString("M.Math.Name") + ":" + string2;
                    fadeIOShell.prompt(string3, this.getMainWindow().getFrame());
                }
            }
        }
    }

    public void refreshMathVoltBase() {
        WaveForm waveForm = this.wfm.getM1();
        WaveForm waveForm2 = this.wfm.getM2();
        this.mc.refreshMathVoltBase(waveForm, waveForm2);
        this.mvb.setSelectedIndex(this.mc.getMathvbidx());
    }

    protected void mathshow(boolean bl) {
        int n = this.mathg.getComponentCount();
        while (--n > 0) {
            this.mathg.getComponent(n).setVisible(bl);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("ChannelOption")) {
            this.updateMathRemindLbl(this.wfm, false);
        } else if (string.equals("onTimebaseUpdated")) {
            this.listening = false;
            this.updateTimebase();
            this.listening = true;
        } else if (string.equals("PROBECHANGE")) {
            this.listening = false;
            this.reBuildValuePerDivComboBox(this.mc);
            this.listening = true;
        } else if (string.equals("START_AUTOSET")) {
            this.changeFFT(false);
            this.fftcb.setSelected(false);
        } else if (string.equals("MACHINETYPE_CHANGE")) {
            this.listening = false;
            this.fttb.setModel(new DefaultComboBoxModel<String>(this.cm.getMachineInfo().FFTTimeBases));
            this.listening = true;
        } else if (string.equals("UPDATE_CHLVOLT")) {
            this.listening = false;
            this.reBuildValuePerDivComboBox(this.mc);
            this.listening = true;
        } else if (string.equals("tune_vbbChange")) {
            this.fftv.vrmsbaseidx = -1;
            this.listening = false;
            this.reBuildValuePerDivComboBox(this.mc);
            this.listening = true;
        } else if (string.equals("UPDATE_FFT")) {
            this.listening = false;
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.ftfm.setSelectedIndex(this.fftc.fftvaluetype);
                this.reBuildValuePerDivComboBox(this.mc);
            } else {
                this.ftch.setSelectedIndex(this.fftc.getFFTchl());
                this.ftwt.setSelectedIndex(this.fftc.getFFTwnd());
                this.ftsc.setSelectedIndex(this.fftc.fftscale);
                this.fttb.setSelectedIndex(this.fftc.getFFTTimebaseIndex());
            }
            this.listening = true;
        } else if (string.equals("CHANGE_FFT")) {
            this.listening = false;
            this.fftcb.setSelected(this.fftc.isFFTon());
            this.fftshow(this.fftc.isFFTon());
            this.listening = true;
        }
    }

    public boolean canLeave() {
        return true;
    }
}

