/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane;

import com.owon.uppersoft.dso.function.FFTCursorControl;
import com.owon.uppersoft.dso.function.MarkCursorControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.GroupPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.ItemPane;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class MarkPane
extends FunctionPanel {
    private CComboBox marktype;
    private CComboBox chlccb;
    private boolean listening = false;
    private CCheckBox tbchb;
    private CCheckBox vbchb;
    private CCheckBox frechb;
    private CCheckBox voltchb;
    private CLabel remindtxt;
    private ItemPane remindip;
    private GroupPane fftgp;
    private CButton colorbt;
    private CButton colorfftbt;

    public MarkPane(final ControlManager controlManager) {
        super(controlManager);
        final MarkCursorControl markCursorControl = controlManager.mcctr;
        final FFTCursorControl fFTCursorControl = controlManager.fftctr;
        this.ncgp();
        this.nrip();
        this.nlbl("M.Mark.Channel");
        this.nrip();
        this.vbchb = this.ncb("M.Mark.FFTVamp");
        this.nrip();
        this.tbchb = this.ncb("M.Mark.Timebase");
        this.nrip();
        this.colorbt = this.nbtco("Label.Color");
        this.colorbt.setBackground(controlManager.mcctr.color);
        this.colorbt.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                controlManager.mcctr.color = (Color)propertyChangeEvent.getNewValue();
                Platform.getMainWindow().updateDefaultAll();
            }
        });
        this.remindip = this.nrip();
        this.remindtxt = this.nlblt("");
        this.fftgp = this.ncgp();
        this.nrip();
        this.nlblt("FFT:");
        this.nrip();
        this.frechb = this.ncb("M.Mark.FFTFreq");
        this.nrip();
        this.voltchb = this.ncb("M.Mark.FFTVamp");
        this.nrip();
        this.colorfftbt = this.nbtco("Label.Color");
        this.colorfftbt.setBackground(controlManager.fftctr.color);
        this.colorfftbt.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                controlManager.fftctr.color = (Color)propertyChangeEvent.getNewValue();
                Platform.getMainWindow().updateDefaultAll();
            }
        });
        this.localizeSelf();
        this.tbchb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MarkPane.this.listening) {
                    return;
                }
                markCursorControl.setOnTimebaseM(MarkPane.this.tbchb.isSelected());
                MarkPane.this.repaintChartScreen();
            }
        });
        this.vbchb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MarkPane.this.listening) {
                    return;
                }
                markCursorControl.setOnVoltbaseM(MarkPane.this.vbchb.isSelected());
                MarkPane.this.repaintChartScreen();
            }
        });
        if (this.chlccb != null) {
            this.chlccb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!MarkPane.this.listening) {
                        return;
                    }
                    if (itemEvent.getStateChange() != 1) {
                        return;
                    }
                    if (MarkPane.this.chlccb == null) {
                        return;
                    }
                    int n = MarkPane.this.chlccb.getSelectedIndex();
                    WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
                    waveFormManager.setSelectedWaveForm(n);
                    markCursorControl.computeYValues();
                    MarkPane.this.updateRemindtxt(n);
                    Platform.getMainWindow().getToolPane().getInfoPane().updateSelected(n);
                    MarkPane.this.repaintChartScreen();
                }
            });
        }
        this.frechb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MarkPane.this.listening) {
                    return;
                }
                fFTCursorControl.setOnFrebaseMark(MarkPane.this.frechb.isSelected());
                MarkPane.this.repaintChartScreen();
            }
        });
        this.voltchb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MarkPane.this.listening) {
                    return;
                }
                fFTCursorControl.setOnVoltbaseMark(MarkPane.this.voltchb.isSelected());
                MarkPane.this.repaintChartScreen();
            }
        });
        this.loadMarkCursorSelected(markCursorControl, fFTCursorControl);
        this.listening = true;
    }

    private void repaintChartScreen() {
        Platform.getMainWindow().getChartScreen().re_paint();
    }

    private void updateRemindtxt(int n) {
        WaveFormInfo waveFormInfo = this.cm.getCoreControl().getWaveFormInfo(n);
        boolean bl = !waveFormInfo.ci.isOn();
        this.remindip.setVisible(bl);
        if (bl) {
            this.remindtxt.setText(waveFormInfo.toString() + " " + I18nProvider.bundle().getString("M.Channel.OffRemind"));
        } else {
            this.remindtxt.setText("");
        }
    }

    private void loadMarkCursorSelected(MarkCursorControl markCursorControl, FFTCursorControl fFTCursorControl) {
        this.listening = false;
        this.tbchb.setSelected(markCursorControl.getOnTimebaseM());
        this.vbchb.setSelected(markCursorControl.getOnVoltbaseM());
        this.frechb.setSelected(fFTCursorControl.getOnFrebaseMark());
        this.voltchb.setSelected(fFTCursorControl.getOnVoltbaseMark());
        this.listening = true;
    }

    protected void loadCurrentChannel(int n) {
        this.listening = false;
        if (this.chlccb != null) {
            this.chlccb.setSelectedIndex(n);
        }
        this.listening = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SelectWF")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.loadCurrentChannel(n);
        } else if (string.equals("ChannelOption")) {
            int n = 0;
            if (this.chlccb != null) {
                n = this.chlccb.getSelectedIndex();
            }
            this.updateRemindtxt(n);
        } else if (string.equals("UPDATE_CURSOR")) {
            this.listening = false;
            MarkCursorControl markCursorControl = this.cm.mcctr;
            this.tbchb.setSelected(markCursorControl.getOnTimebaseM());
            this.vbchb.setSelected(markCursorControl.getOnVoltbaseM());
            this.listening = true;
        }
    }
}

