/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane;

import com.owon.uppersoft.dso.util.DBG;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.Document;

public class LogDialog
extends JDialog {
    private JTextArea textArea;
    private DialogHandler dialogHandler;
    private AbstractButton ab;

    public LogDialog(Window window, final AbstractButton abstractButton) {
        super(window);
        this.ab = abstractButton;
        this.dialogHandler = new DialogHandler();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                abstractButton.setSelected(false);
                LogDialog.this.removeHandler();
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        final JComboBox<Level> jComboBox = new JComboBox<Level>(DBG.Levels);
        jComboBox.setSelectedItem(DBG.getLogger().getLevel());
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DBG.setLogType(jComboBox.getSelectedIndex());
            }
        });
        jPanel.add(jComboBox);
        String[] stringArray = new String[]{"VDS3102ONE", "VDS2062ONE", "VDS1022ONE"};
        JComboBox jComboBox2 = new JComboBox();
        jComboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
            }
        });
        jPanel.add(jComboBox2);
        JButton jButton = new JButton("clear");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogDialog.this.textArea.setText("");
            }
        });
        this.add((Component)jPanel, "North");
        this.textArea = new JTextArea();
        DBG.getLogger().addHandler(this.dialogHandler);
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = new JViewport();
        jViewport.add(this.textArea);
        jScrollPane.setViewport(jViewport);
        this.add((Component)jScrollPane, "Center");
        this.setBounds(100, 100, 500, 375);
        this.setVisible(true);
    }

    private void removeHandler() {
        DBG.getLogger().removeHandler(this.dialogHandler);
    }

    public void append(String string) {
        Document document = this.textArea.getDocument();
        int n = document.getLength();
        if (n >= 50000) {
            this.textArea.replaceRange("", 0, 20000);
        }
        this.textArea.append(string);
        n = document.getLength();
        this.textArea.setCaretPosition(n);
    }

    private final class DialogHandler
    extends Handler {
        private DialogHandler() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            String string = logRecord.getMessage();
            LogDialog.this.append(string);
        }

        @Override
        public void close() throws SecurityException {
            LogDialog.this.removeHandler();
        }

        @Override
        public void flush() {
        }
    }
}

