/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.source.usb.USBSourceManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.pane.LogDialog;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.GroupPane;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.ExcludeButtons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplayPane
extends FunctionPanel {
    private CComboBox persistcbb;
    private CComboBox xcbb;
    private CComboBox ycbb;
    private boolean listening = false;
    private CCheckBox xycb;
    private ExcludeButtons ebs;
    private CButton xycolorbt;
    private LogDialog dlg;
    private GroupPane gp;

    public DisplayPane(final ControlManager controlManager) {
        super(controlManager);
        Object[] objectArray;
        final DataHouse dataHouse = Platform.getDataHouse();
        this.ebs = this.initLineBtns();
        this.ncgp();
        this.nrip().add(this.ebs);
        if (controlManager.isXYModeSupport()) {
            this.ncgp();
            this.nrip();
            this.xycb = this.ncb("M.Display.XYMode");
            this.nrip();
            this.xycb.setSelected(controlManager.displayControl.isXYModeOn());
            objectArray = controlManager.getCoreControl().getWaveFormInfos();
            this.xcbb = this.nccb(objectArray);
            this.nlblt("&");
            this.ycbb = this.nccb(objectArray);
            this.xcbb.setSelectedIndex(controlManager.displayControl.wfx);
            this.ycbb.setSelectedIndex(controlManager.displayControl.wfy);
            this.nrip();
            this.xycolorbt = this.nbtco("Label.Color");
            this.xycolorbt.setBackground(controlManager.displayControl.xycolor);
            this.xycolorbt.addPropertyChangeListener("background", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    controlManager.displayControl.xycolor = (Color)propertyChangeEvent.getNewValue();
                    Platform.getMainWindow().updateDefaultAll();
                }
            });
            this.xcbb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!DisplayPane.this.listening) {
                        return;
                    }
                    if (itemEvent.getStateChange() != 1) {
                        return;
                    }
                    dataHouse.controlManager.displayControl.wfx = DisplayPane.this.xcbb.getSelectedIndex();
                    DisplayPane.this.updateXY();
                }
            });
            this.ycbb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!DisplayPane.this.listening) {
                        return;
                    }
                    if (itemEvent.getStateChange() != 1) {
                        return;
                    }
                    dataHouse.controlManager.displayControl.wfy = DisplayPane.this.ycbb.getSelectedIndex();
                    DisplayPane.this.updateXY();
                }
            });
            this.xycb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!DisplayPane.this.listening) {
                        return;
                    }
                    boolean bl = DisplayPane.this.xycb.isSelected();
                    controlManager.displayControl.setXYMode(bl);
                    Platform.getMainWindow().getToolPane().getButtonPane().switch_3in1_xy(bl);
                    DisplayPane.this.updateXY();
                }
            });
        }
        this.ncgp();
        this.nrip();
        this.nlbl("M.Display.Persistence");
        this.nrip();
        this.persistcbb = this.nccb(controlManager.displayControl.getPersistenceItems());
        this.persistcbb.setSelectedIndex(controlManager.displayControl.getPersistenceIndex());
        objectArray = this.nbtn("M.Custom.clear");
        this.ncgp();
        this.nrip();
        this.nlbl("Label.GridBrightness");
        this.nrip();
        final JSlider jSlider = new JSlider();
        this.ip.add(jSlider);
        jSlider.setMaximum(215);
        jSlider.setValue(controlManager.displayControl.getGridBrightness() - 40);
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = jSlider.getValue() + 40;
                controlManager.displayControl.changeGridBrightness(n, dataHouse.getMainWindow());
            }
        });
        this.localizeSelf();
        this.persistcbb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!DisplayPane.this.listening) {
                    return;
                }
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                int n = controlManager.displayControl.setPersistenceIndex(DisplayPane.this.persistcbb.getSelectedIndex());
                dataHouse.getPersistentDisplay().fadeThdOn_Off_UI(n);
            }
        });
        objectArray.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                controlManager.resetPersistence();
            }
        });
        this.addDebugBtn();
        this.listening = true;
    }

    private ExcludeButtons initLineBtns() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!DisplayPane.this.listening) {
                    return;
                }
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("exclude")) {
                    boolean bl;
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    ((DisplayPane)DisplayPane.this).cm.displayControl.linelink = bl = n == 0;
                    Platform.getMainWindow().updateShow();
                }
            }
        };
        Object[] objectArray = new String[]{I18nProvider.bundle().getString("M.Display.Vector"), I18nProvider.bundle().getString("M.Display.Dots")};
        int n = this.cm.displayControl.linelink ? 0 : 1;
        ExcludeButtons excludeButtons = new ExcludeButtons(objectArray, propertyChangeListener, n, 90, 60, FontCenter.getLabelFont());
        return excludeButtons;
    }

    private void updateXY() {
        Platform.getMainWindow().getChartScreen().updateXYView();
    }

    protected void testUp() {
        Platform.getMainWindow().promptUp();
    }

    private void addDebugBtn() {
        this.gp = this.ncgp();
        boolean bl = this.cm.sc.isPWDOpen();
        this.gp.setVisible(bl);
        if (!bl) {
            return;
        }
        this.nrip_notitle();
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setPreferredSize(new Dimension(280, 135));
        final MainWindow mainWindow = Platform.getMainWindow();
        final JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setText("log");
        jToggleButton.setSelected(false);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jToggleButton.isSelected();
                if (!bl) {
                    if (DisplayPane.this.dlg != null) {
                        DisplayPane.this.dlg.dispose();
                        DisplayPane.this.dlg = null;
                    }
                } else {
                    DisplayPane.this.dlg = new LogDialog((Window)mainWindow.getFrame(), jToggleButton);
                }
            }
        });
        this.gp.add(jPanel);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Platform.getControlApps().interComm.initDetail();
            }
        });
        jButton.setText("batch");
        JButton jButton2 = new JButton("autoGet");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Platform.getControlApps().keepload();
            }
        });
        JButton jButton3 = new JButton("stop");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Platform.getControlApps().stopkeep();
            }
        });
        final JButton jButton4 = new JButton("Connect");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                USBSourceManager uSBSourceManager = ((DisplayPane)DisplayPane.this).cm.sourceManager.getUSBSourceManager();
                if (!uSBSourceManager.isConnected()) {
                    List<IDevice> list = uSBSourceManager.refreshUSBPort();
                    if (list.size() == 0) {
                        return;
                    }
                    IDevice iDevice = list.get(0);
                    if (iDevice != null && ((DisplayPane)DisplayPane.this).cm.sourceManager.connectUSB(iDevice)) {
                        jButton4.setText("Disconnect");
                    }
                } else {
                    ((DisplayPane)DisplayPane.this).cm.sourceManager.disconnectSource();
                    jButton4.setText("Connect");
                }
            }
        });
        JButton jButton5 = new JButton("Tune");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPane.this.cm.getPrinciple().openTuneDialog(mainWindow.getFrame(), ((DisplayPane)DisplayPane.this).cm.pcs);
            }
        });
        final JToggleButton jToggleButton2 = new JToggleButton("t2");
        jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jToggleButton2.isSelected()) {
                    DisplayPane.this.testUp();
                }
            }
        });
        final JButton jButton6 = new JButton("FadeCost");
        jButton6.addActionListener(new ActionListener(){
            long t0;
            boolean fadedCostTimeVisible = false;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.fadedCostTimeVisible) {
                    DisplayPane.this.setChannelCoupling(0, "GND");
                    this.t0 = System.currentTimeMillis();
                    jButton6.setText("timing...");
                    this.fadedCostTimeVisible = true;
                } else {
                    long l = System.currentTimeMillis();
                    long l2 = l - this.t0;
                    jButton6.setText("elapsed:" + l2);
                    this.fadedCostTimeVisible = false;
                    DisplayPane.this.setChannelCoupling(0, "AC");
                }
            }
        });
        jPanel.add(jButton5);
        jPanel.add(jToggleButton);
        jPanel.add(jButton3);
        jPanel.add(jButton2);
        jPanel.add(jButton4);
        jPanel.add(jButton);
        jPanel.add(jButton6);
        this.createHideContent(mainWindow.getWindow(), jPanel, this.cm);
    }

    protected void createHideContent(Window window, JPanel jPanel, ControlManager controlManager) {
    }

    private String setChannelCoupling(int n, String string) {
        int n2 = -1;
        String[] stringArray = ChannelInfo.COUPLINGCHARS;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            n2 = i;
        }
        WaveForm waveForm = this.cm.getWaveFormInfoControl().getWaveForm(n);
        if (waveForm == null || n2 < 0) {
            return "ERR CHANNEL";
        }
        waveForm.wfi.ci.c_setCoupling(n2);
        this.cm.pcs.firePropertyChange("CouplingOption", null, null);
        Platform.getMainWindow().updateDefaultAll();
        return "SUCCESS";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("ADMIN_ROOT_PASSWORD_NOTIFY")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.gp.setVisible(bl);
        } else if (string.equals("UPDATE_PERSISTENCE_INDEX")) {
            this.listening = false;
            int n = this.cm.displayControl.getPersistenceIndex();
            this.persistcbb.setSelectedIndex(n);
            this.listening = true;
        } else if (string.equals("UPDATE_LINELINK")) {
            this.listening = false;
            int n = this.cm.displayControl.linelink ? 0 : 1;
            this.ebs.setSelected(n);
            this.listening = true;
        }
    }
}

