/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.pane;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.ISampleControl;
import com.owon.uppersoft.dso.mode.control.SampleControl;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.page.ChannelPage;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.pane.dock.widget.FunctionPanel;
import com.owon.uppersoft.dso.view.pane.dock.widget.GroupPane;
import com.owon.uppersoft.dso.view.pane.dock.widget.ItemPane;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.IChannel;
import com.owon.uppersoft.vds.core.data.MinMax;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import com.owon.uppersoft.vds.ui.widget.CNumberSpinner;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import com.owon.uppersoft.vds.ui.widget.custom.ExcludeButtons;
import com.owon.uppersoft.vds.ui.widget.help.RadioButtonGroup;
import com.owon.uppersoft.vds.util.ui.ListComboBoxModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JSlider;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChannelPane
extends FunctionPanel
implements ItemListener,
ActionListener {
    protected MainWindow mw;
    private boolean bandLimit = true;
    private GroupPane gp1;
    private CButton colorbt;
    private CCheckBox channelOption;
    private CCheckBox channelOpposite;
    private CComboBox probecbb;
    private CComboBox couplingcbb;
    private GroupPane chl_detail_pane;
    private RadioButtonGroup rbg;
    private JSlider filterslider;
    private CLabel filterlabel;
    private CComboBox samplingcbb;
    private CNumberSpinner avgTimes;
    private ISampleControl sc;
    private ItemPane ip2;
    private ItemPane ip1;
    private CComboBox syoccb;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            ChannelPane.this.loadCurrentChannel(n);
        }
    };
    private ChannelPage cp;
    private CCheckBox channelMeasCurrOn;
    private ItemPane MeasCurrPane;
    private CNumberSpinner amp;
    private boolean listening = false;
    private ExcludeButtons ebs;

    public ChannelPane(final ControlManager controlManager, final ChannelPage channelPage) {
        super(controlManager);
        this.mw = Platform.getMainWindow();
        this.cp = channelPage;
        this.sc = controlManager.getSampleControl();
        this.bandLimit = channelPage.isBandLimit();
        this.gp1 = this.ncgp();
        int n = channelPage.getSelectedChannelIndex();
        this.rbg = new RadioButtonGroup(channelPage.getChannelNames(), this.pcl, n, 64, 30);
        this.nrip().add(this.rbg);
        this.nrip();
        this.channelOption = this.ncb("Label.OnOff");
        this.nrip();
        this.channelOpposite = this.ncb("M.Channel.Opposite");
        this.nrip();
        this.channelMeasCurrOn = this.ncb("M.Channel.MeasCurrOnOf");
        this.MeasCurrPane = this.nrip();
        this.nlblt("    ");
        this.amp = new CNumberSpinner(new SpinnerNumberModel(0, 0, 10000000, 1));
        this.amp.setPreferredSize(new Dimension(100, 30));
        this.amp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ChannelPane.this.listening) {
                    return;
                }
                int n = ((Number)ChannelPane.this.amp.getValue()).intValue();
                ChannelPane.this.setAmperePerVolt(n);
            }
        });
        this.ip.add(this.amp);
        this.nnnlbl("mA/V ");
        IChannel iChannel = channelPage.getCurrentChannel();
        this.channelMeasCurrOn.setSelected(iChannel.isMeasureCurrent());
        this.MeasCurrPane.setVisible(iChannel.isMeasureCurrent());
        if (this.bandLimit) {
            this.nrip();
            this.ebs = new ExcludeButtons(new LObject[]{new LObject("M.Channel.bandlimit_20M"), new LObject("M.Channel.Fullband")}, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    IChannel iChannel = channelPage.getCurrentChannel();
                    iChannel.c_setBandLimit(n == 0);
                    controlManager.pcs.firePropertyChange("UPDATE_CHLVOLT", null, (Object)iChannel.getNumber());
                }
            }, 0, 130, 30, FontCenter.getLabelFont());
            this.ip.add(this.ebs);
        }
        this.nrip();
        this.nlbl("M.Channel.Coupling");
        this.couplingcbb = this.nccb(ChannelInfo.COUPLING);
        this.nrip();
        this.nlbl("M.Channel.ProbeRate");
        this.probecbb = this.nccb(controlManager.getMachineInfo().ProbeTexts);
        this.nrip();
        this.nlbl("M.Channel.Filter");
        this.filterlabel = this.nlblt("--");
        this.nrip();
        this.filterslider = new JSlider();
        this.filterslider.setMinimum(0);
        this.filterslider.setMaximum(99);
        this.filterslider.setValue(0);
        this.filterslider.setPreferredSize(new Dimension(250, 25));
        this.filterslider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = ChannelPane.this.filterslider.getValue();
                int n2 = channelPage.getCurrentChannel().getNumber();
                ChannelInfo channelInfo = controlManager.getWaveFormInfoControl().getWaveFormChannelInfo(n2);
                channelInfo.setFilterIdx(n);
                ChannelPane.this.filterlabel.setText(channelInfo.getFilterLabel());
                if (!controlManager.isRuntime()) {
                    Platform.getControlApps().getDaemon().getAbsGetDataRunner().getData();
                    Platform.getMainWindow().updateShow();
                }
            }
        });
        this.ip.add(this.filterslider);
        this.nrip();
        this.colorbt = this.nbtco("Label.Color");
        this.colorbt.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = channelPage.getCurrentChannel().getNumber();
                ChannelInfo channelInfo = channelPage.getChannelNames()[n].ci;
                channelInfo.color = (Color)propertyChangeEvent.getNewValue();
                Platform.getMainWindow().updateDefaultAll();
            }
        });
        this.ncgp();
        this.nrip();
        this.nlbl("M.Sample.Mode");
        this.samplingcbb = this.nccb(SampleControl.SamplingMode);
        this.ip1 = this.nrip();
        this.nlbl("M.Sample.AvgTimes");
        this.ip2 = this.nrip();
        this.nlblt(SampleControl.MinAverageSampleTimes + "<=");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        MinMax minMax = this.sc.getAvgTimesRange();
        spinnerNumberModel.setMaximum(Long.valueOf(minMax.getMax()));
        spinnerNumberModel.setMinimum(Long.valueOf(minMax.getMin()));
        spinnerNumberModel.setStepSize(1L);
        spinnerNumberModel.setValue(this.sc.getAvgTimes());
        this.avgTimes = new CNumberSpinner(spinnerNumberModel);
        this.avgTimes.setPreferredSize(new Dimension(100, 30));
        this.ip.add(this.avgTimes);
        this.nlblt("<=" + SampleControl.MaxAverageSampleTimes);
        int n2 = this.sc.getModelIdx();
        this.showAvg(n2);
        this.samplingcbb.setSelectedIndex(n2);
        this.samplingcbb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!ChannelPane.this.listening) {
                    return;
                }
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                int n = ChannelPane.this.samplingcbb.getSelectedIndex();
                ChannelPane.this.sc.c_setModelIdx(n);
                ChannelPane.this.showAvg(n);
            }
        });
        this.avgTimes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ChannelPane.this.listening) {
                    return;
                }
                int n = ((Number)ChannelPane.this.avgTimes.getValue()).intValue();
                ChannelPane.this.sc.c_setAvgTimes(n);
            }
        });
        MachineType machineType = controlManager.getMachine();
        this.createMutliIOGroup(machineType);
        this.localizeSelf();
        this.loadCurrentChannel(n);
        this.addListeners();
    }

    private void createMutliIOGroup(MachineType machineType) {
        if (machineType.isMultiIOSupport()) {
            this.ncgp();
            this.nrip();
            this.nlbl("M.Utility.SYNO.Name");
            this.syoccb = this.nccb(this.cm.getSyncInOuts());
            this.syoccb.setSelectedIndex(this.cm.getSysControl().getSyncOutput());
            this.syoccb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!ChannelPane.this.listening) {
                        return;
                    }
                    int n = ChannelPane.this.syoccb.getSelectedIndex();
                    ChannelPane.this.cm.getSysControl().c_setSyncOut(n);
                    TriggerControl triggerControl = ChannelPane.this.cm.getTriggerControl();
                    if (n != 0 && triggerControl.isSingleTrg() && triggerControl.isExtTrg(triggerControl.getSingleTrgChannel())) {
                        triggerControl.setSingleChannel(0);
                        ChannelPane.this.mw.getToolPane().getTrgInfoPane().updateInfos(triggerControl);
                        triggerControl.doSubmit();
                    }
                    ChannelPane.this.mw.re_paint();
                }
            });
        } else {
            this.syoccb = null;
        }
    }

    protected void showChannelDetail(boolean bl) {
        int n = this.gp1.getComponentCount();
        while (--n > 1) {
            this.gp1.getComponent(n).setVisible(bl);
        }
        this.MeasCurrPane.setVisible(this.cp.getCurrentChannel().isMeasureCurrent());
    }

    protected void addListeners() {
        this.channelOption.addActionListener(this);
        this.channelOpposite.addActionListener(this);
        this.channelMeasCurrOn.addActionListener(this);
        this.couplingcbb.addItemListener(this);
        this.probecbb.addItemListener(this);
        this.listening = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listening) {
            return;
        }
        if (actionEvent.getSource() == this.channelOption) {
            boolean bl = this.channelOption.isSelected();
            IChannel iChannel = this.cp.getCurrentChannel();
            iChannel.c_setOn(bl);
            this.showChannelDetail(bl);
            DataHouse dataHouse = Platform.getDataHouse();
            Platform.getMainWindow().channelOnOffRepaint(dataHouse.getWaveFormManager().getWaveForm(iChannel.getNumber()));
            return;
        }
        if (actionEvent.getSource() == this.channelOpposite) {
            IChannel iChannel = this.cp.getCurrentChannel();
            iChannel.c_setInverse(this.channelOpposite.isSelected());
            Platform.getMainWindow().updateShow();
            return;
        }
        if (actionEvent.getSource() == this.channelMeasCurrOn) {
            IChannel iChannel = this.cp.getCurrentChannel();
            boolean bl = this.channelMeasCurrOn.isSelected();
            this.turnMeasureCurrentOn(iChannel, bl);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.listening) {
            return;
        }
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (itemEvent.getSource() == this.probecbb) {
            IChannel iChannel = this.cp.getCurrentChannel();
            int n = this.probecbb.getSelectedIndex();
            iChannel.setProbeMultiIdx(n);
            this.cm.updateChannelVoltValueEverywhere(iChannel.getNumber());
            return;
        }
        if (itemEvent.getSource() == this.couplingcbb) {
            IChannel iChannel = this.cp.getCurrentChannel();
            iChannel.c_setCoupling(this.couplingcbb.getSelectedIndex());
            Platform.getMainWindow().getToolPane().updateChannels();
            return;
        }
    }

    protected void loadCurrentChannel(int n) {
        this.listening = false;
        this.cp.setCurrentChannelPageIndex(n);
        IChannel iChannel = this.cp.getCurrentChannel();
        boolean bl = iChannel.isOn();
        this.showChannelDetail(bl);
        this.rbg.setSelected(n);
        this.channelOption.setSelected(bl);
        if (this.bandLimit) {
            if (iChannel.isForcebandlimit()) {
                this.ebs.setFinalSelected(0);
            } else {
                this.ebs.undoFinalSelected(iChannel.isBandlimit() ? 0 : 1);
            }
        }
        this.channelOpposite.setSelected(iChannel.isInverse());
        this.probecbb.setSelectedIndex(iChannel.getProbeMultiIdx());
        this.filterslider.setValue(iChannel.getFilterIdx());
        this.couplingcbb.setSelectedIndex(iChannel.getCouplingIdx());
        Color color = this.cp.getChannelNames()[n].ci.getColor();
        this.colorbt.setBackground(color);
        boolean bl2 = iChannel.isMeasureCurrent();
        this.channelMeasCurrOn.setSelected(bl2);
        this.turnMeasureCurrentOn(iChannel, bl2);
        this.amp.setValue(iChannel.getAmperePerVolt());
        this.listening = true;
    }

    protected void turnMeasureCurrentOn(IChannel iChannel, boolean bl) {
        ChannelInfo channelInfo = (ChannelInfo)iChannel;
        channelInfo.setMeasureCurrent(bl);
        this.MeasCurrPane.setVisible(bl);
        this.cm.mcctr.computeYValues();
        DataHouse dataHouse = Platform.getDataHouse();
        Platform.getMainWindow().channelOnOffRepaint(dataHouse.getWaveFormManager().getWaveForm(channelInfo.getNumber()));
    }

    protected void setAmperePerVolt(int n) {
        ChannelInfo channelInfo = (ChannelInfo)this.cp.getCurrentChannel();
        channelInfo.setAmperePerVolt(n);
        this.cm.mcctr.computeYValues();
        DataHouse dataHouse = Platform.getDataHouse();
        Platform.getMainWindow().channelOnOffRepaint(dataHouse.getWaveFormManager().getWaveForm(channelInfo.getNumber()));
    }

    protected void updateFilterLabel() {
        int n = this.filterslider.getValue();
        int n2 = this.cp.getCurrentChannel().getNumber();
        ChannelInfo channelInfo = this.cm.getWaveFormInfoControl().getWaveFormChannelInfo(n2);
        this.filterlabel.setText(channelInfo.getFilterLabel());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.listening) {
            return;
        }
        this.listening = false;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("APPLY_CHANNELS")) {
            IChannel iChannel = this.cp.getCurrentChannel();
            this.loadCurrentChannel(iChannel.getNumber());
            return;
        }
        if (string.equals("CHOOSE_CHANNELS")) {
            this.loadCurrentChannel(this.cp.getSelectedChannelIndex());
            return;
        }
        if (string.equals("ChannelOption")) {
            IChannel iChannel = this.cp.getCurrentChannel();
            this.channelOption.setSelected(iChannel.isOn());
            this.showChannelDetail(iChannel.isOn());
        } else if (string.equals("CouplingOption")) {
            IChannel iChannel = this.cp.getCurrentChannel();
            this.couplingcbb.setSelectedIndex(iChannel.getCouplingIdx());
        } else if (string.equals("ChannelOpposite")) {
            IChannel iChannel = this.cp.getCurrentChannel();
            this.channelOpposite.setSelected(iChannel.isInverse());
        } else if (string.equals("PROBECHANGE")) {
            IChannel iChannel = this.cp.getCurrentChannel();
            this.probecbb.setSelectedIndex(iChannel.getProbeMultiIdx());
        } else if (string.equals("APPLY_SAMPLING")) {
            int n = this.sc.getModelIdx();
            this.samplingcbb.setSelectedIndex(n);
            this.avgTimes.setValue(this.sc.getAvgTimes());
            this.showAvg(n);
        } else if (string.equals("MACHINETYPE_CHANGE")) {
            if (this.syoccb != null) {
                this.listening = false;
                this.syoccb.setModel(new ListComboBoxModel(this.cm.getSyncInOuts()));
                this.listening = true;
            }
        } else if (string.equals("SYNCOUTPUTCHANGE")) {
            if (this.syoccb != null) {
                this.listening = false;
                this.syoccb.setSelectedIndex(this.cm.getSysControl().getSyncOutput());
                this.syoccb.repaint();
                this.listening = true;
            }
        } else if (string.equals("onTimebaseUpdated")) {
            this.updateFilterLabel();
        }
        this.listening = true;
    }

    protected void showAvg(int n) {
        boolean bl = n == 2;
        this.ip2.setVisible(bl);
        this.ip1.setVisible(bl);
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        if (this.syoccb != null) {
            this.syoccb.repaint();
        }
        super.localize(resourceBundle);
    }
}

