/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view;

import com.owon.uppersoft.dso.function.perspective.CompositeWaveForm;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.util.ui.FloatGlassP;
import com.owon.uppersoft.dso.view.sub.InfoBlock;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.measure.MeasureElem;
import com.owon.uppersoft.vds.core.measure.MeasureModel;
import com.owon.uppersoft.vds.core.measure.MeasureT;
import com.owon.uppersoft.vds.core.measure.VR;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class ValuePane
extends JPanel
implements PropertyChangeListener,
MouseInputListener {
    private VR[] vrs;
    private WaveFormManager wfm;
    public MeasureModel measMod;
    private final String MsgKeyPrefix = "AutoMeasure.";
    private ControlManager cm;
    private boolean mouseOver;
    private boolean dragDelete;
    private Icon addbtnImg;
    private Icon minusbtnImg;
    private final String addPath = "/com/owon/uppersoft/dso/image/add.png";
    private final String minusPath = "/com/owon/uppersoft/dso/image/minus.png";
    private final int ROWGAP = 15;
    private final int COLGAP = 95;
    private final int HalfCOLGAP = 47;
    private final int inorc = 24;
    private int selCol = -1;
    private int dragTarget = -1;
    public static final int Height = 90;
    private final Color textColor = new Color(230, 230, 230);
    private JPanel gp;
    private FloatGlassP seljf;
    boolean isSelFrameOn = false;

    public ValuePane(DataHouse dataHouse) {
        this.setOpaque(false);
        this.wfm = dataHouse.getWaveFormManager();
        this.cm = dataHouse.controlManager;
        this.measMod = dataHouse.controlManager.measMod;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addbtnImg = SwingResourceManager.getIcon(InfoBlock.class, "/com/owon/uppersoft/dso/image/add.png");
        this.minusbtnImg = SwingResourceManager.getIcon(InfoBlock.class, "/com/owon/uppersoft/dso/image/minus.png");
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("RefreshMeasureResult")) {
            this.repaint();
        }
    }

    private String getMeasureType(int n, ResourceBundle resourceBundle) {
        String string = "AutoMeasure." + (Object)((Object)MeasureT.VALUES[n]);
        String string2 = resourceBundle.getString(string);
        string2 = SFormatter.getRestrictSubString(string2, 12);
        return string2;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        boolean bl;
        Integer n7;
        Object n6;
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl2 = this.measMod.isCHlinkEmpty();
        boolean bl3 = !bl2;
        graphics.setColor(this.textColor);
        int n2 = 5;
        int n3 = 15;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setFont(graphics.getFont().deriveFont(AffineTransform.getScaleInstance(1.2, 1.2)));
        if (this.mouseOver) {
            this.addbtnImg.paintIcon(null, graphics, 15, 2);
        }
        graphics.drawString("", n2, n3);
        ResourceBundle resourceBundle = I18nProvider.bundle();
        for (Integer object22 : this.measMod.MTlinked) {
            n6 = this.getMeasureType(object22, resourceBundle);
            n2 = object22.equals(this.measMod.MTlinked.getFirst()) ? (n2 += 47) : (n2 += 95);
            if (!bl3) continue;
            graphics.drawString((String)n6, n2, n3);
        }
        if (this.measMod.getOthLinkedCount() > 0) {
            int n4 = bl3 ? n2 + 190 : 95;
            graphics.drawString(resourceBundle.getString("AutoMeasure.Delay"), n4, n3);
        }
        n3 += 15;
        WaveFormInfoControl waveFormInfoControl = this.wfm.getWaveFormInfoControl();
        Iterator<WaveForm> iterator = waveFormInfoControl.getLowMachineWFIterator();
        while (iterator.hasNext()) {
            n6 = iterator.next();
            n2 = 10;
            this.vrs = ((WaveForm)n6).getMeasureADC().vrs;
            n7 = ((WaveForm)n6).wfi.ci.getNumber();
            bl = ((WaveForm)n6).isOn();
            if (!this.measMod.hasCHlinkElem(n7)) continue;
            graphics.drawString(((WaveForm)n6).toString(), n2, n3);
            n2 = 5;
            for (Integer n : this.measMod.MTlinked) {
                n2 = n.equals(this.measMod.MTlinked.getFirst()) ? (n2 += 47) : (n2 += 95);
                int n4 = n;
                if (bl) {
                    graphics.drawString(this.vrs[n4].vu, n2, n3);
                    continue;
                }
                graphics.drawString("--", n2, n3);
            }
            n3 += 15;
        }
        if (this.cm.mathControl.mathon) {
            n2 = 10;
            n6 = this.wfm.getCompositeWaveForm();
            this.vrs = ((CompositeWaveForm)n6).getMeasureADC().vrs;
            n7 = ((CompositeWaveForm)n6).getNumber();
            boolean bl4 = bl = ((CompositeWaveForm)n6).isOn() && this.wfm.getM1().isOn() && this.wfm.getM2().isOn();
            if (this.measMod.hasCHlinkElem(n7)) {
                graphics.drawString(((CompositeWaveForm)n6).toString(), n2, n3);
                n2 = 5;
                for (Integer n : this.measMod.MTlinked) {
                    n2 = n.equals(this.measMod.MTlinked.getFirst()) ? (n2 += 47) : (n2 += 95);
                    if (bl) {
                        graphics.drawString(this.vrs[n.intValue()].vu, n2, n3);
                        continue;
                    }
                    graphics.drawString("--", n2, n3);
                }
                n3 += 15;
            }
        }
        if (this.measMod.getOthLinkedCount() > 0) {
            int n = bl3 ? 95 * this.measMod.MTlinked.size() - 40 : -50;
            int n8 = 30;
            for (MeasureElem measureElem : this.measMod.othMTlinked) {
                if (!measureElem.on) continue;
                String string2 = resourceBundle.getString(measureElem.label);
                string2 = SFormatter.getRestrictSubString(string2, 12);
                if (waveFormInfoControl.isSupportDelay1_2()) {
                    graphics.drawString(string2 + ":  " + measureElem.vu, n + 95, n8);
                } else {
                    graphics.drawString(string2 + ":  --", n + 95, n8);
                }
                if (this.measMod.othMTlinked.size() > 2 && this.measMod.othMTlinked.size() <= 4) {
                    if (waveFormInfoControl.isSupportDelay3_4()) {
                        graphics.drawString(string2 + ":  " + measureElem.vu, n + 95, n8);
                    } else {
                        graphics.drawString(string2 + ":  --", n + 95, n8);
                    }
                }
                n8 += 15;
            }
        }
        if (bl2 && !this.measMod.MTlinked.isEmpty()) {
            graphics.drawString(resourceBundle.getString("M.Measure.UncheckedCHs"), 50, 40);
        }
        if (this.dragTarget != -1 || this.selCol != -1) {
            int n = this.getHeight();
            int n5 = this.getselColLocation(this.selCol);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics2D.setColor(Define.def.style.CO_DockContainer);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fillRoundRect(n5, 0, 91, n - 8, 24, 24);
            graphics2D.drawRoundRect(n5, 0, 91, n - 8, 24, 24);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (this.dragDelete) {
                this.minusbtnImg.paintIcon(null, graphics, n5 + 95 - 20, 0);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        boolean bl;
        if (this.measMod.isCHlinkEmpty() || this.measMod.isMTlinkEmpty()) {
            return;
        }
        int n2 = mouseEvent.getY();
        boolean bl2 = bl = n2 < 0 || n2 > this.getHeight();
        if (this.dragDelete != bl) {
            this.dragDelete = bl;
            this.repaint();
        }
        if ((n = this.getPointColumn(mouseEvent.getX())) != this.dragTarget) {
            this.cm.measMod.moveMtElem(this.selCol, n);
            this.selCol = this.dragTarget = n;
            this.repaint();
        }
        this.moveGlassPaneAmongValuePane(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.doMouseAction('M', mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.doMouseAction('C', mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.measMod.isCHlinkEmpty() || this.measMod.isMTlinkEmpty()) {
            return;
        }
        int n = mouseEvent.getX();
        this.selCol = this.getPointColumn(n);
        this.repaint();
        this.initGlassPane();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragDelete) {
            this.cm.measMod.removeSelCol(this.selCol);
            this.cm.pcs.firePropertyChange("refresh_MeasurePane_Selected", null, null);
            this.dragDelete = false;
        }
        this.releaseSelect();
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.repaint();
    }

    private void openHideMeasurePane() {
        this.cm.getDockControl().dockDialogQuickOpenHide("M.Measure.Name");
    }

    private int getPointColumn(int n) {
        int n2 = -1;
        if (n > 47 && n < 95) {
            n2 = 0;
        } else if (n > 95 && ((n2 = (n -= 47) / 95) > this.measMod.getColumnMax() - 1 || n2 > this.measMod.getColumnCount() - 1)) {
            n2 = -1;
        }
        return n2;
    }

    private int getselColLocation(int n) {
        return 47 + n * 95;
    }

    private void releaseSelect() {
        this.releaseGlassPane();
        this.dragTarget = -1;
        this.selCol = -1;
    }

    private void initGlassPane() {
        this.gp = Platform.getMainWindow().getGlassPane();
        if (this.isSelFrameOn && this.selCol >= 0) {
            Point point = this.getselColScreenLocation(this.selCol);
            int n = this.getHeight();
            this.seljf = new FloatGlassP(point.x, point.y, 95, n);
            this.gp.add(this.seljf);
            this.gp.setVisible(true);
        }
    }

    private void moveGlassPaneAmongValuePane(MouseEvent mouseEvent) {
        if (this.isSelFrameOn) {
            if (this.seljf == null) {
                return;
            }
            int n = mouseEvent.getX() - (this.seljf.getWidth() >> 1);
            int n2 = this.seljf.getY();
            int n3 = 47;
            int n4 = n3 + this.measMod.getColumnCount() * 95 - this.seljf.getWidth();
            if (n < n3) {
                n = n3;
            }
            if (n > n4) {
                n = n4;
            }
            this.seljf.setLocation(n, n2);
        }
    }

    private void releaseGlassPane() {
        if (this.isSelFrameOn && this.seljf != null) {
            this.gp.remove(this.seljf);
            this.gp.setVisible(false);
        }
    }

    private Point getselColScreenLocation(int n) {
        int n2 = 0;
        int n3 = 0;
        Point point = new Point(0, 0);
        n2 = point.x + (47 + n * 95);
        n3 = point.y + 557;
        return new Point(n2, n3);
    }

    private void doMouseAction(char c, int n, int n2) {
        boolean bl = n < 42 && n2 < 16;
        switch (c) {
            case 'M': {
                if (bl) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 'C': {
                if (!bl) break;
                this.openHideMeasurePane();
            }
        }
    }
}

