/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.ValuePane;
import com.owon.uppersoft.dso.view.sub.ButtonPane;
import com.owon.uppersoft.dso.view.sub.DetailPane;
import com.owon.uppersoft.dso.view.sub.InfoPane;
import com.owon.uppersoft.dso.view.sub.TriggerInfoPane;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.ui.layout.OneRowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class ToolPane
extends JPanel
implements Localizable,
PropertyChangeListener {
    private static final long serialVersionUID = 3517025707687469125L;
    private InfoPane infoPane;
    private TriggerInfoPane trginfoPane;
    private ControlManager cm;
    private ButtonPane buttonPane;
    private DetailPane detailPane;
    private ValuePane valuePane;
    private DataHouse dh;
    private JPanel logP;

    public ToolPane(MainWindow mainWindow, Dimension dimension, ControlManager controlManager) {
        this.cm = controlManager;
        this.dh = mainWindow.getDataHouse();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.BLACK);
        jPanel.setLayout(new OneColumnLayout());
        this.valuePane = new ValuePane(this.dh);
        this.valuePane.setPreferredSize(new Dimension(0, 90));
        jPanel.add(this.valuePane);
        this.infoPane = new InfoPane(this.dh);
        this.infoPane.setPreferredSize(new Dimension(0, 82));
        jPanel.add(this.infoPane);
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setPreferredSize(new Dimension(254, 0));
        jPanel2.setLayout(new OneColumnLayout());
        this.buttonPane = this.createButtonPane(mainWindow, controlManager);
        this.buttonPane.setPreferredSize(new Dimension(0, 70));
        jPanel2.add(this.buttonPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(new Dimension(0, 103));
        jPanel3.setLayout(new OneRowLayout());
        this.detailPane = new DetailPane(this.dh);
        this.detailPane.setPreferredSize(new Dimension(126, 0));
        jPanel3.add(this.detailPane);
        this.trginfoPane = new TriggerInfoPane(this.dh);
        this.trginfoPane.setPreferredSize(new Dimension(128, 0));
        jPanel3.add(this.trginfoPane);
        jPanel2.add(jPanel3);
        this.add((Component)jPanel2, "East");
        this.logP = new JPanel(){};
        this.logP.setBackground(Color.red);
        controlManager.pcs.addPropertyChangeListener(this);
        this.updateChannels();
        this.updateTrgVolt();
    }

    protected ButtonPane createButtonPane(MainWindow mainWindow, ControlManager controlManager) {
        return new ButtonPane(mainWindow, controlManager, this.dh);
    }

    public TriggerInfoPane getTrgInfoPane() {
        return this.trginfoPane;
    }

    public void updateAfterData() {
        this.infoPane.updateFreqs();
        this.logP.repaint();
    }

    public void updateChannels() {
        this.infoPane.updateInfos(this.dh.getWaveFormManager());
    }

    public void updateTrgVolt() {
        this.trginfoPane.updateInfos(this.dh.controlManager.getTriggerControl());
    }

    public void updateDetail() {
        this.detailPane.updateInfo();
        this.detailPane.repaint();
    }

    public ButtonPane getButtonPane() {
        return this.buttonPane;
    }

    public InfoPane getInfoPane() {
        return this.infoPane;
    }

    public DetailPane getDetailPane() {
        return this.detailPane;
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.detailPane.localize(resourceBundle);
        this.buttonPane.localize(resourceBundle);
        this.trginfoPane.localize(resourceBundle);
        this.infoPane.localize(resourceBundle);
        this.dh.localize(resourceBundle);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.detailPane.propertyChange(propertyChangeEvent);
        this.buttonPane.propertyChange(propertyChangeEvent);
        this.trginfoPane.propertyChange(propertyChangeEvent);
        this.infoPane.propertyChange(propertyChangeEvent);
        this.valuePane.propertyChange(propertyChangeEvent);
    }
}

