/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.source.comm.InfiniteDaemon;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;

public class TitleStatusLabel
extends JLabel
implements MouseListener {
    private int status_icon_xloc = 0;
    private int counter = 0;
    private boolean overstatus = false;
    private TrgStatus ts = TrgStatus.Offline;
    private boolean tempStatus = false;

    public TitleStatusLabel(int n) {
        this.status_icon_xloc = n;
        this.setForeground(Define.def.CO_DockFore);
        this.setHorizontalAlignment(0);
        this.setFont(Define.def.commonStatusfont);
        this.setPreferredSize(new Dimension(140, 25));
        this.addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        if (Platform.getControlApps() == null) {
            return;
        }
        InfiniteDaemon infiniteDaemon = Platform.getControlApps().getDaemon();
        infiniteDaemon.onClickStatus(this.status_icon_xloc, n);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.overstatus) {
            this.overstatus = true;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.overstatus) {
            this.overstatus = false;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public TrgStatus getTrgStatus() {
        return this.ts;
    }

    public void setTempStatus(boolean bl) {
        TrgStatus trgStatus;
        this.tempStatus = bl;
        if (!bl) {
            trgStatus = this.ts;
        } else {
            this.setForeground(Color.WHITE);
            trgStatus = TrgStatus.AutoSetting;
        }
        this.setText(trgStatus.toString());
        this.repaint();
    }

    public void updateTrgStatus(int n, TrgStatus trgStatus) {
        this.ts = trgStatus;
        if (trgStatus.equals((Object)TrgStatus.Stop)) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(Color.WHITE);
        }
        String string = trgStatus.toString();
        if (!this.tempStatus) {
            this.setText(string);
        }
        int n2 = this.counter;
        this.counter = Math.abs(n);
        if (n2 != this.counter && !this.tempStatus) {
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRoundRect(5, 5, n - 10, n2 - 10, 15, 15);
        if (this.overstatus) {
            graphics2D.setColor(Color.ORANGE);
            graphics2D.setStroke(Define.def.Stroke2);
            graphics2D.drawRoundRect(5, 5, n - 10, n2 - 10, 15, 15);
        }
        super.paintComponent(graphics);
        if (this.counter > 0) {
            graphics2D.setColor(Color.RED);
            graphics2D.fillOval(n - 12, 6, 10, 10);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawOval(n - 12, 6, 10, 10);
            graphics2D.setFont(Define.def.statusCounterfont);
            graphics2D.drawString(String.valueOf(this.counter), n - 9, 15);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void localize(ResourceBundle resourceBundle) {
        this.setFont(FontCenter.getLabelFont());
        this.setToolTipText(resourceBundle.getString("ToolTip.Statuslbl"));
    }
}

