/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view;

import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.source.comm.AbsInterCommunicator;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.view.ITitleStatus;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.RSLButton;
import com.owon.uppersoft.dso.view.StorageView;
import com.owon.uppersoft.dso.view.TitleStatusLabel;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.pref.StaticPref;
import com.owon.uppersoft.vds.ui.layout.OneRowLayout;
import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.widget.custom.CLButton;
import com.owon.uppersoft.vds.ui.window.ComponentMover;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TitlePane
extends JPanel
implements Localizable,
ITitleStatus,
PropertyChangeListener {
    public static final String RunPath = "/com/owon/uppersoft/dso/image/run.png";
    public static final String StopPath = "/com/owon/uppersoft/dso/image/stop.png";
    public static final String AutosetPath = "/com/owon/uppersoft/dso/image/autoset.png";
    public static final String SinglePath = "/com/owon/uppersoft/dso/image/single.png";
    private static final long serialVersionUID = -471832215692573020L;
    private MainWindow mw;
    private DataHouse dh;
    private Dimension iconsize = new Dimension(32, 24);
    private StorageView view;
    private TitleStatusLabel statuslbl;
    private RSLButton btnRS;
    private CLButton btnAutoset;
    private CLButton btnSingle;
    private boolean run;
    private ImageIcon ri;
    private ImageIcon si;
    private ControlManager cm;

    public StorageView getStorageView() {
        return this.view;
    }

    public TitlePane(MainWindow mainWindow, Dimension dimension) {
        this.mw = mainWindow;
        this.dh = mainWindow.getDataHouse();
        this.cm = this.dh.controlManager;
        this.setPreferredSize(dimension);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createLeftPane();
        this.add((Component)jPanel, "West");
        this.view = new StorageView(this.dh);
        this.add((Component)this.view, "Center");
        JPanel jPanel2 = this.createRightPane();
        this.add((Component)jPanel2, "East");
        new ComponentMover(mainWindow.getFrame(), this);
        I18nProvider.LocalizeSelf(this);
        this.cm.pcs.addPropertyChangeListener(this);
    }

    private JPanel createLeftPane() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new OneRowLayout(5));
        JLabel jLabel = new JLabel();
        int n = 10;
        StaticPref staticPref = this.cm.getConfig().getStaticPref();
        Icon icon = staticPref.getLogoIcon(staticPref);
        this.statuslbl = new TitleStatusLabel(n);
        this.cm.bufferTitleStatus(this.statuslbl);
        jPanel.add(this.statuslbl);
        this.updateTrgStatus(TrgStatus.Offline);
        return jPanel;
    }

    @Override
    public void exposeTrgStatus() {
        this.statuslbl.repaint();
    }

    @Override
    public void updateTrgStatus(int n, TrgStatus trgStatus) {
        this.statuslbl.updateTrgStatus(n, trgStatus);
    }

    @Override
    public void setTempStatus(boolean bl) {
        this.statuslbl.setTempStatus(bl);
    }

    @Override
    public void updateTrgStatus(TrgStatus trgStatus) {
        this.updateTrgStatus(0, trgStatus);
    }

    public TrgStatus getTrgStatus() {
        return this.statuslbl.getTrgStatus();
    }

    @Override
    public void confirmStopStatus() {
        this.enableBtns();
    }

    @Override
    public void enableBtns() {
        this.btnRS.setEnabled(true);
    }

    @Override
    public void enableAllButtons(boolean bl) {
        this.btnRS.setEnabled(bl);
        this.btnAutoset.setEnabled(bl);
        if (!bl) {
            this.btnSingle.setEnabled(false);
        } else {
            this.updateBtnSingle();
        }
        this.cm.updateExportbtnEnable(bl);
    }

    private void askStop(boolean bl) {
        this.getAbsInterCommunicator().statusStop(bl);
    }

    private void askRun(boolean bl) {
        this.getAbsInterCommunicator().statusRun(bl, true);
    }

    @Override
    public void askSweepOnce() {
        if (!this.run) {
            this.getAbsInterCommunicator().statusRun(false, false);
            this.run = true;
        }
        ControlApps controlApps = this.dh.getControlApps();
        controlApps.stopkeepNForbidDM();
        TriggerControl triggerControl = this.cm.getTriggerControl();
        triggerControl.trySweepOnce();
        controlApps.keepload();
        this.cm.getWaveFormInfoControl().releaseWF();
        this.mw.getChartScreen().re_paint();
    }

    public void askSweepNormal() {
        if (!this.run) {
            this.getAbsInterCommunicator().statusRun(false, false);
            this.run = true;
        }
        ControlApps controlApps = this.dh.getControlApps();
        controlApps.stopkeepNForbidDM();
        TriggerControl triggerControl = this.cm.getTriggerControl();
        if (triggerControl.isSweepNormal()) {
            triggerControl.trySweepAuto();
        } else {
            triggerControl.trySweepNormal();
        }
        controlApps.keepload();
        this.cm.getWaveFormInfoControl().releaseWF();
        this.mw.getChartScreen().re_paint();
    }

    @Override
    public boolean switchRS() {
        if (this.run) {
            this.askStop(false);
            this.dh.getWaveFormManager().retainClosedWaveForms();
            return false;
        }
        boolean bl = this.cm.playCtrl.confirmGoOnPlaying();
        if (bl) {
            return false;
        }
        TimeControl timeControl = this.cm.getTimeControl();
        timeControl.dosubmit();
        if (this.dh.isParaAsync()) {
            this.cm.initDetail(SubmitorFactory.reInit());
        }
        this.askRun(true);
        return true;
    }

    public void switchSingle_Run() {
        if (this.run) {
            this.askSweepOnce();
        } else {
            boolean bl = this.cm.playCtrl.confirmGoOnPlaying();
            if (bl) {
                return;
            }
            if (this.dh.isParaAsync()) {
                this.cm.initDetail(SubmitorFactory.reInit());
            }
            this.askRun(true);
        }
    }

    public void doAutoset() {
        this.getAbsInterCommunicator().autoset();
    }

    private AbsInterCommunicator getAbsInterCommunicator() {
        return Platform.getControlApps().interComm;
    }

    public void askSwitchRS() {
        this.btnRS.askSwitchRS();
    }

    private JPanel createRightPane() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new OneRowLayout());
        this.btnAutoset = new CLButton();
        ImageIcon imageIcon = SwingResourceManager.getIcon(TitlePane.class, AutosetPath);
        this.btnAutoset.setEnabled(false);
        this.btnAutoset.setIcon(imageIcon);
        this.btnAutoset.setPressedIcon(LineDrawTool.getRolloverIcon(imageIcon));
        this.btnAutoset.setDisabledIcon(LineDrawTool.getDisabledIcon(imageIcon));
        jPanel.add(this.btnAutoset);
        this.btnAutoset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TitlePane.this.doAutoset();
            }
        });
        this.btnAutoset.setPreferredSize(new Dimension(35, 32));
        this.btnRS = new RSLButton(this);
        this.si = SwingResourceManager.getIcon(TitlePane.class, StopPath);
        this.ri = SwingResourceManager.getIcon(TitlePane.class, RunPath);
        this.btnRS.setEnabled(false);
        this.btnRS.setIcon(this.si);
        this.btnRS.setDisabledIcon(LineDrawTool.getDisabledIcon(this.ri));
        this.btnRS.setPreferredSize(new Dimension(35, 32));
        this.btnSingle = new CLButton();
        imageIcon = SwingResourceManager.getIcon(TitlePane.class, SinglePath);
        this.btnSingle.setEnabled(false);
        this.btnSingle.setIcon(imageIcon);
        this.btnSingle.setPressedIcon(LineDrawTool.getRolloverIcon(imageIcon));
        this.btnSingle.setDisabledIcon(LineDrawTool.getDisabledIcon(imageIcon));
        this.btnSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TitlePane.this.askSweepOnce();
            }
        });
        this.btnSingle.setPreferredSize(new Dimension(35, 32));
        this.updateBtnSingle();
        jPanel.add(this.btnRS);
        jPanel.add(this.btnSingle);
        return jPanel;
    }

    @Override
    public void applyStop() {
        this.run = false;
        this.btnRS.setIcon(this.ri);
        this.btnRS.setRolloverIcon(LineDrawTool.getRolloverIcon(this.ri));
    }

    @Override
    public void updateView() {
        this.view.repaint();
        this.updateBtnSingle();
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.view.localize(resourceBundle);
        this.statuslbl.localize(resourceBundle);
        this.btnAutoset.setToolTipText(resourceBundle.getString("ToolTip.AutoSet"));
        this.btnSingle.setToolTipText(resourceBundle.getString("ToolTip.SingleTrig"));
        this.btnRS.setToolTipText(resourceBundle.getString("ToolTip.RS"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("FFT_ON")) {
            this.updateBtnSingle();
        } else if (string.equals("FFT_OFF")) {
            this.updateBtnSingle();
        } else if (string.equals("SwitchSlowMove")) {
            this.updateBtnSingle();
        } else if (string.equals("OPERATE_RUN")) {
            this.run = true;
            this.enableAllButtons(true);
            this.btnRS.setIcon(this.si);
            this.btnRS.setRolloverIcon(LineDrawTool.getRolloverIcon(this.si));
        } else if (string.equals("OPERATE_STOP")) {
            this.run = false;
            this.enableAllButtons(this.cm.sourceManager.isConnected());
            this.btnRS.setIcon(this.ri);
            this.btnRS.setRolloverIcon(LineDrawTool.getRolloverIcon(this.ri));
        } else if (string.equals("START_AUTOSET")) {
            this.statuslbl.setTempStatus(true);
            this.enableAllButtons(false);
        } else if (string.equals("STOP_AUTOSET")) {
            this.setTempStatus(false);
            this.enableAllButtons(true);
            this.updateView();
        }
    }

    public void updateBtnSingle() {
        if (!this.cm.sourceManager.isConnected()) {
            this.btnSingle.setEnabled(false);
            return;
        }
        if (!this.cm.getTriggerControl().isSingleTrg()) {
            this.btnSingle.setEnabled(false);
            return;
        }
        if (this.cm.getFFTControl().isFFTon()) {
            this.btnSingle.setEnabled(false);
            return;
        }
        if (this.cm.getCoreControl().isRunMode_slowMove()) {
            this.btnSingle.setEnabled(true);
            return;
        }
        this.btnSingle.setEnabled(true);
    }
}

