/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.pane.dock.widget.TitleBar;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.ui.layout.OneRowLayout;
import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import com.owon.uppersoft.vds.ui.resource.FontCenter;
import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import com.owon.uppersoft.vds.ui.widget.custom.LButton;
import com.owon.uppersoft.vds.ui.window.ComponentMover;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class TipsWindow
implements Localizable {
    private static TipsWindow instance;
    private JDialog tipsDlg;
    private CLabel title;
    private CCheckBox hiddenCb;
    private final int windowWidth = 600;
    private final int windowHeight = 580;
    private final int titlePaneHeight = 40;
    private final int basePaneHeight = 540;
    private final int arcOut = 15;
    private final int arcIn = 14;
    private final int titlelblWidth = 330;
    private final int titleHeight = 15;
    private static final Color Co_Title;
    private static final Color Co_Tabbed;
    private static final Color Co_Content;
    private static final Color Co_EditorPaneBG;
    private String locale;
    private final String CHLHTML = "chl1.htm";
    private final String DETHTML = "per1.htm";
    private final String TRGHTML = "trg1.htm";
    private final String SCUTSHTML = "shortcuts.htm";
    private ControlManager cm;
    private String chlbl;
    private String dtlbl;
    private String trglbl;
    private String stclbl;
    private JTabbedPane tbp;
    private JEditorPane chlp;
    private JEditorPane detp;
    private JEditorPane trgp;
    private JEditorPane stcp;

    public static void show(MainWindow mainWindow, ControlManager controlManager) {
        TipsWindow.show(mainWindow, controlManager, 0);
    }

    public static void show(MainWindow mainWindow, ControlManager controlManager, int n) {
        if (instance == null || !TipsWindow.instance.tipsDlg.isDisplayable()) {
            instance = new TipsWindow(mainWindow);
            controlManager.getLocalizeCenter().addLocalizable(instance);
        }
        TipsWindow.instance.tbp.setSelectedIndex(n);
        TipsWindow.instance.tipsDlg.toFront();
    }

    public TipsWindow(MainWindow mainWindow) {
        this.cm = mainWindow.getDataHouse().controlManager;
        this.creatDlg(mainWindow);
        this.init();
        new ComponentMover(this.tipsDlg, this.tipsDlg);
        WindowUtil.cutCorners(this.tipsDlg, 15);
    }

    private void creatDlg(MainWindow mainWindow) {
        this.tipsDlg = new JDialog((Frame)mainWindow.getFrame(), false);
        this.tipsDlg.setSize(600, 580);
        this.tipsDlg.setType(Window.Type.UTILITY);
        this.tipsDlg.setLayout(new BorderLayout());
        this.tipsDlg.setUndecorated(true);
        this.tipsDlg.setResizable(false);
        this.tipsDlg.setLocationRelativeTo(mainWindow.getFrame());
        this.tipsDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TipsWindow.this.close();
            }
        });
    }

    private void init() {
        JPanel jPanel = this.getTitlePane();
        JPanel jPanel2 = this.getBasePane();
        this.tipsDlg.add((Component)jPanel, "North");
        this.tipsDlg.add((Component)jPanel2, "Center");
        this.localize(I18nProvider.bundle());
        this.tipsDlg.setDefaultCloseOperation(2);
        this.tipsDlg.setVisible(true);
    }

    private JPanel getTitlePane() {
        JPanel jPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Co_Tabbed);
                graphics2D.setStroke(Define.def.Stroke2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawRoundRect(1, 1, n - 3, n2 + 15, 15, 15);
                graphics2D.setPaint(TitleBar.GradientTexturePaint);
                graphics2D.fillRoundRect(2, 2, n - 4, n2 + 14, 14, 14);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        jPanel.setLayout(new OneRowLayout(new Insets(5, 15, 5, 10), 0));
        jPanel.setPreferredSize(new Dimension(600, 40));
        int n = 240;
        int n2 = 200;
        int n3 = 24;
        int n4 = 600 - n - n2 - n3 - 25;
        ImageIcon imageIcon = SwingResourceManager.getIcon(TipsWindow.class, "/com/owon/uppersoft/dso/image/light.png");
        this.title = new CLabel();
        this.title.setIcon(imageIcon);
        this.title.setPreferredSize(new Dimension(n, 40));
        this.hiddenCb = new CCheckBox();
        this.hiddenCb.setPreferredSize(new Dimension(n2, 15));
        this.hiddenCb.setSelected(!this.cm.istipsWindowShow);
        this.hiddenCb.setForeground(Color.WHITE);
        this.hiddenCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = TipsWindow.this.hiddenCb.isSelected();
                boolean bl2 = ((TipsWindow)TipsWindow.this).cm.istipsWindowShow = !bl;
                if (bl) {
                    TipsWindow.this.close();
                }
            }
        });
        ImageIcon imageIcon2 = SwingResourceManager.getIcon(TipsWindow.class, "/com/owon/uppersoft/dso/image/close.png");
        LButton lButton = new LButton();
        lButton.setIcon(imageIcon2);
        lButton.setPressedIcon(LineDrawTool.getRolloverIcon(imageIcon2));
        lButton.setPreferredSize(new Dimension(n3, 24));
        lButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TipsWindow.this.close();
            }
        });
        jPanel.add((Component)this.title, "East");
        jPanel.add(this.hiddenCb);
        jPanel.add(Box.createHorizontalStrut(n4));
        jPanel.add(lButton);
        return jPanel;
    }

    private JPanel getBasePane() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(600, 540));
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        JPanel jPanel2 = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Co_Tabbed);
                graphics2D.setStroke(Define.def.Stroke2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawRoundRect(1, -15, n - 3, n2 + 15 - 3, 15, 15);
                graphics2D.fillRoundRect(2, -14, n - 2, n2 + 14 - 2, 14, 14);
            }
        };
        jPanel2.setBackground(Co_Tabbed);
        this.tbp = new JTabbedPane();
        this.tbp.setPreferredSize(new Dimension(590, 530));
        this.chlp = TipsWindow.addHtmlTab(this.tbp, 21);
        this.detp = TipsWindow.addHtmlTab(this.tbp, 21);
        this.trgp = TipsWindow.addHtmlTab(this.tbp, 21);
        this.stcp = TipsWindow.addHtmlTab(this.tbp, 22);
        jPanel2.add(this.tbp);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private static JEditorPane addHtmlTab(JTabbedPane jTabbedPane, int n) {
        final JEditorPane jEditorPane = new JEditorPane(){

            @Override
            public void paint(Graphics graphics) {
                if (graphics instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    super.paint(graphics2D);
                    graphics2D.dispose();
                } else {
                    super.paint(graphics);
                }
            }
        };
        jEditorPane.setSelectionColor(Co_EditorPaneBG);
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setFocusable(false);
        jEditorPane.setBackground(Co_Content);
        jEditorPane.setBorder(BorderFactory.createEmptyBorder());
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){
            private final JEditorPane _edp;
            {
                this._edp = jEditorPane;
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        this._edp.setPage(hyperlinkEvent.getURL());
                        this._edp.repaint();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        jEditorPane.setCaret(new DefaultCaret(){

            @Override
            public void install(JTextComponent jTextComponent) {
            }

            @Override
            public void setDot(int n) {
            }
        });
        final JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setVerticalScrollBarPolicy(n);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        if (n != 21) {
            jEditorPane.addMouseListener(new MouseAdapter(){
                private final JScrollBar _sb;
                {
                    this._sb = jScrollPane.getVerticalScrollBar();
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = this._sb.getValue() + this._sb.getBlockIncrement(1);
                    this._sb.setValue(n + 50 > this._sb.getMaximum() ? 0 : n);
                }
            });
        }
        jTabbedPane.addTab("", jScrollPane);
        return jEditorPane;
    }

    private void setEditorPaneContent(JEditorPane jEditorPane, String string) {
        String string2 = this.getHtmlPath() + string;
        File file = new File(string2);
        if (!file.exists()) {
            this.setLocalePath(Locale.ENGLISH);
            string2 = this.getHtmlPath() + string;
            file = new File(string2);
        }
        String string3 = file.getAbsolutePath();
        string3 = "file:" + string3;
        try {
            jEditorPane.setPage(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void close() {
        this.tipsDlg.dispose();
        this.tipsDlg = null;
        instance = null;
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.title.setFont(FontCenter.getBigtitlefont());
        this.title.setText(resourceBundle.getString("M.TipsWindow.Tips"));
        this.hiddenCb.setFont(FontCenter.getLabelFont());
        this.hiddenCb.setText(resourceBundle.getString("M.TipsWindow.Hidden"));
        this.chlbl = resourceBundle.getString("M.Channel.Name");
        this.dtlbl = resourceBundle.getString("M.TipsWindow.Detail");
        this.trglbl = resourceBundle.getString("M.Trg.Name");
        this.stclbl = resourceBundle.getString("M.TipsWindow.Shortcuts");
        this.tbp.setFont(Define.def.tipsTabbed);
        this.tbp.setTitleAt(0, this.chlbl);
        this.tbp.setTitleAt(1, this.dtlbl);
        this.tbp.setTitleAt(2, this.trglbl);
        this.tbp.setTitleAt(3, this.stclbl);
        this.setLocalePath(Locale.getDefault());
        this.setEditorPaneContent(this.chlp, "chl1.htm");
        this.setEditorPaneContent(this.detp, "per1.htm");
        this.setEditorPaneContent(this.trgp, "trg1.htm");
        this.setEditorPaneContent(this.stcp, "shortcuts.htm");
    }

    private void setLocalePath(Locale locale) {
        this.locale = locale.toString();
    }

    private String getHtmlPath() {
        String string = this.cm.docManager.getExternalDoc().getPath();
        return string + File.separator;
    }

    public static void main(String[] stringArray) {
    }

    static {
        Co_Title = Define.def.style.CO_DockTitle;
        Co_Tabbed = Define.def.CO_DockBorder;
        Co_Content = Define.def.style.CO_DockContainer;
        Co_EditorPaneBG = Color.WHITE;
    }
}

