/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view;

import com.owon.uppersoft.dso.control.ChartScreenMouseGesture;
import com.owon.uppersoft.dso.control.RightScreenGesture;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.WorkBench;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TrgCheckType;
import com.owon.uppersoft.dso.pref.Define;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.dso.update.action.UpdateAction;
import com.owon.uppersoft.dso.view.CDropTargetAdapter;
import com.owon.uppersoft.dso.view.CKeyAdapter;
import com.owon.uppersoft.dso.view.ChartScreen;
import com.owon.uppersoft.dso.view.ITitleStatus;
import com.owon.uppersoft.dso.view.TipsWindow;
import com.owon.uppersoft.dso.view.TitlePane;
import com.owon.uppersoft.dso.view.ToolPane;
import com.owon.uppersoft.dso.wf.ChartScreenSelectModel;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.ui.prompt.PromptDialog;
import com.owon.uppersoft.vds.ui.prompt.Promptable;
import com.owon.uppersoft.vds.ui.window.ExtendedStataJFrame;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import com.owon.uppersoft.vds.util.LocalizeCenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class MainWindow
implements Localizable,
Promptable {
    public static final int MAX_HEIGHT;
    public static final int MAX_WIDTH;
    private JFrame frame;
    private JPanel basePane;
    private ToolPane toolPane;
    private WorkBench wb;
    private DataHouse dh;
    private ChartScreen chartScreen;
    private TitlePane titlePane;
    private ControlManager cm;
    private KeyEventPostProcessor kepp;
    private GlassPane glassPane;
    private CKeyAdapter keyAdapter;

    @Override
    public Window getWindow() {
        return this.frame;
    }

    @Override
    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public MainWindow(WorkBench workBench, DataHouse dataHouse) {
        this.wb = workBench;
        this.dh = dataHouse;
        this.cm = dataHouse.controlManager;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalKeys(0, new HashSet());
        this.initialize();
        UpdateAction.handleUpdateAction(this.cm, this.frame);
    }

    public DataHouse getDataHouse() {
        return this.dh;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void onDispose() {
        this.wb.exit();
        if (this.dh != null) {
            this.dh.closePersistence();
        }
        this.cm.scpiServer.destroyServer();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.kepp);
    }

    public void exchangeSize() {
        if (this.frame.getExtendedState() != 6) {
            this.frame.setExtendedState(6);
            WindowUtil.ShapeWindow(this.frame, 0);
        } else {
            this.frame.setExtendedState(0);
            WindowUtil.ShapeWindow(this.frame, Define.def.WND_SHAPE_ARC);
        }
    }

    public void switchFullScreen() {
        this.exchangeSize();
        this.frame.requestFocus();
    }

    public void minSize() {
        this.frame.setExtendedState(1);
    }

    private void initialize() {
        Object object;
        Object object2;
        this.frame = new ExtendedStataJFrame();
        this.keyAdapter = new CKeyAdapter(this, this.dh.controlManager);
        this.kepp = new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.isConsumed() || keyEvent.getID() != 401 || !MainWindow.this.frame.isDisplayable()) {
                    return false;
                }
                if (keyEvent.getKeyCode() == 27) {
                    MainWindow.this.closeOwnedWindow();
                    return false;
                }
                if (keyEvent.getComponent() instanceof JTextComponent) {
                    return false;
                }
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() == MainWindow.this.frame) {
                    MainWindow.this.keyAdapter.keyPressed(keyEvent);
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.kepp);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("windowClosing");
                MainWindow.this.onDispose();
                super.windowClosing(windowEvent);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.out.println("windowClosed");
                MainWindow.this.onDispose();
            }
        });
        try {
            object2 = new Robot();
            object = new Timer();
            ((Timer)object).scheduleAtFixedRate(new TimerTask((Robot)object2){
                final /* synthetic */ Robot val$robot;
                {
                    this.val$robot = robot;
                }

                @Override
                public void run() {
                    try {
                        if (MainWindow.this.frame.isActive() && ((MainWindow)MainWindow.this).cm.sourceManager.isConnected()) {
                            this.val$robot.keyPress(61443);
                            this.val$robot.keyRelease(61443);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }, 55000L, 55000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = this.cm.getConfig().getStaticPref().getManufacturerId();
        object = this.cm.getMachine().name();
        this.frame.setTitle(((String)object2).toUpperCase() + " " + (String)object);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/owon/uppersoft/dso/image/icon.png"));
        this.frame.setIconImage(imageIcon.getImage());
        new DropTarget(this.frame, 3, new CDropTargetAdapter(this.dh));
        this.basePane = new JPanel();
        this.basePane.setBackground(Define.def.CO_FRM_Border);
        this.basePane.setLayout(new BorderLayout());
        this.basePane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = MainWindow.this.chartScreen.getWidth();
                int n2 = MainWindow.this.chartScreen.getHeight();
                double d = 1000 + Define.def.AREA_W_BOUNDREST;
                double d2 = Define.def.CHART_HEIGHT;
                MainWindow.this.dh;
                DataHouse.xRate = (double)n / d;
                MainWindow.this.dh;
                DataHouse.yRate = (double)n2 / d2;
                MainWindow.this.chartScreen.resizelayout();
                MainWindow.this.basePane.repaint();
                ((MainWindow)MainWindow.this).cm.pcs.firePropertyChange("update_markbulletin_bound", null, null);
            }
        });
        this.frame.setContentPane(this.basePane);
        this.titlePane = new TitlePane(this, new Dimension(0, Define.def.TITLE_HEIGHT));
        this.basePane.add((Component)this.titlePane, "North");
        this.chartScreen = new ChartScreen(this, this.dh, new Dimension(0, 521));
        this.chartScreen.setScreenSelectWFidx(this.dh.getWaveFormManager().getWaveFormInfoControl().getSelectedwfIdx());
        this.basePane.add((Component)this.chartScreen, "Center");
        this.toolPane = this.createToolPane(new Dimension(0, 173), this.cm);
        this.basePane.add((Component)this.toolPane, "South");
        LocalizeCenter localizeCenter = this.cm.getLocalizeCenter();
        localizeCenter.addLocalizable(this.titlePane);
        localizeCenter.addLocalizable(this.chartScreen);
        localizeCenter.addLocalizable(this.toolPane);
        localizeCenter.addLocalizable(this);
        this.cm.fireFFTonoff2EnableMainWindow();
        this.cm.pcs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("onTimebaseUpdated")) {
                    MainWindow.this.update_Timebase();
                }
            }
        });
        localizeCenter.reLocalize(I18nProvider.bundle());
        this.frame.setSize(Define.def.PreferredSize);
        this.frame.setLocationRelativeTo(null);
        this.glassPane = new GlassPane();
        this.frame.setGlassPane(this.glassPane);
        this.glassPane.setVisible(false);
        WindowUtil.disableTraversFocus(this.frame);
    }

    protected ToolPane createToolPane(Dimension dimension, ControlManager controlManager) {
        return new ToolPane(this, dimension, controlManager);
    }

    public JPanel getGlassPane() {
        return this.glassPane;
    }

    public void prompt(String string) {
        new FadeIOShell().prompt(string, this.frame);
    }

    public void prompt(JComponent jComponent, Runnable runnable) {
        this.glassPane.prompt(jComponent, runnable);
    }

    public void promptUp() {
        this.glassPane.promptUp();
    }

    public void promptClose() {
        this.glassPane.promptClose();
    }

    public ChartScreenSelectModel getChartChannelSelectModel() {
        return this.chartScreen.getChartScreenSelectModel();
    }

    protected final ChartScreenMouseGesture getChartScreenMouseGesture() {
        return this.chartScreen.getChartScreenMouseGesture();
    }

    protected final RightScreenGesture getRightScreenGesture() {
        return this.getChartScreenMouseGesture().getRightScreenGesture();
    }

    private boolean isRuntime() {
        return this.cm.isRuntime();
    }

    public void update_HorTrg() {
        this.titlePane.updateView();
        if (this.isRuntime()) {
            this.re_paint();
        } else {
            this.chartScreen.rebuffer();
        }
    }

    private void update_Timebase() {
        this.titlePane.updateView();
        if (this.isRuntime()) {
            this.re_paint();
        } else {
            this.chartScreen.rebuffer();
        }
    }

    public void update_Pos0() {
        if (this.isRuntime()) {
            this.re_paint();
        } else {
            this.chartScreen.rebuffer();
        }
    }

    public void update_ChangeVoltsense(int n) {
        ChartScreenSelectModel chartScreenSelectModel = this.getChartChannelSelectModel();
        chartScreenSelectModel.update_ChangeLevel(n, TrgCheckType.NotOver);
        this.re_paint();
    }

    public void update_DoneVoltsense() {
        ChartScreenSelectModel chartScreenSelectModel = this.getChartChannelSelectModel();
        chartScreenSelectModel.update_DoneLevelChange();
        this.re_paint();
    }

    public void update_ChangeUppLow(int n, TrgCheckType trgCheckType) {
        ChartScreenSelectModel chartScreenSelectModel = this.getChartChannelSelectModel();
        chartScreenSelectModel.update_ChangeLevel(n, trgCheckType);
        this.re_paint();
    }

    public void update_DoneUppLow() {
        ChartScreenSelectModel chartScreenSelectModel = this.getChartChannelSelectModel();
        chartScreenSelectModel.update_DoneLevelChange();
        this.re_paint();
    }

    public void updateShow() {
        this.chartScreen.rebuffer();
    }

    public void re_paint() {
        this.chartScreen.re_paint();
    }

    public void updateGridColor() {
        this.chartScreen.updateGridColor();
    }

    public void show() {
        this.frame.setVisible(true);
        if (this.cm.istipsWindowShow) {
            TipsWindow.show(this, this.cm);
        }
    }

    public void channelOnOffRepaint(WaveForm waveForm) {
        this.toolPane.getInfoPane().updateInfo(waveForm);
        this.toolPane.updateTrgVolt();
        this.toolPane.getDetailPane().doUpdateSampleRate();
        this.re_paint();
    }

    public ToolPane getToolPane() {
        return this.toolPane;
    }

    public void updateInfo() {
        WaveFormManager waveFormManager = this.dh.getWaveFormManager();
        this.chartScreen.setScreenSelectWFidx(waveFormManager.getWaveFormInfoControl().getSelectedwfIdx());
        this.toolPane.getInfoPane().updateInfos2(waveFormManager);
        this.toolPane.updateTrgVolt();
    }

    public void updateStatus(int n, TrgStatus trgStatus) {
        this.titlePane.updateTrgStatus(n, trgStatus);
    }

    public void updateStatus(TrgStatus trgStatus) {
        this.titlePane.updateTrgStatus(trgStatus);
    }

    public void updateDefaultAll() {
        this.re_paint();
        this.updateInfo();
        this.cm.pcs.firePropertyChange("onTimebaseUpdated", null, null);
    }

    public TitlePane getTitlePane() {
        return this.titlePane;
    }

    public ITitleStatus getITitleStatus() {
        return this.titlePane;
    }

    public ChartScreen getChartScreen() {
        return this.chartScreen;
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.basePane.repaint();
    }

    public CKeyAdapter getKeyAdapter() {
        return this.keyAdapter;
    }

    public void closeOwnedWindow() {
        Window[] windowArray = this.frame.getOwnedWindows();
        int n = windowArray.length;
        while (n-- > 0) {
            Window window = windowArray[n];
            if (!window.isVisible()) continue;
            window.dispose();
            break;
        }
    }

    static {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        MAX_WIDTH = dimension.width;
        MAX_HEIGHT = dimension.height;
    }

    private final class GlassPane
    extends JPanel {
        PromptDialog pp;

        public GlassPane() {
            this.setOpaque(false);
            this.setLayout(null);
            this.pp = new PromptDialog(Define.def.TITLE_HEIGHT);
            this.add(this.pp);
        }

        public void prompt(JComponent jComponent, Runnable runnable) {
            this.setVisible(true);
            this.pp.prompt(jComponent, runnable);
        }

        public void promptUp() {
            if (this.isVisible()) {
                this.pp.promptUp();
            }
        }

        public void promptClose() {
            this.pp.promptClose();
            this.setVisible(false);
        }
    }
}

