/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view;

import com.owon.uppersoft.dso.control.ChartScreenMouseGesture;
import com.owon.uppersoft.dso.control.FFTMouseAdapter;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.TitlePane;
import com.owon.uppersoft.dso.view.ViewChart;
import com.owon.uppersoft.dso.wf.ChartScreenSelectModel;
import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.aspect.Paintable;
import com.owon.uppersoft.vds.core.aspect.help.IPrintable;
import com.owon.uppersoft.vds.core.paint.PaintContext;
import com.owon.uppersoft.vds.core.usb.help.ContextMenuManager;
import com.owon.uppersoft.vds.ui.layout.LayoutManagerAdapter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ChartScreen
extends JPanel
implements Localizable,
PropertyChangeListener,
Paintable,
IPrintable {
    private ViewChart chart;
    private ViewChart v1;
    private ViewChart v2;
    private PaintContext pc;
    private DataHouse dh;
    private ChartScreenMouseGesture csmg;
    private ChartScreenSelectModel cssm = new ChartScreenSelectModel();
    private JPopupMenu ctxMenu;
    private ContextMenuManager cmm;

    public ChartScreenMouseGesture getChartScreenMouseGesture() {
        return this.csmg;
    }

    public ChartScreenSelectModel getChartScreenSelectModel() {
        return this.cssm;
    }

    public void setScreenSelectWFidx(int n) {
        this.cssm.setScreenSelectWFidx(n);
    }

    public ChartScreen(MainWindow mainWindow, DataHouse dataHouse, Dimension dimension) {
        this.dh = dataHouse;
        ControlManager controlManager = dataHouse.controlManager;
        WaveFormManager waveFormManager = dataHouse.getWaveFormManager();
        this.setBackground(Color.BLACK);
        this.pc = controlManager.paintContext;
        this.chart = new ViewChart(dataHouse.getGlobalDecorater(), this.pc);
        this.csmg = new ChartScreenMouseGesture(mainWindow, this.chart, dataHouse, this.chart, this);
        this.add(this.chart);
        this.v1 = new ViewChart(waveFormManager.getXYView(), this.pc);
        this.v2 = new ViewChart(waveFormManager.getFFTView(), this.pc);
        FFTMouseAdapter fFTMouseAdapter = new FFTMouseAdapter(waveFormManager, controlManager.fftctr, this.v2);
        this.v2.addMouseListener(fFTMouseAdapter);
        this.v2.addMouseMotionListener(fFTMouseAdapter);
        this.add(this.v1);
        this.add(this.v2);
        this.layout3in1(waveFormManager.is3in1On());
        this.setLayout(new LayoutManagerAdapter(){

            @Override
            public void layoutContainer(Container container) {
                ChartScreen.this.resizelayout();
            }
        });
        this.ctxMenu = new JPopupMenu();
        this.add(this.ctxMenu);
        this.cmm = new ContextMenuManager(this.ctxMenu, this);
        controlManager.pcs.addPropertyChangeListener(this);
    }

    public ContextMenuManager getContextMenuManager() {
        return this.cmm;
    }

    private void enableChartScreenGesture(boolean bl) {
        this.csmg.enableGesture(bl);
    }

    public void resizelayout() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = n >> 1;
        int n4 = n2 >> 1;
        Rectangle rectangle = this.pc.getChartRectangle();
        Rectangle rectangle2 = new Rectangle(rectangle.x + (rectangle.width >> 1) - (rectangle.width >> 3), 7, rectangle.width >> 2, rectangle.height);
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle2.y, rectangle.width, rectangle2.height);
        if (this.pc.isScreenMode_3()) {
            this.v1.setBounds(0, 0, n, n4);
            this.v2.setBounds(0, 0, n, n4);
            this.chart.setBounds(0, n4, n, n4);
            this.v1.adjustView(this.pc, rectangle2);
            this.v2.adjustView(this.pc, rectangle3);
            this.chart.adjustView(this.pc, rectangle);
        } else if (this.dh.controlManager.getFFTControl().isFFTon()) {
            this.v2.setBounds(0, 0, n, n2);
            this.v2.adjustView(this.pc, rectangle);
        } else if (this.dh.getWaveFormManager().getXYView().isOn()) {
            rectangle = new Rectangle(rectangle.x + (rectangle.width >> 2), rectangle.y, rectangle.width >> 1, rectangle.height);
            this.v1.setBounds(0, 0, n, n2);
            this.v1.adjustView(this.pc, rectangle);
        } else {
            this.chart.setBounds(0, 0, n, n2);
            this.chart.adjustView(this.pc, rectangle);
        }
    }

    private void layout3in1(boolean bl) {
        boolean bl2 = this.dh.controlManager.getFFTControl().isFFTon();
        boolean bl3 = this.dh.getWaveFormManager().getXYView().isOn();
        if (!bl2 && bl) {
            if (!bl3) {
                bl3 = true;
                this.dh.controlManager.displayControl.setXYMode(bl3);
            } else if (!this.chart.isVisible()) {
                bl3 = false;
                bl = false;
                this.dh.controlManager.displayControl.setXYMode(bl3);
            }
        }
        this.pc.setScreenMode_3(bl);
        if (bl) {
            this.v1.setVisible(!bl2 && bl3);
            this.v2.setVisible(bl2);
            this.chart.setVisible(true);
        } else {
            this.v1.setVisible(!bl2 && bl3);
            this.v2.setVisible(bl2);
            this.chart.setVisible(!bl2 && !bl3);
        }
    }

    public void fft_re_paint() {
        this.v2.re_paint();
    }

    public void xy_re_paint() {
        this.v1.re_paint();
    }

    public boolean is3in1() {
        return this.pc.isScreenMode_3();
    }

    public void update3in1(boolean bl) {
        Platform.getDataHouse().set3in1(bl);
        this.layout3in1(bl);
        this.re_paint();
    }

    protected void customTransform(Graphics2D graphics2D, int n, int n2) {
        AffineTransform affineTransform = new AffineTransform();
        double d = (double)n / (double)this.getWidth();
        affineTransform.setToScale(d, d);
        graphics2D.transform(affineTransform);
    }

    @Override
    public void printView(Graphics2D graphics2D, int n, int n2) {
        double d = (double)n / (double)this.getWidth();
        graphics2D.scale(d, d);
        Rectangle rectangle = this.v1.getBounds();
        graphics2D.setBackground(new Color(255, 255, 255, 150));
        if (this.pc.isScreenMode_3()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            graphics2D.translate(0, rectangle.y);
            this.v1.paintView(graphics2D, this.pc, this.v1.getLocInfo());
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.translate(rectangle.x + rectangle.width, rectangle.y);
            this.v2.paintView(graphics2D, this.pc, this.v2.getLocInfo());
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.translate(0, rectangle.y + rectangle.height);
            this.chart.paintView(graphics2D, this.pc, this.chart.getLocInfo());
        } else if (this.dh.controlManager.getFFTControl().isFFTon()) {
            this.v2.paintView(graphics2D, this.pc, this.chart.getLocInfo());
        } else if (this.dh.getWaveFormManager().getXYView().isOn()) {
            this.v1.paintView(graphics2D, this.pc, this.chart.getLocInfo());
        } else {
            this.chart.paintView(graphics2D, this.pc, this.chart.getLocInfo());
        }
    }

    public void updateGridColor() {
        this.re_paint();
    }

    public void updateXYView() {
        if (this.v1.isVisible()) {
            this.v1.repaint();
        }
    }

    public void rebuffer() {
        this.dh.getGlobalDecorater().rebuffer();
        this.re_paint();
    }

    @Override
    public void re_paint() {
        this.repaint();
    }

    public PaintContext getPaintContext() {
        return this.pc;
    }

    public ViewChart getChart() {
        return this.chart;
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.chart.localize(resourceBundle);
        this.v1.localize(resourceBundle);
        this.v2.localize(resourceBundle);
    }

    public BufferedImage getChartScreenBufferedImage() {
        MainWindow mainWindow = Platform.getMainWindow();
        JFrame jFrame = mainWindow.getFrame();
        Container container = jFrame.getContentPane();
        JLayeredPane jLayeredPane = jFrame.getLayeredPane();
        TitlePane titlePane = mainWindow.getTitlePane();
        int n = container.getWidth();
        int n2 = container.getHeight();
        int n3 = mainWindow.getTitlePane().getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2 - n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(0, -n3);
        container.paint(graphics2D);
        ((Container)jLayeredPane).paint(graphics2D);
        return bufferedImage;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("FFT_ON")) {
            this.repaint();
        } else if (string.equals("FFT_OFF")) {
            this.repaint();
        } else if (string.equals("DURINGDMFETCH")) {
            this.enableChartScreenGesture((Boolean)propertyChangeEvent.getNewValue() == false);
        } else if (string.equals("REPAINT_CHARTSCREEN")) {
            this.repaint();
        }
    }
}

