/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view;

import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.model.trigger.common.Voltsensor;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.TipsWindow;
import com.owon.uppersoft.dso.view.sub.DetailPane;
import com.owon.uppersoft.dso.view.sub.InfoBlockAction;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.core.zoom.AssitControl;
import com.owon.uppersoft.vds.print.PrinterPreviewFrame;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Formatter;
import java.util.ResourceBundle;

public class CKeyAdapter
extends KeyAdapter {
    final int CH_ACTIVE = -1;
    final int CH_1 = 0;
    final int CH_2 = 1;
    final int INCR = 1;
    final int DECR = -1;
    private MainWindow mw;
    private ControlManager cm;
    private CoreControl cc;

    public CKeyAdapter(MainWindow mainWindow, ControlManager controlManager) {
        this.mw = mainWindow;
        this.cm = controlManager;
        this.cc = controlManager.getCoreControl();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        block73: {
            int n;
            block74: {
                boolean bl;
                block72: {
                    boolean bl2;
                    ControlApps controlApps = Platform.getControlApps();
                    if (controlApps == null || controlApps.getOperateBlocker() == null) {
                        return;
                    }
                    boolean bl3 = controlApps.getOperateBlocker().isBlock();
                    if (bl3 || this.cm.isDuringDMFtech()) {
                        return;
                    }
                    n = keyEvent.getKeyCode();
                    int n2 = keyEvent.getModifiersEx();
                    boolean bl4 = (n2 & 0x80) != 0;
                    bl = (n2 & 0x40) != 0;
                    boolean bl5 = (n2 & 0x200) != 0;
                    boolean bl6 = bl2 = (n2 & 4) != 0;
                    if (bl5 || bl2) {
                        return;
                    }
                    switch (keyEvent.getKeyChar()) {
                        case '+': {
                            n = 521;
                            break;
                        }
                        case '-': {
                            n = 45;
                        }
                    }
                    if (!bl4) break block72;
                    switch (n) {
                        case 10: {
                            this.autoset();
                            break block73;
                        }
                        case 76: {
                            this.switchRoot();
                            break block73;
                        }
                        case 48: 
                        case 96: {
                            this.saveRestore(bl);
                            break block73;
                        }
                        case 61: 
                        case 107: 
                        case 521: {
                            this.zoomTimeBase(-1);
                            break block73;
                        }
                        case 45: 
                        case 109: 
                        case 522: {
                            this.zoomTimeBase(1);
                            break block73;
                        }
                        case 38: {
                            this.changeTrigLevel(-1, 1);
                            break block73;
                        }
                        case 40: {
                            this.changeTrigLevel(-1, -1);
                            break block73;
                        }
                        case 49: 
                        case 97: {
                            this.selectTriggerSource(0);
                            break block73;
                        }
                        case 50: 
                        case 98: {
                            this.selectTriggerSource(1);
                            break block73;
                        }
                        case 51: 
                        case 99: {
                            this.selectTriggerSource(2);
                            break block73;
                        }
                        case 52: 
                        case 100: {
                            this.selectTriggerSource(3);
                            break block73;
                        }
                        case 80: {
                            this.printPreview();
                            break block73;
                        }
                        case 79: {
                            this.loadDMfile();
                            break block73;
                        }
                        case 83: {
                            this.exportDMfile();
                            break block73;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (!bl) break block74;
                switch (n) {
                    case 37: {
                        this.moveHTP(-1);
                        break block73;
                    }
                    case 39: {
                        this.moveHTP(1);
                        break block73;
                    }
                    case 38: {
                        this.changeVoltOffset(-1, 1);
                        break block73;
                    }
                    case 40: {
                        this.changeVoltOffset(-1, -1);
                        break block73;
                    }
                    case 88: {
                        this.selectNextProbe(-1);
                        break block73;
                    }
                    case 61: 
                    case 107: 
                    case 521: {
                        this.changeVoltBase(-1, 1);
                        break block73;
                    }
                    case 45: 
                    case 109: 
                    case 522: {
                        this.changeVoltBase(-1, -1);
                        break block73;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (n) {
                case 112: {
                    this.showHelp();
                    break;
                }
                case 113: {
                    this.openTuneDialog();
                    break;
                }
                case 116: {
                    this.switchRunStop();
                    break;
                }
                case 122: {
                    this.switchFullScreen();
                    break;
                }
                case 123: {
                    this.showTips();
                    break;
                }
                case 32: {
                    this.switchRunStop();
                    break;
                }
                case 10: {
                    this.sweepOnce();
                    break;
                }
                case 78: {
                    this.sweepNormal();
                    break;
                }
                case 9: {
                    this.selectNextChannel();
                    break;
                }
                case 49: 
                case 97: {
                    this.switchChannelOnOff(0);
                    break;
                }
                case 50: 
                case 98: {
                    this.switchChannelOnOff(1);
                    break;
                }
                case 51: 
                case 99: {
                    this.switchChannelOnOff(2);
                    break;
                }
                case 52: 
                case 100: {
                    this.switchChannelOnOff(3);
                    break;
                }
                case 81: {
                    this.changeVoltBase(0, -1);
                    break;
                }
                case 65: {
                    this.changeVoltBase(0, 1);
                    break;
                }
                case 87: {
                    this.changeVoltBase(1, -1);
                    break;
                }
                case 83: {
                    this.changeVoltBase(1, 1);
                    break;
                }
                case 69: {
                    this.changeVoltBase(2, -1);
                    break;
                }
                case 68: {
                    this.changeVoltBase(2, 1);
                    break;
                }
                case 82: {
                    this.changeVoltBase(3, -1);
                    break;
                }
                case 70: {
                    this.changeVoltBase(3, 1);
                    break;
                }
                case 38: {
                    this.changeVoltOffset(-1, 5);
                    break;
                }
                case 40: {
                    this.changeVoltOffset(-1, -5);
                    break;
                }
                case 61: 
                case 107: 
                case 521: {
                    this.changeTimeBase(-1);
                    break;
                }
                case 45: 
                case 109: 
                case 522: {
                    this.changeTimeBase(1);
                    break;
                }
                case 37: {
                    this.moveHTP(-5);
                    break;
                }
                case 39: {
                    this.moveHTP(5);
                    break;
                }
                case 8: {
                    this.resetHTP();
                    break;
                }
                case 77: {
                    this.swicthZoomMain();
                    break;
                }
                case 67: {
                    this.selectNextCoupling(-1);
                    break;
                }
                case 88: {
                    this.selectNextProbe(1);
                    break;
                }
                case 73: {
                    this.invertChannel(-1);
                    break;
                }
                case 80: {
                    this.pinChannel(-1);
                    break;
                }
                case 84: {
                    this.set50percentTrigLevel();
                    break;
                }
                case 86: {
                    this.switchView();
                    break;
                }
                case 127: {
                    this.unpinChannel();
                    break;
                }
                case 33: {
                    this.changeVoltBase(-1, 1);
                    break;
                }
                case 34: {
                    this.changeVoltBase(-1, -1);
                    break;
                }
                default: {
                    this.inputPWDCode(n);
                    return;
                }
            }
        }
        keyEvent.consume();
    }

    private void prompt(String string, Object ... objectArray) {
        String string2 = new Formatter().format(string, objectArray).toString();
        new FadeIOShell().prompt(string2, this.mw.getFrame());
    }

    protected void inputPWDCode(int n) {
        this.cm.sc.validatPWDInput(n);
    }

    protected void saveRestore(boolean bl) {
        if (bl) {
            this.cm.persist(this.cm.getConfig().getSessionProperties());
        } else {
            this.cm.defaultSet();
            this.cm.pcs.firePropertyChange("UPDATE_FACTORY_VIEW", null, null);
        }
    }

    protected void openTuneDialog() {
        this.cm.getPrinciple().openTuneDialog(this.mw.getFrame(), this.cm.pcs);
    }

    protected void switchRoot() {
        this.cm.pcs.firePropertyChange("ADMIN_ROOT_PASSWORD_NOTIFY", null, (Object)true);
    }

    protected void exportDMfile() {
        this.cm.ewc.exportDMfile(this.mw.getFrame());
    }

    protected void loadDMfile() {
        this.cm.ewc.loadDMfile(this.mw.getFrame());
    }

    protected void switchRunStop() {
        this.mw.getTitlePane().askSwitchRS();
    }

    protected void autoset() {
        Platform.getControlApps().interComm.autoset();
    }

    protected void sweepOnce() {
        this.mw.getTitlePane().askSweepOnce();
    }

    protected void sweepNormal() {
        this.mw.getTitlePane().askSweepNormal();
    }

    protected void showHelp() {
        this.cm.docManager.helpAction();
    }

    protected void showTips() {
        TipsWindow.show(this.mw, this.cm, 3);
    }

    protected void selectNextChannel() {
        int n = this.cc.getSupportChannelsNumber();
        int n2 = this.cm.getWaveFormInfoControl().getSelectedwfIdx();
        for (int i = 1; i <= n; ++i) {
            int n3 = (n2 + i) % n;
            if (!this.cc.getWaveFormInfo((int)n3).ci.isOn()) continue;
            this.selectChannel(n3);
            this.mw.re_paint();
            return;
        }
    }

    protected void switchChannelOnOff(int n) {
        if (n >= this.cc.getSupportChannelsNumber()) {
            return;
        }
        ChannelInfo channelInfo = this.cc.getWaveFormInfo((int)n).ci;
        if (channelInfo.isOn()) {
            channelInfo.c_setOn(false);
            this.selectNextChannel();
        } else {
            this.selectChannel(channelInfo.getNumber());
        }
        Platform.getMainWindow().updateDefaultAll();
    }

    protected ChannelInfo selectChannel(int n) {
        int n2 = this.cc.getWaveFormInfoControl().getSelectedwfIdx();
        int n3 = this.mw.getChartChannelSelectModel().getScreenSelectWFidx();
        if (n < 0) {
            n = n2;
        }
        if (n >= this.cc.getSupportChannelsNumber()) {
            return null;
        }
        ChannelInfo channelInfo = this.cc.getWaveFormInfo((int)n).ci;
        if (!channelInfo.isOn()) {
            channelInfo.c_setOn(true);
        }
        if (n != n2 || n2 != n3) {
            this.mw.getChartChannelSelectModel().setScreenSelectWFidx(n);
            this.mw.getDataHouse().getWaveFormManager().setSelectedWaveForm(n);
            this.mw.getToolPane().getInfoPane().updateSelected(n);
            this.cm.pcs.firePropertyChange("CHOOSE_CHANNELS", null, null);
        }
        return channelInfo;
    }

    protected void invertChannel(int n) {
        ChannelInfo channelInfo = this.selectChannel(n);
        if (channelInfo == null) {
            return;
        }
        channelInfo.c_setInverse(!channelInfo.isInverse());
        this.cm.pcs.firePropertyChange("ChannelOpposite", null, null);
        Platform.getMainWindow().updateDefaultAll();
        ResourceBundle resourceBundle = I18nProvider.bundle();
        this.prompt("%s (%s) : %s", resourceBundle.getObject("M.Channel.Opposite"), channelInfo.getName(), channelInfo.isInverse() ? resourceBundle.getString("M.Rule.enable") : resourceBundle.getString("M.Rule.disable"));
    }

    protected void selectNextCoupling(int n) {
        ChannelInfo channelInfo = this.selectChannel(n);
        if (channelInfo == null) {
            return;
        }
        int n2 = (channelInfo.getCouplingIdx() + 1) % 2;
        channelInfo.c_setCoupling(n2);
        this.cm.pcs.firePropertyChange("CouplingOption", null, null);
        Platform.getMainWindow().updateDefaultAll();
        ResourceBundle resourceBundle = I18nProvider.bundle();
        this.prompt("%s (%s) : %s", resourceBundle.getString("M.Channel.Coupling"), channelInfo.getName(), ChannelInfo.COUPLING[n2]);
    }

    protected void selectTriggerSource(int n) {
        TriggerControl triggerControl = this.cc.getTriggerControl();
        if (!triggerControl.isSingleTrg()) {
            return;
        }
        this.selectChannel(n);
        triggerControl.setSingleChannel(n);
        this.cm.pcs.firePropertyChange("NextSingleChannel", null, (Object)triggerControl.singleTriggerSet.getChannel());
        triggerControl.doSubmit();
        Platform.getMainWindow().updateDefaultAll();
        n = triggerControl.getSingleTrgChannel();
        ResourceBundle resourceBundle = I18nProvider.bundle();
        this.prompt("%s/%s : %s", resourceBundle.getObject("M.Trg.Name"), resourceBundle.getObject("M.Trg.Source"), n >= this.cm.getAllChannelsNumber() ? "EXT" : "CH" + (n + 1));
    }

    protected void selectNextProbe(int n) {
        ChannelInfo channelInfo = this.selectChannel(-1);
        if (channelInfo == null) {
            return;
        }
        int n2 = channelInfo.getProbeMultiIdx();
        int n3 = channelInfo.getVoltageProvider().getProbeMulties().length;
        channelInfo.setProbeMultiIdx((n3 + n2 + n) % n3);
        this.cm.updateChannelVoltValueEverywhere(channelInfo.getNumber());
        ResourceBundle resourceBundle = I18nProvider.bundle();
        this.prompt("%s (%s) : %s", resourceBundle.getString("M.Channel.ProbeRate"), channelInfo.getName(), channelInfo.getProbeLabel());
    }

    protected void unpinChannel() {
        if (this.cm.rwc.removeLastVisibleReference()) {
            this.cm.pcs.firePropertyChange("ReferenceChanged", null, null);
            this.mw.re_paint();
        }
    }

    protected void pinChannel(int n) {
        ChannelInfo channelInfo = this.selectChannel(n);
        if (channelInfo == null) {
            return;
        }
        this.cm.rwc.saveWave(channelInfo.getNumber(), "").setVisible(true);
        this.cm.pcs.firePropertyChange("ReferenceChanged", null, null);
        this.mw.re_paint();
    }

    protected void changeVoltBase(int n, int n2) {
        ChannelInfo channelInfo = this.selectChannel(n);
        if (channelInfo == null) {
            return;
        }
        InfoBlockAction infoBlockAction = this.mw.getToolPane().getInfoPane().get(channelInfo.getNumber()).getInfoBlockDelegate();
        infoBlockAction.removeOwnedComboBox();
        infoBlockAction.incretSelect(n2);
    }

    protected void changeVoltOffset(int n, int n2) {
        ChannelInfo channelInfo = this.selectChannel(n);
        if (channelInfo == null) {
            return;
        }
        int n3 = channelInfo.getPos0() + n2 * 5;
        n3 = (int)Math.floor((double)n3 / 5.0) * 5;
        InfoBlockAction infoBlockAction = this.mw.getToolPane().getInfoPane().get(channelInfo.getNumber()).getInfoBlockDelegate();
        infoBlockAction.valueChanged_Directly(n3);
    }

    protected void changeTrigLevel(int n, int n2) {
        ChannelInfo channelInfo = this.selectChannel(-1);
        if (channelInfo == null) {
            return;
        }
        TriggerControl triggerControl = this.cc.getTriggerControl();
        TriggerSet triggerSet = triggerControl.getTriggerSetOrNull(channelInfo.getNumber());
        if (triggerSet == null || triggerSet.isCurrentTrigger_Video()) {
            return;
        }
        Voltsensor voltsensor = triggerSet.getVoltsense();
        int n3 = channelInfo.getInverseValue(voltsensor.c_getVoltsense()) + n2 * 5;
        boolean bl = voltsensor.c_setVoltsense(channelInfo.getInverseValue(n3 = (int)Math.floor((double)n3 / 5.0) * 5));
        if (bl) {
            VoltsensableTrigger voltsensableTrigger = (VoltsensableTrigger)triggerSet.getTrigger();
            triggerControl.getVTPatchable().submiteVoltsense(channelInfo.getNumber(), voltsensableTrigger);
        }
        this.cm.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
        this.cm.pcs.firePropertyChange("UpdateVoltsense", -1, channelInfo.getNumber());
    }

    public void set50percentTrigLevel() {
        ChannelInfo channelInfo = this.selectChannel(-1);
        if (channelInfo == null) {
            return;
        }
        TriggerControl triggerControl = this.cc.getTriggerControl();
        TriggerSet triggerSet = triggerControl.getTriggerSetOrNull(channelInfo.getNumber());
        if (triggerSet == null || triggerSet.isCurrentTrigger_Video()) {
            return;
        }
        Platform.getDataHouse().getWaveFormManager().getWaveForm(channelInfo.getNumber()).setTrg50Percent(triggerControl);
    }

    protected void moveHTP(int n) {
        DetailPane detailPane = this.mw.getToolPane().getDetailPane();
        Platform.getControlApps().interComm.isTimeOperatableNTryGetDM();
        int n2 = detailPane.getHorizontalTriggerPosition() - n * 10;
        n2 = (int)Math.floor((double)n2 / 5.0) * 5;
        detailPane.setHorizontalTriggerPosition(n2);
    }

    protected void resetHTP() {
        DetailPane detailPane = this.mw.getToolPane().getDetailPane();
        if (this.cc.getTimeControl().isOnSlowMoveTimebase()) {
            detailPane.setHorizontalTriggerPosition(500);
        } else {
            detailPane.setHorizontalTriggerPosition(0);
        }
    }

    protected void changeTimeBase(int n) {
        Platform.getControlApps().interComm.isTimeOperatableNTryGetDM();
        int n2 = this.cc.getTimeControl().getTimebaseIdx();
        this.cc.getTimeControl().c_setTimebaseIdx(n2 + n, true);
    }

    protected void zoomTimeBase(int n) {
        AssitControl assitControl = this.cm.getZoomAssctr();
        TimeControl timeControl = this.cc.getTimeControl();
        if (!assitControl.isonZoom()) {
            assitControl.changeZoomstatus(this.cm, 2);
            this.cm.pcs.firePropertyChange("zoomSelected", null, (Object)2);
        }
        int n2 = 0;
        int n3 = timeControl.getTimeConfProvider().getTimebaseNumber() - 1;
        int n4 = Math.min(n3, Math.max(n2, assitControl.getZTBidx() + n));
        if (n4 == assitControl.getZTBidx()) {
            return;
        }
        if (n4 > timeControl.getTimebaseIdx()) {
            timeControl.c_setTimebaseIdx(n4, true);
        }
        assitControl.assistSetcomputDeltabb1b2(n4, timeControl.getTimebaseIdx());
        Platform.getMainWindow().getChartScreen().re_paint();
    }

    protected void swicthZoomMain() {
        AssitControl assitControl = this.cm.getZoomAssctr();
        int n = assitControl.isonZoom() ? 0 : 2;
        assitControl.changeZoomstatus(this.cm, n);
        this.cm.pcs.firePropertyChange("zoomSelected", null, (Object)n);
    }

    protected void switchFullScreen() {
        this.mw.switchFullScreen();
    }

    protected void switchView() {
        this.mw.getToolPane().getButtonPane().switch_3in1();
    }

    protected void printPreview() {
        PrinterPreviewFrame.handlePrinterPreview(this.mw, this.cm);
    }
}

