/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.util;

import com.owon.uppersoft.vds.util.LoggerUtil;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBG {
    public static boolean debug = true;
    public static int cmddebug = -1;
    private static Logger logger = LoggerUtil.getConsoleLogger(DBG.class.getName(), Level.ALL, new LoggerUtil.Textable(){

        @Override
        public void appendText(String string) {
            DBG.outprint(string);
        }
    });
    public static final Level[] Levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private static StringBuilder sb = new StringBuilder();

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogType(int n) {
        cmddebug = n;
        Level level = Level.OFF;
        if (n >= 0 && n < Levels.length) {
            level = Levels[n];
        }
        logger.setLevel(level);
    }

    public static final void prepareLogType(int n, File file) {
        DBG.setLogType(n);
        if (!DBG.isCMDDEBUG()) {
            LoggerUtil.redirect2FileLog(file);
        }
    }

    public static final boolean isCMDDEBUG() {
        return cmddebug >= 0;
    }

    public static final void dbg(Object object) {
        if (!debug) {
            return;
        }
        sb.append(object);
    }

    public static final void dbgd(Object object) {
        if (!debug) {
            return;
        }
        DBG.flushdbg();
        String string = object.toString();
        if (string.length() > 0) {
            DBG.fine(string);
        }
    }

    public static final void dbgln(Object object) {
        DBG.flushdbg();
        String string = object.toString();
        if (string.length() > 0) {
            DBG.fine(string + "\r\n");
        }
    }

    public static final void flushdbg() {
        int n = sb.length();
        if (n > 0) {
            DBG.fine(sb.toString() + "\r\n");
            sb.delete(0, n);
        }
    }

    public static final void config(Object object) {
        if (debug) {
            logger.config(object.toString());
        }
    }

    public static final void configln() {
        if (debug) {
            logger.config("\r\n");
        }
    }

    public static final void configln(Object object) {
        if (debug) {
            logger.config(object + "\r\n");
        }
    }

    public static final void fine(Object object) {
        if (debug) {
            logger.fine(object.toString());
        }
    }

    public static final void finer(Object object) {
        if (debug) {
            logger.finer(object.toString());
        }
    }

    public static final void finest(Object object) {
        if (debug) {
            logger.finest(object.toString());
        }
    }

    public static final void info(Object object) {
        if (debug) {
            logger.info(object.toString());
        }
    }

    public static final void severe(Object object) {
        if (debug) {
            logger.severe(object.toString());
        }
    }

    public static final void seversln(Object object) {
        if (debug) {
            logger.severe(object + "\r\n");
        }
        System.err.println(object);
    }

    public static final void severs(Object object) {
        if (debug) {
            logger.severe(object + "\r\n");
        }
        System.err.print(object);
    }

    public static final void warning(Object object) {
        if (debug) {
            logger.warning(object.toString());
        }
    }

    public static final void errprintln(Object object) {
        if (debug) {
            System.err.println(object);
        }
    }

    public static final void errprintln() {
        System.err.println();
    }

    public static final void errprint(Object object) {
        System.err.print(object);
    }

    public static final void outprintln(Object object) {
        System.out.println(object);
    }

    public static final void outprintln() {
        System.out.println();
    }

    public static final void outprint(Object object) {
        System.out.print(object);
    }
}

