/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.usb;

import ch.ntb.usb.USBException;
import com.owon.uppersoft.dso.source.usb.USBDelegate;
import com.owon.uppersoft.dso.source.usb.USBPortsFilter;
import com.owon.uppersoft.dso.source.usb.USBSource;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.core.usb.CDevice;
import com.owon.uppersoft.vds.core.usb.IDevice;
import java.util.LinkedList;
import java.util.List;

public class USBSourceManager
implements ICommunicateManager,
USBDelegate {
    public static final String USBDrvDir = "USBDRV";
    private USBPortsFilter pf;
    public static final int FailureRetryTimes = 10;
    private USBSource usbs = null;

    public USBSourceManager(USBPortsFilter uSBPortsFilter) {
        this.pf = uSBPortsFilter;
    }

    @Override
    public int retryTimes() {
        return 10;
    }

    @Override
    public int acceptResponse(byte[] byArray, int n) {
        if (this.isConnected()) {
            return this.usbs.acceptResponse(byArray, n);
        }
        return -1;
    }

    public int acceptResponse(byte[] byArray, int n, int n2) {
        if (this.isConnected()) {
            return this.usbs.acceptResponse(byArray, n, n2);
        }
        return -1;
    }

    @Override
    public int write(byte[] byArray, int n) {
        if (this.isConnected()) {
            return this.usbs.write(byArray, n);
        }
        return -1;
    }

    public boolean init_check_usbdrv() {
        try {
            CDevice.init();
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public List<IDevice> refreshUSBPort() {
        try {
            List<IDevice> list = CDevice.getDevices((short)21317, (short)4660, this.pf);
            return list;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new LinkedList<IDevice>();
        }
    }

    @Override
    public USBSource _getUSBSource(IDevice iDevice) {
        if (iDevice == null) {
            return null;
        }
        try {
            iDevice.open();
            this.usbs = new USBSource(iDevice);
            return this.usbs;
        }
        catch (USBException uSBException) {
            uSBException.printStackTrace();
            return null;
        }
    }

    public boolean reConnectTheSameDevice() {
        IDevice iDevice = this.usbs.getDevice();
        try {
            iDevice.close();
        }
        catch (USBException uSBException) {
            // empty catch block
        }
        int n = 5;
        block6: while (n-- > 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            for (IDevice iDevice2 : this.refreshUSBPort()) {
                if (!iDevice2.equals(iDevice)) continue;
                try {
                    iDevice2.open();
                    this.usbs = new USBSource(iDevice2);
                    return true;
                }
                catch (USBException uSBException) {
                    System.err.println(uSBException.getMessage());
                    continue block6;
                }
            }
        }
        return false;
    }

    @Override
    public boolean tryRescue() {
        return this.reConnectTheSameDevice();
    }

    @Override
    public boolean isConnected() {
        return this.usbs != null && this.usbs.getDevice().isOpen();
    }

    public String getUsbSN() {
        if (this.usbs == null) {
            return "usbs null";
        }
        return this.usbs.getId().getSerialNumber();
    }

    public void releaseUSBSource() {
        if (this.usbs == null) {
            return;
        }
        this.releaseUSBSource(this.usbs);
        this.usbs = null;
    }

    public USBSource getUsbs() {
        return this.usbs;
    }

    @Override
    public void releaseUSBSource(USBSource uSBSource) {
        IDevice iDevice = uSBSource.getDevice();
        if (iDevice != null && iDevice.isOpen()) {
            try {
                iDevice.close();
                this.logln("releaseUSBSource");
            }
            catch (USBException uSBException) {
                uSBException.printStackTrace();
            }
        }
    }

    private void logln(String string) {
    }
}

