/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.usb;

import ch.ntb.usb.USBException;
import com.owon.uppersoft.vds.core.comm.ISource;
import com.owon.uppersoft.vds.core.usb.IDevice;
import java.io.IOException;
import java.nio.ByteBuffer;

public class USBSource
implements ISource {
    protected static final int LTimeOut = 7000;
    protected static final int DTimeOut = 200;
    protected static final int STimeOut = 3000;
    protected IDevice dev;
    private byte[] buf;

    public USBSource(IDevice iDevice) {
        this.dev = iDevice;
        this.buf = new byte[iDevice.getWriteEpMaxPacketSize()];
    }

    public IDevice getDevice() {
        return this.dev;
    }

    public IDevice getId() {
        return this.dev;
    }

    public int write(byte[] byArray, int n) {
        return this.dowrite2(byArray, n);
    }

    private int dowrite(byte[] byArray, int n) {
        int n2 = 7000;
        int n3 = 0;
        try {
            n3 = this.dev.writeBulk(byArray, n, n2);
            this.logln(n + " write num: " + n3);
            return n3;
        }
        catch (USBException uSBException) {
            System.err.println(uSBException.getMessage());
            return -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    private int dowrite2(byte[] byArray, int n) {
        int n2 = 200;
        int n3 = 0;
        try {
            int n4 = this.buf.length;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n - n5 > n4 ? n4 : n - n5;
                System.arraycopy(byArray, n5, this.buf, 0, n6);
                n5 += n6;
                int n7 = this.dev.writeBulk(this.buf, n6, n2);
                n3 += n7;
                this.logln(n + " write num: " + n7);
            }
            return n3;
        }
        catch (USBException uSBException) {
            System.err.println(uSBException.getMessage());
            return -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    protected void write(ByteBuffer byteBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.limit();
        this.write(byArray, n);
    }

    public int acceptResponse(byte[] byArray, int n, int n2) {
        int n3 = -1;
        try {
            this.logln("acceptResponsing: " + n);
            n3 = this.dev.readBulk(byArray, n, n2);
            this.logln("acceptResponsed: " + n3);
            return n3;
        }
        catch (USBException uSBException) {
            System.err.println(uSBException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    public int acceptResponse(byte[] byArray, int n) {
        return this.acceptResponse(byArray, n, 200);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.dev.readBulk(byArray, 11, 3000);
    }

    protected void logln(String string) {
    }

    protected void log(String string) {
    }
}

