/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.net;

import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.core.comm.ISource;
import com.owon.uppersoft.vds.util.PrimaryTypeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class NetSourceManager
implements ICommunicateManager,
ISource {
    protected static final int header = 41;
    protected static final int LoopBufsize = 512;
    protected static final int TimeOut = 4000;
    protected Socket skt;
    protected InputStream is;
    protected OutputStream os;
    protected byte[] ip;
    protected int port;

    @Override
    public int retryTimes() {
        return 3;
    }

    @Override
    public boolean tryRescue() {
        this.logln("disconnect and ...");
        this.disconnect();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return this.connect(this.ip, this.port);
    }

    public boolean connect(byte[] byArray, int n) {
        this.ip = byArray;
        this.port = n;
        try {
            this.logln("connect");
            this.skt = new Socket(InetAddress.getByAddress(byArray), n);
            this.logln("new socket: " + PrimaryTypeUtil.getIPAddress(byArray, 0) + ", port: " + n);
            this.logln("get socket io");
            this.is = this.skt.getInputStream();
            this.os = this.skt.getOutputStream();
            this.skt.setSoTimeout(4000);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            this.logln("connect UnknownHostException");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.logln("connect IOException");
        }
        return false;
    }

    public void disconnect() {
        try {
            this.skt.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.logln("disconnect err");
        }
    }

    @Override
    public boolean isConnected() {
        return this.skt.isConnected();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.is.read(byArray, n, n2);
    }

    @Override
    public int acceptResponse(byte[] byArray, int n) {
        if (this.isConnected()) {
            try {
                return this.is.read(byArray, 0, n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -1;
            }
        }
        return -1;
    }

    @Override
    public int write(byte[] byArray, int n) {
        if (this.os == null) {
            this.logln("Erro: os is null!");
            return -1;
        }
        try {
            this.os.write(byArray, 0, n);
            this.logln("net write: " + n);
            return n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    protected void logln(String string) {
    }

    protected void log(String string) {
    }

    protected void println(String string) {
    }
}

