/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.manager;

import com.owon.uppersoft.dso.source.net.NetSourceManager;
import com.owon.uppersoft.dso.source.usb.USBSource;
import com.owon.uppersoft.dso.source.usb.USBSourceManager;
import com.owon.uppersoft.vds.core.comm.BufferredSourceManager;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.core.comm.IRuntime;
import com.owon.uppersoft.vds.core.usb.IDevice;
import java.util.List;

public abstract class SourceManager
extends BufferredSourceManager
implements ICommunicateManager {
    private USBSourceManager usbsm;
    private ICommunicateManager choice;
    private NetSourceManager ntsm;
    private IRuntime ir;
    public static final int INT_NoSource = -1;
    public static final int INT_USBSource = 0;
    public static final int INT_NETSource = 1;
    public int connectContext = -1;

    public SourceManager(IRuntime iRuntime) {
        this.ir = iRuntime;
    }

    public void setup() {
        this.usbsm = this.createUSBSourceManager();
        this.choice = this.usbsm;
        this.ntsm = this.createNetSourceManager();
        this.ir.setRecentStop(false);
    }

    public ICommunicateManager getChoice() {
        return this.choice;
    }

    protected abstract USBSourceManager createUSBSourceManager();

    protected abstract NetSourceManager createNetSourceManager();

    public USBSourceManager getUSBSourceManager() {
        return this.usbsm;
    }

    public boolean isUSBConnect() {
        return this.connectContext == 0;
    }

    public boolean isNETConnect() {
        return this.connectContext == 1;
    }

    @Override
    public boolean isConnected() {
        return this.connectContext != -1;
    }

    public boolean connectUSB(IDevice iDevice) {
        this.ir.setRecentStop(false);
        USBSource uSBSource = this.usbsm._getUSBSource(iDevice);
        if (uSBSource != null) {
            this.chooseManager(0);
            return true;
        }
        return false;
    }

    public void disconnectSource() {
        if (this.connectContext == 0) {
            this.usbsm.releaseUSBSource();
        }
        if (this.connectContext == 1) {
            this.ntsm.disconnect();
        }
        this.choice = null;
        this.connectContext = -1;
        this.ir.setRecentStop(false);
    }

    public boolean connectNet(byte[] byArray, int n) {
        boolean bl = this.ntsm.connect(byArray, n);
        this.chooseManager(1);
        return bl;
    }

    private void chooseManager(int n) {
        if (n == 0) {
            this.choice = this.usbsm;
            this.connectContext = 0;
        } else if (n == 1) {
            this.choice = this.ntsm;
            this.connectContext = 1;
        }
    }

    @Override
    public int write(byte[] byArray, int n) {
        return this.choice.write(byArray, n);
    }

    @Override
    public int retryTimes() {
        if (this.choice == null) {
            return 3;
        }
        return this.choice.retryTimes();
    }

    @Override
    public boolean tryRescue() {
        return this.choice.tryRescue();
    }

    @Override
    public int acceptResponse(byte[] byArray, int n) {
        return this.choice.acceptResponse(byArray, n);
    }

    public int getRecommendPeriod() {
        if (this.connectContext == 0) {
            return 0;
        }
        return 0;
    }

    public void connectAfterReboot() {
        IDevice iDevice2;
        String string = this.usbsm.getUsbSN();
        int n = 0;
        int n2 = 0;
        block2: while (true) {
            List<IDevice> list;
            if ((n = (list = this.usbsm.refreshUSBPort()).size()) > 0) {
                for (IDevice iDevice2 : list) {
                    if (!iDevice2.getSerialNumber().equalsIgnoreCase(string)) continue;
                    break block2;
                }
            }
            if (++n2 > 10) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        IDevice iDevice3 = iDevice2;
        this.connectUSB(iDevice3);
    }
}

