/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.comm.detect;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.source.comm.InfiniteDaemon;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.dso.source.comm.detect.CheckUSBPortsPane;
import com.owon.uppersoft.dso.source.usb.USBSourceManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.usb.IDevice;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

public class USBLoopChecker {
    public static final int TimeBetweenTwiceCheckUSB = 800;
    private CheckUSBPortsPane cup = null;
    private boolean noDisturb;
    private boolean noCheck = false;
    private MainWindow mw;
    private ControlManager cm;
    private InfiniteDaemon dae;
    private USBSourceManager usbsm;
    private List<IDevice> ids;

    public USBLoopChecker(ControlManager controlManager, USBSourceManager uSBSourceManager, MainWindow mainWindow, InfiniteDaemon infiniteDaemon) {
        this.mw = mainWindow;
        this.cm = controlManager;
        this.dae = infiniteDaemon;
        this.usbsm = uSBSourceManager;
        this.noDisturb = false;
    }

    public void runInstallBat() {
    }

    public void setNoDisturb(boolean bl) {
        this.noDisturb = bl;
    }

    public void setNoCheck(boolean bl) {
        this.noCheck = bl;
    }

    public boolean isNoCheck() {
        return this.noCheck;
    }

    public List<IDevice> getDeviceList() {
        return this.ids;
    }

    public void checkUSBDevice() {
        if (this.isNoCheck()) {
            return;
        }
        this.ids = this.usbsm.refreshUSBPort();
        if (this.ids == null) {
            this.mw.updateStatus(TrgStatus.USBDrvErr);
            return;
        }
        int n = this.ids.size();
        if (this.cup != null) {
            this.cup.updateList(this.ids);
            return;
        }
        this.mw.updateStatus(this.noDisturb ? n : -n, n > 0 ? TrgStatus.USBFound : TrgStatus.Offline);
        if (n <= 0) {
            return;
        }
        if (this.noDisturb) {
            return;
        }
        if (!this.cm.isExit()) {
            this.defaultInitLink();
        }
    }

    public void promptUSBPorts(List<IDevice> list, USBLoopChecker uSBLoopChecker) {
        this.cup = new CheckUSBPortsPane(list, uSBLoopChecker){

            @Override
            public void clickToConnect(IDevice iDevice) {
                USBLoopChecker.this.dae.initLink(iDevice);
            }
        };
        this.cup.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("LastPromptDispose")) {
                    USBLoopChecker.this.cup = null;
                    USBLoopChecker.this.mw.getFrame().toFront();
                }
            }
        });
        this.mw.prompt(this.cup, new Runnable(){

            @Override
            public void run() {
                USBLoopChecker.this.defaultInitLink();
            }
        });
    }

    public void defaultInitLink() {
        if (this.ids != null && this.ids.size() == 1) {
            this.dae.initLink(this.ids.get(0));
        }
    }

    public void ignoreCheckResult() {
        this.setNoDisturb(true);
        this.mw.getITitleStatus().exposeTrgStatus();
        this.mw.promptUp();
    }
}

