/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.comm.detect;

import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PromptPlace
extends JPanel
implements PropertyChangeListener {
    public static final String ProgressStart = "ProgressStart";
    public static final String ProgressIncrease = "ProgressIncrease";
    public static final String ProgressDone = "ProgressDone";
    protected JLabel lbl;
    protected JTextArea infoarea;
    protected ControlManager cm;

    public PromptPlace(ControlManager controlManager) {
        this.cm = controlManager;
        this.setLayout(null);
        this.lbl = new JLabel();
        this.lbl.setBounds(0, 0, 350, 25);
        this.infoarea = new JTextArea();
        this.infoarea.setBounds(0, 25, 350, 100);
        this.infoarea.setBackground(this.getBackground());
        this.infoarea.setEditable(false);
        this.infoarea.setLineWrap(true);
        this.infoarea.setWrapStyleWord(true);
        this.add(this.lbl);
        this.add(this.infoarea);
        this.infoarea.setText(I18nProvider.bundle().getString("Label.connect"));
        this.setPreferredSize(new Dimension(350, 150));
    }

    protected String machineInformation() {
        StringBuilder stringBuilder = new StringBuilder();
        SoftwareControl softwareControl = this.cm.getSoftwareControl();
        stringBuilder.append("version: " + softwareControl.getBoardVersion() + "series: " + softwareControl.getBoardSeries() + ":\r\n");
        return stringBuilder.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("Status")) {
            this.lbl.setText(propertyChangeEvent.getNewValue().toString());
        } else if (string.equals("Info")) {
            this.infoarea.setText("");
        }
    }
}

