/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.comm.detect;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.dso.source.comm.detect.PromptPlace;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.usb.IDevice;

public class InitLinkRunner
implements Runnable {
    private IDevice id;
    private MainWindow mw;
    private ControlManager cm;

    public InitLinkRunner(MainWindow mainWindow, ControlManager controlManager) {
        this.mw = mainWindow;
        this.cm = controlManager;
    }

    public void setDevice(IDevice iDevice) {
        this.id = iDevice;
    }

    public boolean hasDevice() {
        return this.id != null;
    }

    public String toString() {
        return "m_initlink";
    }

    @Override
    public void run() {
        if (!this.cm.sourceManager.isConnected()) {
            this.initLink(this.id, this.cm, this.mw);
        }
        this.id = null;
    }

    private void initLink(IDevice iDevice, ControlManager controlManager, MainWindow mainWindow) {
        mainWindow.updateStatus(TrgStatus.Linking);
        PromptPlace promptPlace = controlManager.createPromptPlace();
        mainWindow.prompt(promptPlace, null);
        boolean bl = controlManager.sourceManager.connectUSB(iDevice);
        if (!bl) {
            mainWindow.updateStatus(TrgStatus.Offline);
            return;
        }
        mainWindow.updateStatus(TrgStatus.Connect);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Platform.getControlApps().interComm.initMachine(promptPlace);
    }
}

