/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.comm.detect;

import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.source.comm.detect.USBLoopChecker;
import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.uppersoft.vds.util.ui.CListModel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CheckUSBPortsPane
extends JPanel {
    public Font alphafont = new Font("SansSerif", 0, 14);
    private CListModel plm;
    private JList jlist;
    private JScrollPane jsp;

    public CheckUSBPortsPane(final List<IDevice> list, final USBLoopChecker uSBLoopChecker) {
        this.setLayout(null);
        final JPanel jPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                int n = this.getWidth();
                graphics.setColor(Color.black);
                graphics.drawString("[ X ]", n - 30, 20);
                graphics.setFont(CheckUSBPortsPane.this.alphafont);
                graphics.drawString(I18nProvider.bundle().getString("M.Connection.chooseUSB"), 10, 20);
            }
        };
        jPanel.setBounds(0, 0, 400, 30);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = jPanel.getWidth();
                int n2 = mouseEvent.getX();
                if (n2 > n - 30 && n2 < n) {
                    uSBLoopChecker.ignoreCheckResult();
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = jPanel.getWidth();
                int n2 = mouseEvent.getX();
                if (n2 > n - 30 && n2 < n) {
                    jPanel.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    jPanel.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        jPanel.addMouseListener(mouseAdapter);
        jPanel.addMouseMotionListener(mouseAdapter);
        this.add(jPanel);
        this.jsp = new JScrollPane();
        this.plm = new CListModel(list){

            @Override
            public Object getElementAt(int n) {
                return "device (" + (n + 1) + ")";
            }
        };
        this.jlist = new JList(this.plm);
        this.jlist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IDevice iDevice;
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                if (n < CheckUSBPortsPane.this.plm.getSize() && (iDevice = (IDevice)list.get(n)) != null) {
                    CheckUSBPortsPane.this.clickToConnect(iDevice);
                }
            }
        });
        this.jsp.add(this.jlist);
        this.jsp.setViewportView(this.jlist);
        this.jsp.setBounds(0, 30, 400, 170);
        this.add(this.jsp);
        Dimension dimension = new Dimension(400, 200);
        this.setPreferredSize(dimension);
    }

    public void clickToConnect(IDevice iDevice) {
    }

    public void updateList(List<IDevice> list) {
        this.plm.setList(list);
        this.jlist.setModel(this.plm);
        this.jlist.repaint();
    }
}

