/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.comm;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.source.comm.DefaultUSBCheckHelper;
import com.owon.uppersoft.dso.source.comm.InfiniteDaemon;
import com.owon.uppersoft.dso.source.comm.detect.USBLoopChecker;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.usb.help.ContextMenuManager;
import java.util.ResourceBundle;

public class USBDaemonHelper {
    private InfiniteDaemon dmn;
    private ControlManager cm;
    private USBLoopChecker uc;
    private ContextMenuManager ctxMenu;

    public USBDaemonHelper(InfiniteDaemon infiniteDaemon, ControlManager controlManager, MainWindow mainWindow, ContextMenuManager contextMenuManager) {
        this.dmn = infiniteDaemon;
        this.cm = controlManager;
        this.ctxMenu = contextMenuManager;
        this.uc = new USBLoopChecker(controlManager, controlManager.sourceManager.getUSBSourceManager(), mainWindow, infiniteDaemon);
        if (controlManager.reloadManager.isReload()) {
            this.setNoDisturb(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotConnecting() {
        USBLoopChecker uSBLoopChecker = this.uc;
        synchronized (uSBLoopChecker) {
            if (!this.dmn.m_initlink.hasDevice()) {
                this.uc.checkUSBDevice();
            }
        }
        if (!this.dmn.m_initlink.hasDevice()) {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClickStatus(int n, int n2) {
        int n3 = n;
        ResourceBundle resourceBundle = I18nProvider.bundle();
        DefaultUSBCheckHelper defaultUSBCheckHelper = new DefaultUSBCheckHelper(this.dmn, this.uc);
        USBLoopChecker uSBLoopChecker = this.uc;
        synchronized (uSBLoopChecker) {
            if (n2 == 3) {
                this.ctxMenu.showContextMenu_RightClick(defaultUSBCheckHelper, n3, resourceBundle);
                return;
            }
            if (this.cm.sourceManager.isConnected()) {
                this.ctxMenu.showContextMenu_Online(defaultUSBCheckHelper, n3, resourceBundle);
            } else {
                this.ctxMenu.showContextMenu_Offline(defaultUSBCheckHelper, n3, resourceBundle);
            }
        }
    }

    public void setNoDisturb(boolean bl) {
        this.uc.setNoDisturb(bl);
    }
}

