/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.comm;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.machine.aspect.IStopable;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.source.comm.AbsGetDataRunner;
import com.owon.uppersoft.dso.source.comm.AbsInterCommunicator;
import com.owon.uppersoft.dso.source.comm.Flow;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.dso.source.comm.detect.InitLinkRunner;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.dso.view.ChartScreen;
import com.owon.uppersoft.dso.view.ITitleStatus;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.vds.core.comm.JobQueueDispatcher;
import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.uppersoft.vds.core.wf.rt.ChannelsTransportInfo;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfiniteDaemon
extends Flow {
    private MainWindow mw;
    protected ControlManager cm;
    private AbsInterCommunicator ic;
    private IStopable ca;
    private long tbeg;
    private long tend;
    private long del;
    private int failure;
    private int longWait;
    private int midWait;
    public Runnable m_startGet = new Runnable(){

        public String toString() {
            return "m_startGet";
        }

        @Override
        public void run() {
            InfiniteDaemon.this.tbeg = System.currentTimeMillis();
            InfiniteDaemon.this.failure = 0;
            InfiniteDaemon.this.gdr.prepareToRun();
            InfiniteDaemon.this.ic.setPreStop(false);
            InfiniteDaemon.this.rewindAfterStop();
            InfiniteDaemon.this.mw.promptUp();
            InfiniteDaemon.this.its.enableBtns();
            InfiniteDaemon.this.ir.setKeepGet(true);
            InfiniteDaemon.this.its.updateView();
        }
    };
    public Runnable m_reInit = new Runnable(){

        @Override
        public void run() {
            InfiniteDaemon.this.ic.initMachine(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                }
            });
        }
    };
    public Runnable m_afterStop = new Runnable(){

        public String toString() {
            return "m_afterStop";
        }

        @Override
        public void run() {
            InfiniteDaemon.this.gdr.release();
            InfiniteDaemon.this.tend = System.currentTimeMillis();
            InfiniteDaemon.this.del = InfiniteDaemon.this.tend - InfiniteDaemon.this.tbeg;
            int n = InfiniteDaemon.this.gdr.getChannelsTransportInfo().frameAllNum;
            if (n != 0) {
                DBG.dbgln(n + " WaveForms on Rate: " + InfiniteDaemon.this.del / (long)n + " ms/f");
            } else {
                DBG.dbgln(n + " WaveForms for : " + InfiniteDaemon.this.del + " ms");
            }
            if (InfiniteDaemon.this.isAfterStop()) {
                try {
                    Thread.sleep(InfiniteDaemon.this.longWait);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                InfiniteDaemon.this.ic.afterkeepload();
                InfiniteDaemon.this.its.confirmStopStatus();
            }
        }
    };
    public PromptErrNDisConnectRunner pce = new PromptErrNDisConnectRunner();
    public InitLinkRunner m_initlink;
    protected ChartScreen cs;
    private boolean afterStop = false;
    private ITitleStatus its;

    public InfiniteDaemon(DataHouse dataHouse, MainWindow mainWindow, JobQueueDispatcher jobQueueDispatcher, AbsInterCommunicator absInterCommunicator, IStopable iStopable, AbsGetDataRunner absGetDataRunner) {
        super(dataHouse.controlManager, absGetDataRunner, jobQueueDispatcher, dataHouse.controlManager.getIRuntime());
        this.mw = mainWindow;
        this.ic = absInterCommunicator;
        this.ca = iStopable;
        this.its = mainWindow.getITitleStatus();
        this.cm = dataHouse.controlManager;
        this.cs = mainWindow.getChartScreen();
        this.midWait = 50;
        this.longWait = 1000;
        this.m_initlink = new InitLinkRunner(mainWindow, this.cm);
    }

    public void promptTxt(String string) {
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 15));
        jPanel.add(new JLabel(string + "   [ X ]"));
        jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                InfiniteDaemon.this.mw.promptUp();
            }
        });
        this.mw.prompt(jPanel, null);
    }

    public void reInit() {
        this.addMission(this.m_reInit);
    }

    public void initLink(IDevice iDevice) {
        this.m_initlink.setDevice(iDevice);
        this.addMission(this.m_initlink);
    }

    public void activeStopGet() {
        this.ca.stopkeep();
        this.addMission(this.m_afterStop);
    }

    public void askConnectUSB(IDevice iDevice) {
        this.m_initlink.setDevice(iDevice);
        this.addMission(this.m_initlink);
    }

    @Override
    protected void afterTryGet(ChannelsTransportInfo channelsTransportInfo) throws InterruptedException {
        int n = channelsTransportInfo.status;
        if (n == 0) {
            this.onSucess(channelsTransportInfo);
            if (channelsTransportInfo.getFrameCount() <= 0) {
                InfiniteDaemon.sleep(40L);
            }
        } else {
            this.onFail(channelsTransportInfo);
            this.vl.logln("sleep " + this.midWait + " ms on fail");
            InfiniteDaemon.sleep(this.midWait);
        }
    }

    private final void onSucess(ChannelsTransportInfo channelsTransportInfo) {
        TriggerControl triggerControl = this.cm.getTriggerControl();
        this.failure = 0;
        int n = channelsTransportInfo.triggerStatus;
        TrgStatus trgStatus = TrgStatus.VALUES[n];
        this.cm.curTrgStatus = n;
        int n2 = channelsTransportInfo.getFrameCount();
        if (trgStatus == TrgStatus.Stop) {
            DBG.dbg("receive Stop TrgStatus!");
            if (this.ic.isPreStop()) {
                channelsTransportInfo.checkReady();
                this.realStop();
            } else if (triggerControl.isSweepOnce()) {
                this.markAfterStop();
                this.activeStopGet();
                this.its.applyStop();
            }
        }
        channelsTransportInfo.frameAllNum += n2;
        if (channelsTransportInfo.frameAllNum >= 100000000) {
            channelsTransportInfo.frameAllNum = 0;
            this.tbeg = System.currentTimeMillis();
        }
        this.cm.pcs.firePropertyChange("updateFrameCounter", channelsTransportInfo.frameAllNum, channelsTransportInfo.points);
    }

    public void realStop() {
        this.ic.setPreStop(false);
        this.markAfterStop();
        this.activeStopGet();
        this.its.confirmStopStatus();
    }

    private final void onFail(ChannelsTransportInfo channelsTransportInfo) {
        channelsTransportInfo.updateStatus(channelsTransportInfo.status);
        ++this.failure;
        if (this.failure >= this.cm.sourceManager.retryTimes()) {
            DBG.seversln("onFail: " + new Date());
            DBG.seversln("tryRescue...");
            if (this.cm.sourceManager.tryRescue()) {
                this.ic.initMachine(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    }
                });
            } else {
                DBG.seversln("tryRescue fail");
                this.pce.setPromptTxt(I18nProvider.bundle().getString("Label.WriteContentErr"));
                this.ca.stopkeepNForbidDM();
                this.addMission(this.pce);
            }
            this.failure = 0;
            return;
        }
        if (this.failure >= this.cm.maxFailureTime) {
            int n = channelsTransportInfo.getStatistics();
            switch (n) {
                case 3: {
                    this.pce.setPromptTxt(I18nProvider.bundle().getString("Label.ConnectErr"));
                    this.ca.stopkeepNForbidDM();
                    this.addMission(this.pce);
                    break;
                }
                case 2: 
                case 4: {
                    this.pce.setPromptTxt(I18nProvider.bundle().getString("Label.ReadOrWriteContentErr"));
                    this.ca.stopkeepNForbidDM();
                    this.addMission(this.pce);
                    break;
                }
                case 1: {
                    this.pce.setPromptTxt(I18nProvider.bundle().getString("Label.UnknownErr"));
                    this.ca.stopkeepNForbidDM();
                    this.addMission(this.pce);
                }
            }
            this.failure = 0;
        }
    }

    public boolean isAfterStop() {
        return this.afterStop;
    }

    protected void markAfterStop() {
        this.afterStop = true;
    }

    protected void rewindAfterStop() {
        this.afterStop = false;
    }

    public void onClickStatus(int n, int n2) {
    }

    @Override
    public ChannelsTransportInfo getChannelsTransportInfo() {
        return this.gdr.getChannelsTransportInfo();
    }

    @Override
    public AbsGetDataRunner getAbsGetDataRunner() {
        return this.gdr;
    }

    public void onExit(Pref pref) {
    }

    private final class PromptErrNDisConnectRunner
    implements Runnable {
        private String promptTxt;

        private PromptErrNDisConnectRunner() {
        }

        public String toString() {
            return "m_promptNDisConnectConnErr";
        }

        public void setPromptTxt(String string) {
            this.promptTxt = string;
        }

        @Override
        public void run() {
            InfiniteDaemon.this.promptTxt(this.promptTxt);
            InfiniteDaemon.this.m_dislink.run();
        }
    }
}

