/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.source.comm;

import com.owon.uppersoft.dso.data.AbsDataSaver;
import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.mode.control.SysControl;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.source.comm.TrgStatus;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.ToolPane;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.ui.window.ProgressIndeterminateDialog;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ResourceBundle;

public abstract class AbsInterCommunicator {
    protected DataHouse dh;
    protected MainWindow mw;
    protected ControlApps ca;
    protected ControlManager cm;
    protected CoreControl cc;
    public static final File dmf = new File(Platform.TMP_DIR, "owon-vds-dm.bin");
    private boolean preStop = false;
    private boolean isAutosetting = false;

    public AbsInterCommunicator(DataHouse dataHouse, MainWindow mainWindow, ControlApps controlApps) {
        this.dh = dataHouse;
        this.mw = mainWindow;
        this.ca = controlApps;
        this.cm = dataHouse.controlManager;
        this.cc = this.cm.getCoreControl();
    }

    public ControlManager getControlManager() {
        return this.cm;
    }

    public void prepare2PersistDMData() {
        this.dh.releaseDeepMemoryStorage();
        dmf.delete();
        if (dmf.exists()) {
            DBG.errprintln("dmf.exists");
        }
    }

    public abstract void queryALL();

    public abstract void onExport_get();

    public abstract void rebootMachine();

    protected abstract void doSyncFactorySet2Machine();

    public abstract boolean isTimeOperatableNTryGetDM();

    public abstract boolean initMachine(PropertyChangeListener var1);

    public void afterkeepload() {
    }

    protected abstract void invokeLater_Autoset(Runnable var1);

    protected void dbg(String string) {
        DBG.dbg(string);
    }

    protected void dbgln(String string) {
        DBG.dbgln(string);
    }

    public void syncDetail() {
        this.syncDetail(null);
    }

    public void syncDetail(Runnable runnable) {
        Submitable submitable = SubmitorFactory.reInit();
        this.cm.syncDetail(submitable);
        submitable.applyThen(runnable);
    }

    public void initDetail() {
        Submitable submitable = SubmitorFactory.reInit();
        this.cm.initDetail(submitable);
        submitable.apply();
    }

    public void syncFactorySet2Machine() {
        if (this.cm.isRuntimeStop()) {
            this.statusRun(false, true);
        }
        this.doSyncFactorySet2Machine();
    }

    public void statusStop(boolean bl) {
        this.cm.pcs.firePropertyChange("OPERATE_STOP", null, null);
        SubmitorFactory.getSubmitable().sendStopThen(new Runnable(){

            @Override
            public void run() {
                AbsInterCommunicator.this.mw.updateStatus(TrgStatus.Stop);
                AbsInterCommunicator.this.setPreStop(true);
                AbsInterCommunicator.this.cm.getDeepMemoryControl().applyFPGADeepIdx();
            }
        });
    }

    public void statusRun(boolean bl, boolean bl2) {
        this.cm.pcs.firePropertyChange("OPERATE_RUN", null, null);
        TriggerControl triggerControl = this.cc.getTriggerControl();
        if (bl2 && triggerControl.resumeAuto()) {
            this.cm.pcs.firePropertyChange("T_SweepOnce2Auto", null, null);
        }
        this.ca.setDMDataGotAlready(false);
        SubmitorFactory.getSubmitable().sendRun();
        if (bl) {
            this.syncChannels();
        }
        this.ca.keepload();
    }

    protected void syncChannels() {
        Submitable submitable = SubmitorFactory.reInit();
        this.cc.getWaveFormInfoControl().selfSubmit(submitable);
        submitable.apply();
    }

    public void setPreStop(boolean bl) {
        this.preStop = bl;
    }

    public boolean isPreStop() {
        return this.preStop;
    }

    public void sync_pf(int n) {
        SysControl sysControl = this.cc.getSysControl();
        if (sysControl.getSyncOutput() != 2) {
            return;
        }
        SubmitorFactory.getSubmitable().sync_pf(n);
    }

    private void updateForAutoSet() {
        PropertyChangeSupport propertyChangeSupport = this.cm.pcs;
        propertyChangeSupport.firePropertyChange("APPLY_SAMPLING", null, null);
        this.cm.resetPersistence();
        ToolPane toolPane = this.mw.getToolPane();
        propertyChangeSupport.firePropertyChange("APPLY_TRIGGER", null, null);
        toolPane.updateTrgVolt();
        propertyChangeSupport.firePropertyChange("APPLY_CHANNELS", null, null);
        toolPane.updateChannels();
        propertyChangeSupport.firePropertyChange("APPLY_TIMEBASE", null, null);
        propertyChangeSupport.firePropertyChange("APPLY_DEEPMEMORY", null, null);
        propertyChangeSupport.firePropertyChange("onTimebaseUpdated", null, null);
        this.cc.updateCurrentSampleRate();
        propertyChangeSupport.firePropertyChange("sampleRateUpdated", null, null);
        this.cm.notifyShouldEnableTrg();
        this.cm.updateExportbtnEnable(true);
        this.mw.updateShow();
        this.mw.re_paint();
    }

    public boolean autoset() {
        if (this.isAutosetting) {
            return false;
        }
        if (!this.cm.sourceManager.isConnected()) {
            return false;
        }
        this.isAutosetting = true;
        this.ca.getOperateBlocker().block();
        this.cm.pcs.firePropertyChange("START_AUTOSET", null, null);
        if (this.cm.isRuntimeStop()) {
            this.statusRun(false, true);
        }
        ResourceBundle resourceBundle = I18nProvider.bundle();
        String string = resourceBundle.getString("Action.Cancel");
        String string2 = resourceBundle.getString("Label.Cancel");
        String string3 = resourceBundle.getString("M.AutoSet");
        final ProgressIndeterminateDialog progressIndeterminateDialog = new ProgressIndeterminateDialog(this.mw.getFrame(), true, string3, string, string2);
        progressIndeterminateDialog.startIndeterminateDlg();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbsInterCommunicator.this.updateForAutoSet();
                progressIndeterminateDialog.close();
                AbsInterCommunicator.this.cm.pcs.firePropertyChange("STOP_AUTOSET", null, null);
                AbsInterCommunicator.this.ca.getOperateBlocker().kickThrough();
                AbsInterCommunicator.this.isAutosetting = false;
            }
        };
        this.invokeLater_Autoset(runnable);
        return true;
    }

    public abstract AbsDataSaver createDatasaver();

    public boolean tryToPersistDMData() {
        return false;
    }
}

